/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.WkbSerializationProxy;
import com.datastax.shaded.esri.ogc.OGCPoint;
import java.nio.ByteBuffer;

public class Point
extends Geometry {
    private static final long serialVersionUID = 6329957740309318716L;

    public static Point fromWellKnownText(String source) {
        return new Point(Point.fromOgcWellKnownText(source, OGCPoint.class));
    }

    public static Point fromWellKnownBinary(ByteBuffer source) {
        return new Point(Point.fromOgcWellKnownBinary(source, OGCPoint.class));
    }

    public static Point fromGeoJson(String source) {
        return new Point(Point.fromOgcGeoJson(source, OGCPoint.class));
    }

    public Point(double x, double y) {
        this(new OGCPoint(new com.datastax.shaded.esri.Point(x, y), Geometry.SPATIAL_REFERENCE_4326));
    }

    Point(OGCPoint point) {
        super(point);
    }

    @Override
    OGCPoint getOgcGeometry() {
        return (OGCPoint)super.getOgcGeometry();
    }

    public double X() {
        return this.getOgcGeometry().X();
    }

    public double Y() {
        return this.getOgcGeometry().Y();
    }

    private Object writeReplace() {
        return new WkbSerializationProxy(this.asWellKnownBinary());
    }
}

