/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.dse.graph.GraphProtocol;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.PayloadHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;

public class GraphOptions {
    static final String GRAPH_SOURCE_KEY = "graph-source";
    static final String GRAPH_NAME_KEY = "graph-name";
    static final String GRAPH_LANGUAGE_KEY = "graph-language";
    static final String GRAPH_READ_CONSISTENCY_KEY = "graph-read-consistency";
    static final String GRAPH_WRITE_CONSISTENCY_KEY = "graph-write-consistency";
    static final String REQUEST_TIMEOUT_KEY = "request-timeout";
    static final String GRAPH_RESULTS_KEY = "graph-results";
    public static final String DEFAULT_GRAPH_LANGUAGE = "gremlin-groovy";
    public static final String DEFAULT_GRAPH_SOURCE = "g";
    private volatile String graphLanguage = "gremlin-groovy";
    private volatile String graphSource = "g";
    private volatile String graphName;
    private volatile ConsistencyLevel graphReadConsistency;
    private volatile ConsistencyLevel graphWriteConsistency;
    private volatile Map<String, ByteBuffer> defaultPayload;
    private volatile int readTimeoutMillis = 0;
    private volatile GraphProtocol graphSubProtocol = GraphProtocol.GRAPHSON_1_0;

    public GraphOptions() {
        this.rebuildDefaultPayload();
    }

    public String getGraphLanguage() {
        return this.graphLanguage;
    }

    public GraphOptions setGraphLanguage(String graphLanguage) {
        Preconditions.checkNotNull((Object)graphLanguage, (Object)"graphLanguage cannot be null");
        this.graphLanguage = graphLanguage;
        this.rebuildDefaultPayload();
        return this;
    }

    public String getGraphSource() {
        return this.graphSource;
    }

    public GraphOptions setGraphSource(String graphSource) {
        Preconditions.checkNotNull((Object)graphSource, (Object)"graphSource cannot be null");
        this.graphSource = graphSource;
        this.rebuildDefaultPayload();
        return this;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public GraphOptions setGraphName(String graphName) {
        this.graphName = graphName;
        this.rebuildDefaultPayload();
        return this;
    }

    public ConsistencyLevel getGraphReadConsistencyLevel() {
        return this.graphReadConsistency;
    }

    public GraphOptions setGraphReadConsistencyLevel(ConsistencyLevel cl) {
        this.graphReadConsistency = cl;
        this.rebuildDefaultPayload();
        return this;
    }

    public ConsistencyLevel getGraphWriteConsistencyLevel() {
        return this.graphWriteConsistency;
    }

    public GraphOptions setGraphWriteConsistencyLevel(ConsistencyLevel cl) {
        this.graphWriteConsistency = cl;
        this.rebuildDefaultPayload();
        return this;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public GraphOptions setReadTimeoutMillis(int readTimeoutMillis) {
        Preconditions.checkArgument((readTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"readTimeoutMillis can not be negative");
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public GraphOptions setGraphSubProtocol(GraphProtocol graphSubProtocol) {
        this.graphSubProtocol = graphSubProtocol;
        return this;
    }

    public GraphProtocol getGraphSubProtocol() {
        return this.graphSubProtocol;
    }

    public Map<String, ByteBuffer> buildPayloadWithDefaults(GraphStatement statement) {
        if (statement.getGraphLanguage() == null && statement.getGraphSource() == null && statement.getGraphReadConsistencyLevel() == null && statement.getGraphWriteConsistencyLevel() == null && statement.getGraphName() == null && statement.getGraphInternalOptions().size() == 0 && !statement.isSystemQuery() && this.graphSubProtocol == GraphProtocol.GRAPHSON_1_0) {
            return this.defaultPayload;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.setOrDefaultText((ImmutableMap.Builder<String, ByteBuffer>)builder, GRAPH_LANGUAGE_KEY, statement.getGraphLanguage());
        this.setOrDefaultText((ImmutableMap.Builder<String, ByteBuffer>)builder, GRAPH_SOURCE_KEY, statement.getGraphSource());
        this.setOrDefaultCl((ImmutableMap.Builder<String, ByteBuffer>)builder, GRAPH_READ_CONSISTENCY_KEY, statement.getGraphReadConsistencyLevel());
        this.setOrDefaultCl((ImmutableMap.Builder<String, ByteBuffer>)builder, GRAPH_WRITE_CONSISTENCY_KEY, statement.getGraphWriteConsistencyLevel());
        if (!statement.isSystemQuery()) {
            this.setOrDefaultText((ImmutableMap.Builder<String, ByteBuffer>)builder, GRAPH_NAME_KEY, statement.getGraphName());
        }
        if (statement.getReadTimeoutMillis() > 0) {
            this.setOrDefaultBigInt((ImmutableMap.Builder<String, ByteBuffer>)builder, REQUEST_TIMEOUT_KEY, Long.valueOf(statement.getReadTimeoutMillis()));
        }
        if (this.graphSubProtocol != GraphProtocol.GRAPHSON_1_0) {
            this.setOrDefaultText((ImmutableMap.Builder<String, ByteBuffer>)builder, GRAPH_RESULTS_KEY, this.graphSubProtocol.getProtocolReference());
        }
        for (Map.Entry<String, String> optionEntry : statement.getGraphInternalOptions().entrySet()) {
            this.setOrDefaultText((ImmutableMap.Builder<String, ByteBuffer>)builder, optionEntry.getKey(), optionEntry.getValue());
        }
        return builder.build();
    }

    void setOrDefaultText(ImmutableMap.Builder<String, ByteBuffer> builder, String key, String value) {
        ByteBuffer bytes;
        ByteBuffer byteBuffer = bytes = value == null ? this.defaultPayload.get(key) : PayloadHelper.asBytes(value);
        if (bytes != null) {
            builder.put((Object)key, (Object)bytes);
        }
    }

    private void setOrDefaultCl(ImmutableMap.Builder<String, ByteBuffer> builder, String key, ConsistencyLevel value) {
        ByteBuffer bytes;
        ByteBuffer byteBuffer = bytes = value == null ? this.defaultPayload.get(key) : PayloadHelper.asBytes(value.name());
        if (bytes != null) {
            builder.put((Object)key, (Object)bytes);
        }
    }

    private void setOrDefaultBigInt(ImmutableMap.Builder<String, ByteBuffer> builder, String key, Long value) {
        ByteBuffer bytes;
        ByteBuffer byteBuffer = bytes = value == null ? this.defaultPayload.get(key) : PayloadHelper.asBytes(value);
        if (bytes != null) {
            builder.put((Object)key, (Object)bytes);
        }
    }

    void rebuildDefaultPayload() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)GRAPH_LANGUAGE_KEY, (Object)PayloadHelper.asBytes(this.graphLanguage));
        builder.put((Object)GRAPH_SOURCE_KEY, (Object)PayloadHelper.asBytes(this.graphSource));
        if (this.graphName != null) {
            builder.put((Object)GRAPH_NAME_KEY, (Object)PayloadHelper.asBytes(this.graphName));
        }
        if (this.graphReadConsistency != null) {
            builder.put((Object)GRAPH_READ_CONSISTENCY_KEY, (Object)PayloadHelper.asBytes(this.graphReadConsistency.name()));
        }
        if (this.graphWriteConsistency != null) {
            builder.put((Object)GRAPH_WRITE_CONSISTENCY_KEY, (Object)PayloadHelper.asBytes(this.graphWriteConsistency.name()));
        }
        this.defaultPayload = builder.build();
    }
}

