/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.GraphNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.List;

public class GraphResultSet
implements Iterable<GraphNode> {
    static final Function<Row, GraphNode> ROW_TO_DEFAULTGRAPHNODE = new Function<Row, GraphNode>(){

        public GraphNode apply(Row row) {
            if (row != null) {
                String jsonString = row.getString("gremlin");
                try {
                    return GraphJsonUtils.readStringAsTree(jsonString).get("result");
                }
                catch (RuntimeException e) {
                    throw new DriverException("Could not parse the result returned by the Graph server as a JSON string : " + jsonString, e);
                }
            }
            return null;
        }
    };
    private final ResultSet wrapped;
    private final Function<Row, GraphNode> transformResultFunction;

    public GraphResultSet(ResultSet wrapped) {
        this(wrapped, ROW_TO_DEFAULTGRAPHNODE);
    }

    public GraphResultSet(ResultSet wrapped, Function<Row, GraphNode> transformResultFunction) {
        this.wrapped = wrapped;
        this.transformResultFunction = transformResultFunction;
    }

    public boolean isExhausted() {
        return this.wrapped.isExhausted();
    }

    public GraphNode one() {
        return (GraphNode)this.transformResultFunction.apply((Object)this.wrapped.one());
    }

    public List<GraphNode> all() {
        return Lists.transform(this.wrapped.all(), this.transformResultFunction);
    }

    @Override
    public Iterator<GraphNode> iterator() {
        return new Iterator<GraphNode>(){

            @Override
            public boolean hasNext() {
                return !GraphResultSet.this.wrapped.isExhausted();
            }

            @Override
            public GraphNode next() {
                return GraphResultSet.this.one();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getAvailableWithoutFetching() {
        return this.wrapped.getAvailableWithoutFetching();
    }

    public boolean isFullyFetched() {
        return this.wrapped.isFullyFetched();
    }

    public ListenableFuture<GraphResultSet> fetchMoreResults() {
        return Futures.transform(this.wrapped.fetchMoreResults(), (Function)new Function<ResultSet, GraphResultSet>(){

            public GraphResultSet apply(ResultSet input) {
                return new GraphResultSet(input, (Function<Row, GraphNode>)GraphResultSet.this.transformResultFunction);
            }
        });
    }

    public ExecutionInfo getExecutionInfo() {
        return this.wrapped.getExecutionInfo();
    }

    public List<ExecutionInfo> getAllExecutionInfo() {
        return this.wrapped.getAllExecutionInfo();
    }
}

