/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.AbstractObjectDeserializer;
import com.datastax.driver.dse.graph.ContextualDelegateParser;
import com.datastax.driver.dse.graph.DefaultEdge;
import com.datastax.driver.dse.graph.DefaultPath;
import com.datastax.driver.dse.graph.DefaultProperty;
import com.datastax.driver.dse.graph.DefaultVertex;
import com.datastax.driver.dse.graph.DefaultVertexProperty;
import com.datastax.driver.dse.graph.Edge;
import com.datastax.driver.dse.graph.Element;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphSON2JacksonModule;
import com.datastax.driver.dse.graph.GremlinContextualJsonParser;
import com.datastax.driver.dse.graph.ObjectGraphNode;
import com.datastax.driver.dse.graph.Path;
import com.datastax.driver.dse.graph.Property;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.core.JsonProcessingException;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import com.datastax.shaded.jackson.databind.ser.std.StdScalarSerializer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GraphSON2GremlinDriverModule
extends GraphSON2JacksonModule {
    GraphSON2GremlinDriverModule() {
        super("graph-graphson2gremlin");
        this.addSerializer(Integer.class, new IntegerGraphSONSerializer());
        this.addSerializer(Double.class, new DoubleGraphSONSerializer());
        this.addDeserializer(Vertex.class, new VertexGraphSON2Deserializer());
        this.addDeserializer(VertexProperty.class, new VertexPropertyGraphSON2Deserializer());
        this.addDeserializer(Property.class, new PropertyGraphSON2Deserializer());
        this.addDeserializer(Edge.class, new EdgeGraphSON2Deserializer());
        this.addDeserializer(Path.class, new PathGraphSON2Deserializer());
    }

    @Override
    public Map<Class<?>, String> getTypeDefinitions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Integer.class, (Object)"Int32");
        builder.put(Long.class, (Object)"Int64");
        builder.put(Double.class, (Object)"Double");
        builder.put(Float.class, (Object)"Float");
        builder.put(Vertex.class, (Object)"Vertex");
        builder.put(VertexProperty.class, (Object)"VertexProperty");
        builder.put(Property.class, (Object)"Property");
        builder.put(Edge.class, (Object)"Edge");
        builder.put(Path.class, (Object)"Path");
        builder.put(List.class, (Object)"Tree");
        return builder.build();
    }

    @Override
    public String getTypeNamespace() {
        return "g";
    }

    static final class PathGraphSON2Deserializer
    extends AbstractObjectDeserializer<Path> {
        PathGraphSON2Deserializer() {
            super(Path.class);
        }

        @Override
        public Path createObject(Map<String, Object> map) {
            DefaultPath path = new DefaultPath();
            path.labels = new ArrayList<Set<String>>();
            List labels = (List)map.get("labels");
            for (List labelsSet : labels) {
                path.labels.add(new HashSet(labelsSet));
            }
            path.objects = new ArrayList<GraphNode>();
            List objects = (List)map.get("objects");
            for (Object object : objects) {
                path.objects.add(new ObjectGraphNode(object));
            }
            return path;
        }
    }

    static final class EdgeGraphSON2Deserializer
    extends ParentGremlinGraphSON2Deserializer<Edge> {
        EdgeGraphSON2Deserializer() {
            super(Edge.class);
        }

        @Override
        Edge newObject() {
            return new DefaultEdge();
        }

        @Override
        public Edge initializeObject(Map<String, Object> map, Edge element) {
            DefaultEdge edge = (DefaultEdge)element;
            edge.id = new ObjectGraphNode(map.get("id"));
            edge.label = map.get("label").toString();
            if (map.containsKey("properties")) {
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                for (Map.Entry propertyEntry : ((Map)map.get("properties")).entrySet()) {
                    builder.putAll(propertyEntry.getKey(), (Object[])new GraphNode[]{new ObjectGraphNode(propertyEntry.getValue())});
                }
                edge.properties = builder.build();
            }
            edge.inV = new ObjectGraphNode(map.get("inV"));
            if (map.containsKey("inVLabel")) {
                edge.inVLabel = map.get("inVLabel").toString();
            }
            edge.outV = new ObjectGraphNode(map.get("outV"));
            if (map.containsKey("outVLabel")) {
                edge.outVLabel = map.get("outVLabel").toString();
            }
            return edge;
        }
    }

    static final class PropertyGraphSON2Deserializer
    extends ChildGremlinGraphSON2Deserializer<Property> {
        PropertyGraphSON2Deserializer() {
            super(Property.class);
        }

        @Override
        public Property createObject(Map<String, Object> map) {
            DefaultProperty prop = new DefaultProperty();
            prop.name = map.get("key").toString();
            prop.value = new ObjectGraphNode(map.get("value"));
            prop.parent = this.parent;
            return prop;
        }
    }

    static final class VertexPropertyGraphSON2Deserializer
    extends ParentChildGremlinGraphSON2Deserializer<VertexProperty> {
        VertexPropertyGraphSON2Deserializer() {
            super(VertexProperty.class);
        }

        @Override
        VertexProperty newObject() {
            return new DefaultVertexProperty();
        }

        @Override
        public VertexProperty initializeObject(Map<String, Object> map, VertexProperty element) {
            DefaultVertexProperty vp = (DefaultVertexProperty)element;
            vp.id = new ObjectGraphNode(map.get("id"));
            if (map.containsKey("label")) {
                vp.label = map.get("label").toString();
            }
            vp.value = new ObjectGraphNode(map.get("value"));
            if (map.containsKey("properties")) {
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                for (Map.Entry propertyEntry : ((Map)map.get("properties")).entrySet()) {
                    DefaultProperty prop = new DefaultProperty();
                    prop.name = (String)propertyEntry.getKey();
                    prop.value = new ObjectGraphNode(propertyEntry.getValue());
                    prop.parent = vp;
                    builder.putAll(propertyEntry.getKey(), (Object[])new GraphNode[]{new ObjectGraphNode(prop)});
                }
                vp.properties = builder.build();
            }
            vp.parent = (Vertex)this.parent;
            return vp;
        }
    }

    static final class VertexGraphSON2Deserializer
    extends ParentGremlinGraphSON2Deserializer<Vertex> {
        VertexGraphSON2Deserializer() {
            super(Vertex.class);
        }

        @Override
        Vertex newObject() {
            return new DefaultVertex();
        }

        @Override
        public Vertex initializeObject(Map<String, Object> map, Vertex element) {
            DefaultVertex vertex = (DefaultVertex)element;
            vertex.id = new ObjectGraphNode(map.get("id"));
            vertex.label = map.get("label").toString();
            if (map.containsKey("properties")) {
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                for (Map.Entry propertyEntry : ((Map)map.get("properties")).entrySet()) {
                    for (VertexProperty vp : (List)propertyEntry.getValue()) {
                        builder.put(propertyEntry.getKey(), (Object)new ObjectGraphNode(vp));
                    }
                }
                vertex.properties = builder.build();
            }
            return vertex;
        }
    }

    static abstract class ChildGremlinGraphSON2Deserializer<T>
    extends StdDeserializer<T> {
        protected Element parent;

        protected ChildGremlinGraphSON2Deserializer(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            this.parent = ContextualDelegateParser.class.isAssignableFrom(jsonParser.getClass()) ? (Element)((ContextualDelegateParser)jsonParser).getContext().get(0) : null;
            jsonParser.nextToken();
            Map mapData = deserializationContext.readValue(jsonParser, Map.class);
            return this.createObject(mapData);
        }

        abstract T createObject(Map<String, Object> var1);
    }

    static abstract class ParentChildGremlinGraphSON2Deserializer<T extends Element>
    extends ParentGremlinGraphSON2Deserializer<T> {
        Element parent;

        protected ParentChildGremlinGraphSON2Deserializer(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            this.parent = ContextualDelegateParser.class.isAssignableFrom(jsonParser.getClass()) ? (Element)((ContextualDelegateParser)jsonParser).getContext().get(0) : null;
            Object currentParent = this.newObject();
            GremlinContextualJsonParser contextualParser = new GremlinContextualJsonParser(jsonParser, (Element)currentParent);
            ((JsonParser)contextualParser).nextToken();
            Map mapData = deserializationContext.readValue((JsonParser)contextualParser, Map.class);
            return this.initializeObject(mapData, currentParent);
        }
    }

    static abstract class ParentGremlinGraphSON2Deserializer<T extends Element>
    extends StdDeserializer<T> {
        T parent;

        protected ParentGremlinGraphSON2Deserializer(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            this.parent = this.newObject();
            GremlinContextualJsonParser contextualParser = new GremlinContextualJsonParser(jsonParser, (Element)this.parent);
            ((JsonParser)contextualParser).nextToken();
            Map mapData = deserializationContext.readValue((JsonParser)contextualParser, Map.class);
            return this.initializeObject(mapData, this.parent);
        }

        abstract T newObject();

        abstract T initializeObject(Map<String, Object> var1, T var2);
    }

    static final class DoubleGraphSONSerializer
    extends StdScalarSerializer<Double> {
        DoubleGraphSONSerializer() {
            super(Double.class);
        }

        @Override
        public void serialize(Double doubleValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(doubleValue);
        }
    }

    static final class IntegerGraphSONSerializer
    extends StdScalarSerializer<Integer> {
        IntegerGraphSONSerializer() {
            super(Integer.class);
        }

        @Override
        public void serialize(Integer integer, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(integer);
        }
    }
}

