/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.GraphSON2JacksonModule;
import com.datastax.driver.dse.graph.GraphSONSerializerProvider;
import com.datastax.driver.dse.graph.GraphSONTypeIdResolver;
import com.datastax.driver.dse.graph.GraphSONTypeResolverBuilder;
import com.datastax.driver.dse.graph.TypeInfo;
import com.datastax.shaded.jackson.annotation.JsonTypeInfo;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.datastax.shaded.jackson.databind.SerializationFeature;
import com.datastax.shaded.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.datastax.shaded.jackson.databind.module.SimpleModule;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

class GraphSON2Mapper {
    private final List<SimpleModule> customModules;
    private final boolean loadCustomSerializers;
    private final boolean normalize;
    private final TypeInfo typeInfo;

    private GraphSON2Mapper(Builder builder) {
        this.customModules = builder.customModules;
        this.loadCustomSerializers = false;
        this.normalize = false;
        this.typeInfo = builder.typeInfo;
    }

    ObjectMapper createMapper() {
        ObjectMapper om = new ObjectMapper();
        om.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        for (SimpleModule module : this.customModules) {
            om.registerModule(module);
        }
        if (this.loadCustomSerializers) {
            om.findAndRegisterModules();
        }
        GraphSONTypeIdResolver graphSONTypeIdResolver = new GraphSONTypeIdResolver();
        StdTypeResolverBuilder typer = new GraphSONTypeResolverBuilder().typesEmbedding(this.getTypeInfo()).valuePropertyName("@value").init(JsonTypeInfo.Id.CUSTOM, graphSONTypeIdResolver).typeProperty("@type");
        this.registerJavaBaseTypes(graphSONTypeIdResolver, om);
        for (SimpleModule module : this.customModules) {
            GraphSON2JacksonModule mod;
            Map<Class<?>, String> moduleTypeDefinitions;
            if (!(module instanceof GraphSON2JacksonModule) || (moduleTypeDefinitions = (mod = (GraphSON2JacksonModule)module).getTypeDefinitions()) == null) continue;
            if (mod.getTypeNamespace() == null || mod.getTypeNamespace().isEmpty()) {
                throw new IllegalStateException("Cannot specify a module for GraphSON 2.0 with type definitions but without a type Domain. If no specific type domain is required, use Gremlin's default domain, \"g\" but there may be collisions.");
            }
            for (Map.Entry<Class<?>, String> typeDef : moduleTypeDefinitions.entrySet()) {
                graphSONTypeIdResolver.addCustomType(String.format("%s:%s", mod.getTypeNamespace(), typeDef.getValue()), typeDef.getKey(), om);
            }
        }
        om.setDefaultTyping(typer);
        GraphSONSerializerProvider provider = new GraphSONSerializerProvider();
        om.setSerializerProvider(provider);
        if (this.normalize) {
            om.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        }
        om.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        return om;
    }

    static Builder build() {
        return new Builder();
    }

    TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    private void registerJavaBaseTypes(GraphSONTypeIdResolver graphSONTypeIdResolver, ObjectMapper om) {
        graphSONTypeIdResolver.addCustomType(String.format("%s:%s", "g", UUID.class.getSimpleName()), UUID.class, om);
        graphSONTypeIdResolver.addCustomType(String.format("%s:%s", "g", Class.class.getSimpleName()), Class.class, om);
        graphSONTypeIdResolver.addCustomType(String.format("%s:%s", "g", Calendar.class.getSimpleName()), Calendar.class, om);
        graphSONTypeIdResolver.addCustomType(String.format("%s:%s", "g", Date.class.getSimpleName()), Date.class, om);
        graphSONTypeIdResolver.addCustomType(String.format("%s:%s", "g", TimeZone.class.getSimpleName()), TimeZone.class, om);
        graphSONTypeIdResolver.addCustomType(String.format("%s:%s", "g", Timestamp.class.getSimpleName()), Timestamp.class, om);
    }

    static class Builder {
        private final List<SimpleModule> customModules = new ArrayList<SimpleModule>();
        private final boolean loadCustomModules = false;
        private final boolean normalize = false;
        private final TypeInfo typeInfo = TypeInfo.PARTIAL_TYPES;

        private Builder() {
        }

        Builder addCustomModule(SimpleModule custom) {
            this.customModules.add(custom);
            return this;
        }

        GraphSON2Mapper create() {
            return new GraphSON2Mapper(this);
        }
    }
}

