/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphProtocol;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GraphStatement {
    private volatile String graphLanguage;
    private volatile String graphSource;
    private volatile String graphName;
    private volatile boolean systemQuery;
    private volatile ConsistencyLevel graphReadConsistencyLevel;
    private volatile ConsistencyLevel graphWriteConsistencyLevel;
    private volatile Boolean idempotent;
    private volatile Function<Row, GraphNode> transformResultFunction = GraphResultSet.ROW_TO_DEFAULTGRAPHNODE;
    private final Map<String, String> graphInternalOptions = new ConcurrentHashMap<String, String>();

    public String getGraphLanguage() {
        return this.graphLanguage;
    }

    public GraphStatement setGraphLanguage(String graphLanguage) {
        Preconditions.checkNotNull((Object)graphLanguage, (Object)"graphLanguage cannot be null");
        this.graphLanguage = graphLanguage;
        return this;
    }

    public String getGraphSource() {
        return this.graphSource;
    }

    public GraphStatement setGraphSource(String graphSource) {
        Preconditions.checkNotNull((Object)graphSource, (Object)"graphSource cannot be null");
        this.graphSource = graphSource;
        return this;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public GraphStatement setGraphName(String graphName) {
        Preconditions.checkNotNull((Object)graphName, (Object)"graphName cannot be null");
        this.graphName = graphName;
        this.systemQuery = false;
        return this;
    }

    public GraphStatement setSystemQuery() {
        this.systemQuery = true;
        this.graphName = null;
        return this;
    }

    public boolean isSystemQuery() {
        return this.systemQuery;
    }

    public ConsistencyLevel getGraphReadConsistencyLevel() {
        return this.graphReadConsistencyLevel;
    }

    public GraphStatement setGraphReadConsistencyLevel(ConsistencyLevel consistencyLevel) {
        Preconditions.checkNotNull((Object)((Object)consistencyLevel), (Object)"graphReadConsistencyLevel cannot be null");
        this.graphReadConsistencyLevel = consistencyLevel;
        return this;
    }

    public GraphStatement setIdempotent(boolean idempotent) {
        this.idempotent = idempotent;
        return this;
    }

    public Boolean isIdempotent() {
        return this.idempotent;
    }

    public ConsistencyLevel getGraphWriteConsistencyLevel() {
        return this.graphWriteConsistencyLevel;
    }

    public GraphStatement setGraphWriteConsistencyLevel(ConsistencyLevel consistencyLevel) {
        Preconditions.checkNotNull((Object)((Object)consistencyLevel), (Object)"graphWriteConsistencyLevel cannot be null");
        this.graphWriteConsistencyLevel = consistencyLevel;
        return this;
    }

    public GraphStatement setGraphInternalOption(String optionKey, String optionValue) {
        Preconditions.checkNotNull((Object)optionKey, (Object)"option key cannot be null");
        if (optionValue == null) {
            this.getGraphInternalOptions().remove(optionKey);
        } else {
            this.getGraphInternalOptions().put(optionKey, optionValue);
        }
        return this;
    }

    public String getGraphInternalOption(String optionKey) {
        return this.getGraphInternalOptions().get(optionKey);
    }

    Map<String, String> getGraphInternalOptions() {
        return this.graphInternalOptions;
    }

    public abstract GraphStatement setConsistencyLevel(ConsistencyLevel var1);

    public abstract ConsistencyLevel getConsistencyLevel();

    public abstract GraphStatement setDefaultTimestamp(long var1);

    public abstract long getDefaultTimestamp();

    public abstract int getReadTimeoutMillis();

    public abstract GraphStatement setReadTimeoutMillis(int var1);

    public GraphStatement executingAs(String userOrRole) {
        throw new UnsupportedOperationException("This method is concrete only for backward compatibility; it must be implemented in subclasses");
    }

    @Deprecated
    public abstract Statement unwrap();

    public abstract Statement unwrap(GraphProtocol var1);

    public GraphStatement setTransformResultFunction(Function<Row, GraphNode> transformResultFunction) {
        this.transformResultFunction = transformResultFunction;
        return this;
    }

    public Function<Row, GraphNode> getTransformResultFunction() {
        return this.transformResultFunction;
    }
}

