/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.Edge;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.Path;
import com.datastax.driver.dse.graph.Property;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import com.google.common.base.Objects;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectGraphNode
implements GraphNode {
    private final Object delegate;

    public ObjectGraphNode(Object delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isNull() {
        return this.delegate == null;
    }

    @Override
    public boolean isObject() {
        return this.delegate instanceof Map;
    }

    @Override
    public boolean isArray() {
        return this.delegate instanceof List;
    }

    @Override
    public boolean isValue() {
        return !this.isArray() && !this.isObject();
    }

    @Override
    public Iterator<String> fieldNames() {
        return ((Map)this.delegate).keySet().iterator();
    }

    @Override
    public int size() {
        return this.isArray() ? ((List)this.delegate).size() : 0;
    }

    @Override
    public int asInt() {
        return (Integer)this.delegate;
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.delegate;
    }

    @Override
    public long asLong() {
        return (Long)this.delegate;
    }

    @Override
    public double asDouble() {
        return (Double)this.delegate;
    }

    @Override
    public String asString() {
        return (String)this.delegate;
    }

    @Override
    public Map<String, Object> asMap() {
        return (Map)this.delegate;
    }

    @Override
    public <T> T as(Class<T> clazz) {
        return (T)this.delegate;
    }

    @Override
    public <T> T as(TypeToken<T> type) {
        return (T)this.delegate;
    }

    @Override
    public GraphNode get(String fieldName) {
        if (((Map)this.delegate).containsKey(fieldName)) {
            return new ObjectGraphNode(((Map)this.delegate).get(fieldName));
        }
        return null;
    }

    @Override
    public GraphNode get(int index) {
        Object indexValue = ((List)this.delegate).get(index);
        if (indexValue == null) {
            return null;
        }
        return new ObjectGraphNode(indexValue);
    }

    @Override
    public boolean isVertex() {
        return this.delegate instanceof Vertex;
    }

    @Override
    public boolean isEdge() {
        return this.delegate instanceof Edge;
    }

    @Override
    public Vertex asVertex() {
        return (Vertex)this.delegate;
    }

    @Override
    public Edge asEdge() {
        return (Edge)this.delegate;
    }

    @Override
    public Path asPath() {
        return (Path)this.delegate;
    }

    @Override
    public Property asProperty() {
        return (Property)this.delegate;
    }

    @Override
    public VertexProperty asVertexProperty() {
        return (VertexProperty)this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ObjectGraphNode && Objects.equal((Object)this.delegate, (Object)((ObjectGraphNode)other).delegate);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.delegate});
    }
}

