/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryCursor;
import com.datastax.shaded.esri.Operator;
import com.datastax.shaded.esri.OperatorBuffer;
import com.datastax.shaded.esri.OperatorBufferCursor;
import com.datastax.shaded.esri.OperatorFactoryLocal;
import com.datastax.shaded.esri.OperatorUnion;
import com.datastax.shaded.esri.ProgressTracker;
import com.datastax.shaded.esri.SimpleGeometryCursor;
import com.datastax.shaded.esri.SpatialReference;

class OperatorBufferLocal
extends OperatorBuffer {
    OperatorBufferLocal() {
    }

    @Override
    public GeometryCursor execute(GeometryCursor inputGeometries, SpatialReference sr, double[] distances, boolean bUnion, ProgressTracker progressTracker) {
        if (bUnion) {
            OperatorBufferCursor cursor = new OperatorBufferCursor(inputGeometries, sr, distances, false, progressTracker);
            return ((OperatorUnion)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Union)).execute(cursor, sr, progressTracker);
        }
        return new OperatorBufferCursor(inputGeometries, sr, distances, false, progressTracker);
    }

    @Override
    public Geometry execute(Geometry inputGeometry, SpatialReference sr, double distance, ProgressTracker progressTracker) {
        SimpleGeometryCursor inputCursor = new SimpleGeometryCursor(inputGeometry);
        double[] distances = new double[]{distance};
        GeometryCursor outputCursor = this.execute(inputCursor, sr, distances, false, progressTracker);
        return outputCursor.next();
    }
}

