/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.ConstructOffset;
import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryCursor;
import com.datastax.shaded.esri.InternalUtils;
import com.datastax.shaded.esri.OperatorOffset;
import com.datastax.shaded.esri.ProgressTracker;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.SpatialReferenceImpl;

class OperatorOffsetCursor
extends GeometryCursor {
    GeometryCursor m_inputGeoms;
    SpatialReferenceImpl m_spatialReference;
    ProgressTracker m_progressTracker;
    double m_distance;
    double m_miterLimit;
    OperatorOffset.JoinType m_joins;
    double m_flattenError;
    int m_index = -1;

    OperatorOffsetCursor(GeometryCursor inputGeometries, SpatialReference sr, double distance, OperatorOffset.JoinType joins, double bevelRatio, double flattenError, ProgressTracker progressTracker) {
        this.m_inputGeoms = inputGeometries;
        this.m_spatialReference = (SpatialReferenceImpl)sr;
        this.m_distance = distance;
        this.m_joins = joins;
        this.m_miterLimit = bevelRatio;
        this.m_flattenError = flattenError;
        this.m_progressTracker = progressTracker;
    }

    @Override
    public Geometry next() {
        Geometry geom = this.m_inputGeoms.next();
        if (geom != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            return this.Offset(geom);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    Geometry Offset(Geometry geom) {
        double tolerance = this.m_flattenError <= 0.0 ? InternalUtils.calculateToleranceFromGeometry((SpatialReference)this.m_spatialReference, geom, false) : this.m_flattenError;
        return ConstructOffset.execute(geom, this.m_distance, this.m_joins, this.m_miterLimit, tolerance, this.m_progressTracker);
    }
}

