/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri.ogc;

import com.datastax.shaded.codehaus.jackson.JsonFactory;
import com.datastax.shaded.codehaus.jackson.JsonParseException;
import com.datastax.shaded.codehaus.jackson.JsonParser;
import com.datastax.shaded.esri.Envelope;
import com.datastax.shaded.esri.Envelope1D;
import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryCursor;
import com.datastax.shaded.esri.GeometryCursorAppend;
import com.datastax.shaded.esri.GeometryEngine;
import com.datastax.shaded.esri.MapGeometry;
import com.datastax.shaded.esri.MapOGCStructure;
import com.datastax.shaded.esri.MultiPoint;
import com.datastax.shaded.esri.OGCStructure;
import com.datastax.shaded.esri.Operator;
import com.datastax.shaded.esri.OperatorBuffer;
import com.datastax.shaded.esri.OperatorConvexHull;
import com.datastax.shaded.esri.OperatorExportToGeoJson;
import com.datastax.shaded.esri.OperatorExportToWkb;
import com.datastax.shaded.esri.OperatorFactoryLocal;
import com.datastax.shaded.esri.OperatorImportFromESRIShape;
import com.datastax.shaded.esri.OperatorImportFromGeoJson;
import com.datastax.shaded.esri.OperatorImportFromWkb;
import com.datastax.shaded.esri.OperatorImportFromWkt;
import com.datastax.shaded.esri.OperatorIntersection;
import com.datastax.shaded.esri.OperatorSimplify;
import com.datastax.shaded.esri.OperatorSimplifyOGC;
import com.datastax.shaded.esri.OperatorUnion;
import com.datastax.shaded.esri.Point;
import com.datastax.shaded.esri.Polygon;
import com.datastax.shaded.esri.Polyline;
import com.datastax.shaded.esri.SimpleGeometryCursor;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.ogc.OGCConcreteGeometryCollection;
import com.datastax.shaded.esri.ogc.OGCLineString;
import com.datastax.shaded.esri.ogc.OGCMultiLineString;
import com.datastax.shaded.esri.ogc.OGCMultiPoint;
import com.datastax.shaded.esri.ogc.OGCMultiPolygon;
import com.datastax.shaded.esri.ogc.OGCPoint;
import com.datastax.shaded.esri.ogc.OGCPolygon;
import com.datastax.shaded.json.JSONException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class OGCGeometry {
    public SpatialReference esriSR;

    public int dimension() {
        return this.getEsriGeometry().getDimension();
    }

    public int coordinateDimension() {
        int d = 2;
        if (this.getEsriGeometry().getDescription().hasAttribute(2)) {
            ++d;
        }
        if (this.getEsriGeometry().getDescription().hasAttribute(1)) {
            ++d;
        }
        return d;
    }

    public abstract String geometryType();

    public int SRID() {
        if (this.esriSR == null) {
            return 0;
        }
        return this.esriSR.getID();
    }

    public OGCGeometry envelope() {
        Envelope env = new Envelope();
        this.getEsriGeometry().queryEnvelope(env);
        Polygon polygon = new Polygon();
        polygon.addEnvelope(env, false);
        return new OGCPolygon(polygon, this.esriSR);
    }

    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 0);
    }

    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(0, this.getEsriGeometry(), null);
    }

    public String asGeoJson() {
        OperatorExportToGeoJson op = (OperatorExportToGeoJson)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToGeoJson);
        return op.execute(this.getEsriGeometry());
    }

    public String asJson() {
        return GeometryEngine.geometryToJson(this.esriSR, this.getEsriGeometry());
    }

    public boolean isEmpty() {
        return this.getEsriGeometry().isEmpty();
    }

    public double MinZ() {
        Envelope1D e = this.getEsriGeometry().queryInterval(1, 0);
        return e.vmin;
    }

    public double MaxZ() {
        Envelope1D e = this.getEsriGeometry().queryInterval(1, 0);
        return e.vmax;
    }

    public double MinMeasure() {
        Envelope1D e = this.getEsriGeometry().queryInterval(2, 0);
        return e.vmin;
    }

    public double MaxMeasure() {
        Envelope1D e = this.getEsriGeometry().queryInterval(2, 0);
        return e.vmax;
    }

    public boolean isSimple() {
        return OperatorSimplifyOGC.local().isSimpleOGC(this.getEsriGeometry(), this.esriSR, true, null, null);
    }

    public boolean isSimpleRelaxed() {
        OperatorSimplify op = (OperatorSimplify)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Simplify);
        return op.isSimpleAsFeature(this.getEsriGeometry(), this.esriSR, true, null, null);
    }

    @Deprecated
    public OGCGeometry MakeSimpleRelaxed(boolean forceProcessing) {
        return this.makeSimpleRelaxed(forceProcessing);
    }

    public OGCGeometry makeSimpleRelaxed(boolean forceProcessing) {
        OperatorSimplify op = (OperatorSimplify)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Simplify);
        return OGCGeometry.createFromEsriGeometry(op.execute(this.getEsriGeometry(), this.esriSR, forceProcessing, null), this.esriSR);
    }

    public OGCGeometry makeSimple() {
        return this.simplifyBunch_(this.getEsriGeometryCursor());
    }

    public boolean is3D() {
        return this.getEsriGeometry().getDescription().hasAttribute(1);
    }

    public boolean isMeasured() {
        return this.getEsriGeometry().getDescription().hasAttribute(2);
    }

    public abstract OGCGeometry boundary();

    public boolean equals(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.equals(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean disjoint(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.disjoint(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean intersects(OGCGeometry another) {
        return !this.disjoint(another);
    }

    public boolean touches(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.touches(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean crosses(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.crosses(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean within(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.within(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean contains(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.contains(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean overlaps(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.overlaps(geom1, geom2, this.getEsriSpatialReference());
    }

    public boolean relate(OGCGeometry another, String matrix) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.relate(geom1, geom2, this.getEsriSpatialReference(), matrix);
    }

    public abstract OGCGeometry locateAlong(double var1);

    public abstract OGCGeometry locateBetween(double var1, double var3);

    public double distance(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return GeometryEngine.distance(geom1, geom2, this.getEsriSpatialReference());
    }

    private OGCGeometry simplifyBunch_(GeometryCursor gc) {
        Geometry resMP;
        GeometryCursor res;
        Geometry resMP2;
        MultiPoint dstMultiPoint = null;
        ArrayList<Geometry> dstPolylines = new ArrayList<Geometry>();
        ArrayList<Geometry> dstPolygons = new ArrayList<Geometry>();
        Geometry g = gc.next();
        while (g != null) {
            switch (g.getType()) {
                case Point: {
                    if (dstMultiPoint == null) {
                        dstMultiPoint = new MultiPoint();
                    }
                    dstMultiPoint.add((Point)g);
                    break;
                }
                case MultiPoint: {
                    if (dstMultiPoint == null) {
                        dstMultiPoint = new MultiPoint();
                    }
                    dstMultiPoint.add((MultiPoint)g, 0, -1);
                    break;
                }
                case Polyline: {
                    dstPolylines.add((Polyline)g.copy());
                    break;
                }
                case Polygon: {
                    dstPolygons.add((Polygon)g.copy());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            g = gc.next();
        }
        ArrayList<Geometry> result = new ArrayList<Geometry>(3);
        if (dstMultiPoint != null) {
            resMP2 = OperatorSimplifyOGC.local().execute(dstMultiPoint, this.esriSR, true, null);
            result.add(resMP2);
        }
        if (dstPolylines.size() > 0) {
            if (dstPolylines.size() == 1) {
                resMP2 = OperatorSimplifyOGC.local().execute((Geometry)dstPolylines.get(0), this.esriSR, true, null);
                result.add(resMP2);
            } else {
                res = OperatorUnion.local().execute(new SimpleGeometryCursor(dstPolylines), this.esriSR, null);
                Geometry resPolyline = res.next();
                resMP = OperatorSimplifyOGC.local().execute(resPolyline, this.esriSR, true, null);
                result.add(resMP);
            }
        }
        if (dstPolygons.size() > 0) {
            if (dstPolygons.size() == 1) {
                resMP2 = OperatorSimplifyOGC.local().execute((Geometry)dstPolygons.get(0), this.esriSR, true, null);
                result.add(resMP2);
            } else {
                res = OperatorUnion.local().execute(new SimpleGeometryCursor(dstPolygons), this.esriSR, null);
                Geometry resPolygon = res.next();
                resMP = OperatorSimplifyOGC.local().execute(resPolygon, this.esriSR, true, null);
                result.add(resMP);
            }
        }
        return OGCGeometry.createFromEsriCursor(new SimpleGeometryCursor(result), this.esriSR);
    }

    public OGCGeometry buffer(double distance) {
        OperatorBuffer op = (OperatorBuffer)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Buffer);
        if (distance == 0.0) {
            return this;
        }
        double[] d = new double[]{distance};
        GeometryCursor cursor = op.execute(this.getEsriGeometryCursor(), this.getEsriSpatialReference(), d, true, null);
        return OGCGeometry.createFromEsriGeometry(cursor.next(), this.esriSR);
    }

    public OGCGeometry convexHull() {
        OperatorConvexHull op = (OperatorConvexHull)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ConvexHull);
        GeometryCursor cursor = op.execute(this.getEsriGeometryCursor(), true, null);
        return OGCGeometry.createFromEsriCursor(cursor, this.esriSR);
    }

    public OGCGeometry intersection(OGCGeometry another) {
        OperatorIntersection op = (OperatorIntersection)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Intersection);
        GeometryCursor cursor = op.execute(this.getEsriGeometryCursor(), another.getEsriGeometryCursor(), this.getEsriSpatialReference(), null, 7);
        return OGCGeometry.createFromEsriCursor(cursor, this.esriSR, true);
    }

    public OGCGeometry union(OGCGeometry another) {
        OperatorUnion op = (OperatorUnion)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Union);
        GeometryCursorAppend ap = new GeometryCursorAppend(this.getEsriGeometryCursor(), another.getEsriGeometryCursor());
        GeometryCursor cursor = op.execute(ap, this.getEsriSpatialReference(), null);
        return OGCGeometry.createFromEsriCursor(cursor, this.esriSR);
    }

    public OGCGeometry difference(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return OGCGeometry.createFromEsriGeometry(GeometryEngine.difference(geom1, geom2, this.getEsriSpatialReference()), this.esriSR);
    }

    public OGCGeometry symDifference(OGCGeometry another) {
        Geometry geom1 = this.getEsriGeometry();
        Geometry geom2 = another.getEsriGeometry();
        return OGCGeometry.createFromEsriGeometry(GeometryEngine.symmetricDifference(geom1, geom2, this.getEsriSpatialReference()), this.esriSR);
    }

    public abstract Geometry getEsriGeometry();

    public GeometryCursor getEsriGeometryCursor() {
        return new SimpleGeometryCursor(this.getEsriGeometry());
    }

    public SpatialReference getEsriSpatialReference() {
        return this.esriSR;
    }

    public static OGCGeometry createFromEsriCursor(GeometryCursor gc, SpatialReference sr) {
        return OGCGeometry.createFromEsriCursor(gc, sr, false);
    }

    public static OGCGeometry createFromEsriCursor(GeometryCursor gc, SpatialReference sr, boolean skipEmpty) {
        ArrayList<OGCGeometry> geoms = new ArrayList<OGCGeometry>(10);
        Geometry emptyGeom = null;
        Geometry g = gc.next();
        while (g != null) {
            emptyGeom = g;
            if (!skipEmpty || !g.isEmpty()) {
                geoms.add(OGCGeometry.createFromEsriGeometry(g, sr));
            }
            g = gc.next();
        }
        if (geoms.size() == 1) {
            return (OGCGeometry)geoms.get(0);
        }
        if (geoms.size() == 0) {
            return OGCGeometry.createFromEsriGeometry(emptyGeom, sr);
        }
        return new OGCConcreteGeometryCollection(geoms, sr);
    }

    public static OGCGeometry fromText(String text) {
        OperatorImportFromWkt op = (OperatorImportFromWkt)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ImportFromWkt);
        OGCStructure ogcStructure = op.executeOGC(0, text, null);
        return OGCGeometry.createFromOGCStructure(ogcStructure, SpatialReference.create(4326));
    }

    public static OGCGeometry fromBinary(ByteBuffer binary) {
        OperatorImportFromWkb op = (OperatorImportFromWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ImportFromWkb);
        OGCStructure ogcStructure = op.executeOGC(0, binary, null);
        return OGCGeometry.createFromOGCStructure(ogcStructure, SpatialReference.create(4326));
    }

    public static OGCGeometry fromEsriShape(ByteBuffer buffer) {
        OperatorImportFromESRIShape op = (OperatorImportFromESRIShape)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ImportFromESRIShape);
        Geometry g = op.execute(0, Geometry.Type.Unknown, buffer);
        return OGCGeometry.createFromEsriGeometry(g, SpatialReference.create(4326));
    }

    public static OGCGeometry fromJson(String string) throws JsonParseException, IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser jsonParserPt = factory.createJsonParser(string);
        jsonParserPt.nextToken();
        MapGeometry mapGeom = GeometryEngine.jsonToGeometry(jsonParserPt);
        return OGCGeometry.createFromEsriGeometry(mapGeom.getGeometry(), mapGeom.getSpatialReference());
    }

    public static OGCGeometry fromGeoJson(String string) throws JSONException {
        OperatorImportFromGeoJson op = (OperatorImportFromGeoJson)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ImportFromGeoJson);
        MapOGCStructure mapOGCStructure = op.executeOGC(0, string, null);
        return OGCGeometry.createFromOGCStructure(mapOGCStructure.m_ogcStructure, mapOGCStructure.m_spatialReference);
    }

    public static OGCGeometry createFromEsriGeometry(Geometry geom, SpatialReference sr) {
        return OGCGeometry.createFromEsriGeometry(geom, sr, false);
    }

    public static OGCGeometry createFromEsriGeometry(Geometry geom, SpatialReference sr, boolean multiType) {
        if (geom == null) {
            return null;
        }
        Geometry.Type t = geom.getType();
        if (t == Geometry.Type.Polygon) {
            if (!multiType && ((Polygon)geom).getExteriorRingCount() == 1) {
                return new OGCPolygon((Polygon)geom, sr);
            }
            return new OGCMultiPolygon((Polygon)geom, sr);
        }
        if (t == Geometry.Type.Polyline) {
            if (!multiType && ((Polyline)geom).getPathCount() == 1) {
                return new OGCLineString((Polyline)geom, 0, sr);
            }
            return new OGCMultiLineString((Polyline)geom, sr);
        }
        if (t == Geometry.Type.MultiPoint) {
            if (!multiType && ((MultiPoint)geom).getPointCount() <= 1) {
                if (geom.isEmpty()) {
                    return new OGCPoint(new Point(), sr);
                }
                return new OGCPoint(((MultiPoint)geom).getPoint(0), sr);
            }
            return new OGCMultiPoint((MultiPoint)geom, sr);
        }
        if (t == Geometry.Type.Point) {
            if (!multiType) {
                return new OGCPoint((Point)geom, sr);
            }
            return new OGCMultiPoint((Point)geom, sr);
        }
        if (t == Geometry.Type.Envelope) {
            Polygon p = new Polygon();
            p.addEnvelope((Envelope)geom, false);
            return OGCGeometry.createFromEsriGeometry(p, sr, multiType);
        }
        throw new UnsupportedOperationException();
    }

    public static OGCGeometry createFromOGCStructure(OGCStructure ogcStructure, SpatialReference sr) {
        ArrayList<OGCConcreteGeometryCollection> collectionStack = new ArrayList<OGCConcreteGeometryCollection>(0);
        ArrayList<OGCStructure> structureStack = new ArrayList<OGCStructure>(0);
        ArrayList<Integer> indices = new ArrayList<Integer>(0);
        OGCGeometry[] geometries = new OGCGeometry[1];
        OGCConcreteGeometryCollection root = new OGCConcreteGeometryCollection(Arrays.asList(geometries), sr);
        structureStack.add(ogcStructure);
        collectionStack.add(root);
        indices.add(0);
        block9: while (!structureStack.isEmpty()) {
            OGCStructure lastStructure = (OGCStructure)structureStack.get(structureStack.size() - 1);
            if (((Integer)indices.get(indices.size() - 1)).intValue() == lastStructure.m_structures.size()) {
                structureStack.remove(structureStack.size() - 1);
                collectionStack.remove(collectionStack.size() - 1);
                indices.remove(indices.size() - 1);
                continue;
            }
            OGCConcreteGeometryCollection lastCollection = (OGCConcreteGeometryCollection)collectionStack.get(collectionStack.size() - 1);
            int i = (Integer)indices.get(indices.size() - 1);
            int type = lastStructure.m_structures.get((int)i).m_type;
            switch (type) {
                case 1: {
                    OGCGeometry g = new OGCPoint((Point)lastStructure.m_structures.get((int)i).m_geometry, sr);
                    lastCollection.geometries.set(i, g);
                    indices.set(indices.size() - 1, i + 1);
                    continue block9;
                }
                case 2: {
                    OGCGeometry g = new OGCLineString((Polyline)lastStructure.m_structures.get((int)i).m_geometry, 0, sr);
                    lastCollection.geometries.set(i, g);
                    indices.set(indices.size() - 1, i + 1);
                    continue block9;
                }
                case 3: {
                    OGCGeometry g = new OGCPolygon((Polygon)lastStructure.m_structures.get((int)i).m_geometry, 0, sr);
                    lastCollection.geometries.set(i, g);
                    indices.set(indices.size() - 1, i + 1);
                    continue block9;
                }
                case 4: {
                    OGCGeometry g = new OGCMultiPoint((MultiPoint)lastStructure.m_structures.get((int)i).m_geometry, sr);
                    lastCollection.geometries.set(i, g);
                    indices.set(indices.size() - 1, i + 1);
                    continue block9;
                }
                case 5: {
                    OGCGeometry g = new OGCMultiLineString((Polyline)lastStructure.m_structures.get((int)i).m_geometry, sr);
                    lastCollection.geometries.set(i, g);
                    indices.set(indices.size() - 1, i + 1);
                    continue block9;
                }
                case 6: {
                    OGCGeometry g = new OGCMultiPolygon((Polygon)lastStructure.m_structures.get((int)i).m_geometry, sr);
                    lastCollection.geometries.set(i, g);
                    indices.set(indices.size() - 1, i + 1);
                    continue block9;
                }
                case 7: {
                    geometries = new OGCGeometry[lastStructure.m_structures.get((int)i).m_structures.size()];
                    OGCGeometry g = new OGCConcreteGeometryCollection(Arrays.asList(geometries), sr);
                    lastCollection.geometries.set(i, g);
                    indices.set(indices.size() - 1, i + 1);
                    structureStack.add(lastStructure.m_structures.get(i));
                    collectionStack.add((OGCConcreteGeometryCollection)g);
                    indices.add(0);
                    continue block9;
                }
            }
            throw new UnsupportedOperationException();
        }
        return root.geometries.get(0);
    }

    protected boolean isConcreteGeometryCollection() {
        return false;
    }

    public void setSpatialReference(SpatialReference esriSR_) {
        this.esriSR = esriSR_;
    }

    public abstract OGCGeometry convertToMulti();

    public String toString() {
        String snippet = this.asText();
        if (snippet.length() > 200) {
            snippet = snippet.substring(0, 197) + "...";
        }
        return String.format("%s: %s", this.getClass().getSimpleName(), snippet);
    }
}

