/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.spark.connector.cql.ClusteringColumn;
import com.datastax.spark.connector.cql.ClusteringColumn$;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.ColumnDef$;
import com.datastax.spark.connector.cql.IndexDef;
import com.datastax.spark.connector.cql.KeyspaceDef;
import com.datastax.spark.connector.cql.PartitionKeyColumn$;
import com.datastax.spark.connector.cql.RegularColumn$;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.StaticColumn$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.cql.TableDef$;
import com.datastax.spark.connector.types.UserDefinedType;
import com.datastax.spark.connector.types.UserDefinedType$;
import com.datastax.spark.connector.util.DriverUtil$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import com.datastax.spark.connector.util.NameTools;
import com.datastax.spark.connector.util.NameTools$;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Schema$
implements Logging,
Serializable {
    public static final Schema$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new Schema$();
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private Seq<ColumnDef> fetchPartitionKey(RelationMetadata table) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(table.getPartitionKey()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(ColumnMetadata column) {
                return ColumnDef$.MODULE$.apply(column, PartitionKeyColumn$.MODULE$);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private Seq<ColumnDef> fetchClusteringColumns(RelationMetadata table) {
        return (Seq)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.getClusteringColumns()).asScala()).toSeq().zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<ColumnMetadata, ClusteringOrder>, Object> check$ifrefutable$1) {
                Tuple2<Tuple2<ColumnMetadata, ClusteringOrder>, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(Tuple2<Tuple2<ColumnMetadata, ClusteringOrder>, Object> x$12) {
                Tuple2<Tuple2<ColumnMetadata, ClusteringOrder>, Object> tuple2 = x$12;
                if (tuple2 != null) {
                    Tuple2 column = (Tuple2)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    ColumnDef columnDef = ColumnDef$.MODULE$.apply((ColumnMetadata)column._1(), new ClusteringColumn(index, ClusteringColumn$.MODULE$.apply$default$2()));
                    return columnDef;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<ColumnDef> fetchRegularColumns(RelationMetadata table) {
        Set primaryKey = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(table.getPrimaryKey()).asScala()).toSet();
        Seq regularColumns = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(table.getColumns()).asScala()).values().toSeq().filterNot((Function1)new Serializable(primaryKey){
            public static final long serialVersionUID = 0L;
            private final Set primaryKey$1;

            public final boolean apply(ColumnMetadata elem) {
                return this.primaryKey$1.contains((Object)elem);
            }
            {
                this.primaryKey$1 = primaryKey$1;
            }
        });
        return (Seq)regularColumns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(ColumnMetadata column) {
                return column.isStatic() ? ColumnDef$.MODULE$.apply(column, StaticColumn$.MODULE$) : ColumnDef$.MODULE$.apply(column, RegularColumn$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String com$datastax$spark$connector$cql$Schema$$handleId(TableMetadata table, String columnName) {
        return (String)Option$.MODULE$.apply((Object)table.getColumn(CqlIdentifier.fromInternal((String)columnName))).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<ColumnMetadata> apply(Optional<ColumnMetadata> optional) {
                return DriverUtil$.MODULE$.toOption(optional);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnMetadata c) {
                return DriverUtil$.MODULE$.toName(c.getName());
            }
        }).getOrElse((Function0)new Serializable(columnName){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;

            public final String apply() {
                return this.columnName$1;
            }
            {
                this.columnName$1 = columnName$1;
            }
        });
    }

    private Seq<IndexDef> getIndexDefs(RelationMetadata tableOrView) {
        RelationMetadata relationMetadata;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    relationMetadata = tableOrView;
                    if (!(relationMetadata instanceof TableMetadata)) break block2;
                    TableMetadata tableMetadata = (TableMetadata)relationMetadata;
                    seq = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(tableMetadata.getIndexes()).asScala()).values().toSeq().map((Function1)new Serializable(tableMetadata){
                        public static final long serialVersionUID = 0L;
                        private final TableMetadata x2$1;

                        public final IndexDef apply(IndexMetadata index) {
                            Option<T> className = DriverUtil$.MODULE$.toOption(index.getClassName());
                            String target = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$handleId(this.x2$1, index.getTarget());
                            return new IndexDef(className, target, DriverUtil$.MODULE$.toName(index.getName()), (Map<String, String>)Predef$.MODULE$.Map().empty());
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!(relationMetadata instanceof ViewMetadata)) break block4;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)relationMetadata);
    }

    public TableDef fetchTable(CqlIdentifier keyspace, RelationMetadata table) {
        Seq<ColumnDef> partitionKey = this.fetchPartitionKey(table);
        Seq<ColumnDef> clusteringColumns = this.fetchClusteringColumns(table);
        Seq<ColumnDef> regularColumns = this.fetchRegularColumns(table);
        Seq<IndexDef> indexDefs = this.getIndexDefs(table);
        RelationMetadata relationMetadata = table;
        boolean bl = relationMetadata instanceof ViewMetadata;
        boolean isView = bl;
        return new TableDef(DriverUtil$.MODULE$.toName(keyspace), DriverUtil$.MODULE$.toName(table.getName()), partitionKey, clusteringColumns, regularColumns, indexDefs, isView, TableDef$.MODULE$.apply$default$8(), TableDef$.MODULE$.apply$default$9());
    }

    public boolean com$datastax$spark$connector$cql$Schema$$isTableSelected(RelationMetadata table, Option<String> selected) {
        Option<String> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = selected;
                    if (!None$.MODULE$.equals(option)) break block2;
                    bl = true;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                String name = (String)some.x();
                String string = DriverUtil$.MODULE$.toName(table.getName());
                String string2 = name;
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
            return bl;
        }
        throw new MatchError(option);
    }

    private Set<TableDef> fetchTables(KeyspaceMetadata keyspace, Option<String> selected) {
        return (Set)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(keyspace.getTables()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(keyspace.getViews()).asScala()).toSet()).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<CqlIdentifier, RelationMetadata> check$ifrefutable$2) {
                Tuple2<CqlIdentifier, RelationMetadata> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(selected){
            public static final long serialVersionUID = 0L;
            private final Option selected$1;

            public final boolean apply(Tuple2<CqlIdentifier, RelationMetadata> x$13) {
                Tuple2<CqlIdentifier, RelationMetadata> tuple2 = x$13;
                if (tuple2 != null) {
                    RelationMetadata table = (RelationMetadata)tuple2._2();
                    boolean bl = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$isTableSelected(table, (Option<String>)this.selected$1);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.selected$1 = selected$1;
            }
        }).map((Function1)new Serializable(keyspace){
            public static final long serialVersionUID = 0L;
            private final KeyspaceMetadata keyspace$1;

            public final TableDef apply(Tuple2<CqlIdentifier, RelationMetadata> x$14) {
                Tuple2<CqlIdentifier, RelationMetadata> tuple2 = x$14;
                if (tuple2 != null) {
                    RelationMetadata table = (RelationMetadata)tuple2._2();
                    TableDef tableDef = Schema$.MODULE$.fetchTable(this.keyspace$1.getName(), table);
                    return tableDef;
                }
                throw new MatchError(tuple2);
            }
            {
                this.keyspace$1 = keyspace$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private Option<String> fetchTables$default$2() {
        return None$.MODULE$;
    }

    public UserDefinedType fetchUserType(com.datastax.oss.driver.api.core.type.UserDefinedType driverUserType) {
        return UserDefinedType$.MODULE$.apply(driverUserType);
    }

    private Set<UserDefinedType> fetchUserTypes(KeyspaceMetadata metadata) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getUserDefinedTypes()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UserDefinedType apply(Tuple2<CqlIdentifier, com.datastax.oss.driver.api.core.type.UserDefinedType> x0$2) {
                Tuple2<CqlIdentifier, com.datastax.oss.driver.api.core.type.UserDefinedType> tuple2 = x0$2;
                if (tuple2 != null) {
                    com.datastax.oss.driver.api.core.type.UserDefinedType driverUserType = (com.datastax.oss.driver.api.core.type.UserDefinedType)tuple2._2();
                    UserDefinedType userDefinedType = Schema$.MODULE$.fetchUserType(driverUserType);
                    return userDefinedType;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> systemKeyspaces() {
        return Predef$.MODULE$.Set().empty();
    }

    public KeyspaceDef fetchKeyspace(KeyspaceMetadata keyspace, Option<String> selectedTable) {
        return new KeyspaceDef(DriverUtil$.MODULE$.toName(keyspace.getName()), this.fetchTables(keyspace, selectedTable), this.fetchUserTypes(keyspace), this.systemKeyspaces().contains((Object)DriverUtil$.MODULE$.toName(keyspace.getName())));
    }

    public Option<String> fetchKeyspace$default$2() {
        return None$.MODULE$;
    }

    public Schema fromCassandra(CqlSession session, Option<String> keyspaceName, Option<String> tableName) {
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieving database schema"})).s((Seq)Nil$.MODULE$);
            }
        });
        Schema scheme = this.fetchSchema$1((Function0)new Serializable(session){
            public static final long serialVersionUID = 0L;
            private final CqlSession session$1;

            public final Metadata apply() {
                return this.session$1.refreshSchema();
            }
            {
                this.session$1 = session$1;
            }
        }, keyspaceName, tableName);
        this.logDebug((Function0<String>)new Serializable(scheme){
            public static final long serialVersionUID = 0L;
            private final Schema scheme$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " keyspaces fetched: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.scheme$1.keyspaces().size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.scheme$1.keyspaces().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(KeyspaceDef x$17) {
                        return x$17.keyspaceName();
                    }
                }, Set$.MODULE$.canBuildFrom())).mkString("{", ",", "}")}))).toString();
            }
            {
                this.scheme$1 = scheme$1;
            }
        });
        return scheme;
    }

    public Option<String> fromCassandra$default$2() {
        return None$.MODULE$;
    }

    public Option<String> fromCassandra$default$3() {
        return None$.MODULE$;
    }

    public TableDef tableFromCassandra(CqlSession session, String keyspaceName, String tableName) {
        Option option = this.fromCassandra(session, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName)).tables().headOption();
        if (option instanceof Some) {
            TableDef t;
            Some some = (Some)option;
            TableDef tableDef = t = (TableDef)some.x();
            return tableDef;
        }
        if (None$.MODULE$.equals(option)) {
            Metadata metadata = session.getMetadata();
            Option<NameTools.Suggestions> suggestions = NameTools$.MODULE$.getSuggestions(metadata, keyspaceName, tableName);
            String errorMessage = NameTools$.MODULE$.getErrorString(keyspaceName, tableName, suggestions);
            throw new IOException(errorMessage);
        }
        throw new MatchError((Object)option);
    }

    public Schema apply(Set<KeyspaceDef> keyspaces) {
        return new Schema(keyspaces);
    }

    public Option<Set<KeyspaceDef>> unapply(Schema x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.keyspaces());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final boolean com$datastax$spark$connector$cql$Schema$$isKeyspaceSelected$1(KeyspaceMetadata keyspace, Option keyspaceName$1) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = keyspaceName$1;
                    if (!None$.MODULE$.equals(option)) break block2;
                    bl = true;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                String name = (String)some.x();
                String string = DriverUtil$.MODULE$.toName(keyspace.getName());
                String string2 = name;
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    private final Set fetchKeyspaces$1(Metadata metadata, Option keyspaceName$1, Option tableName$1) {
        return (Set)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getKeyspaces()).asScala()).toSet().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<CqlIdentifier, KeyspaceMetadata> check$ifrefutable$3) {
                Tuple2<CqlIdentifier, KeyspaceMetadata> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(keyspaceName$1){
            public static final long serialVersionUID = 0L;
            private final Option keyspaceName$1;

            public final boolean apply(Tuple2<CqlIdentifier, KeyspaceMetadata> x$15) {
                Tuple2<CqlIdentifier, KeyspaceMetadata> tuple2 = x$15;
                if (tuple2 != null) {
                    KeyspaceMetadata keyspace = (KeyspaceMetadata)tuple2._2();
                    boolean bl = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$isKeyspaceSelected$1(keyspace, this.keyspaceName$1);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.keyspaceName$1 = keyspaceName$1;
            }
        }).map((Function1)new Serializable(tableName$1){
            public static final long serialVersionUID = 0L;
            private final Option tableName$1;

            public final KeyspaceDef apply(Tuple2<CqlIdentifier, KeyspaceMetadata> x$16) {
                Tuple2<CqlIdentifier, KeyspaceMetadata> tuple2 = x$16;
                if (tuple2 != null) {
                    KeyspaceMetadata keyspace = (KeyspaceMetadata)tuple2._2();
                    KeyspaceDef keyspaceDef = Schema$.MODULE$.fetchKeyspace(keyspace, (Option<String>)this.tableName$1);
                    return keyspaceDef;
                }
                throw new MatchError(tuple2);
            }
            {
                this.tableName$1 = tableName$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private final Schema fetchSchema$1(Function0 metadata, Option keyspaceName$1, Option tableName$1) {
        return new Schema((Set<KeyspaceDef>)this.fetchKeyspaces$1((Metadata)metadata.apply(), keyspaceName$1, tableName$1));
    }

    private Schema$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

