/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector;

import com.datastax.spark.connector.CassandraRow;
import com.datastax.spark.connector.RDDFunctions;
import com.datastax.spark.connector.SparkContextFunctions;
import com.datastax.spark.connector.mapper.ColumnMapper;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.reader.ClassBasedRowReaderFactory;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import com.datastax.spark.connector.util.JavaApiHelper;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import scala.reflect.ClassTag;
import scala.reflect.api.TypeTags;

public class CassandraJavaUtil {
    public static final Map<String, String> NO_OVERRIDE = new HashMap<String, String>();

    private CassandraJavaUtil() {
        assert (false);
    }

    public static SparkContextJavaFunctions javaFunctions(SparkContext sparkContext) {
        return new SparkContextJavaFunctions(sparkContext);
    }

    public static SparkContextJavaFunctions javaFunctions(JavaSparkContext javaSparkContext) {
        return new SparkContextJavaFunctions(JavaSparkContext.toSparkContext((JavaSparkContext)javaSparkContext));
    }

    public static <T> RDDJavaFunctions javaFunctions(RDD<T> rDD, Class<T> clazz) {
        return new RDDJavaFunctions(rDD, clazz);
    }

    public static <T> RDDJavaFunctions javaFunctions(JavaRDD<T> javaRDD, Class<T> clazz) {
        return new RDDJavaFunctions(JavaRDD.toRDD(javaRDD), clazz);
    }

    public static class SparkContextJavaFunctions {
        public final SparkContext sparkContext;
        private final SparkContextFunctions scf;

        private SparkContextJavaFunctions(SparkContext sparkContext) {
            this.sparkContext = sparkContext;
            this.scf = new SparkContextFunctions(sparkContext);
        }

        public <T extends Serializable> CassandraRDD<T> cassandraTable(String string, String string2, RowReaderFactory<T> rowReaderFactory, Class<T> clazz) {
            ClassTag<T> classTag = JavaApiHelper.getClassTag(clazz);
            return this.scf.cassandraTable(string, string2, classTag, rowReaderFactory);
        }

        public CassandraRDD<CassandraRow> cassandraTable(String string, String string2) {
            RowReaderFactory<CassandraRow> rowReaderFactory = JavaApiHelper.genericRowReaderFactory();
            return this.cassandraTable(string, string2, rowReaderFactory, CassandraRow.class);
        }

        public <T extends Serializable> CassandraRDD<T> cassandraTable(String string, String string2, ColumnMapper<T> columnMapper, Class<T> clazz) {
            TypeTags.TypeTag<T> typeTag = JavaApiHelper.getTypeTag(clazz);
            ClassBasedRowReaderFactory<T> classBasedRowReaderFactory = new ClassBasedRowReaderFactory<T>(typeTag, columnMapper);
            return this.cassandraTable(string, string2, classBasedRowReaderFactory, clazz);
        }

        public <T extends Serializable> CassandraRDD<T> cassandraTable(String string, String string2, Class<T> clazz) {
            ClassTag<T> classTag = JavaApiHelper.getClassTag(clazz);
            ColumnMapper<T> columnMapper = JavaApiHelper.javaBeanColumnMapper(clazz, new HashMap<String, String>());
            return this.cassandraTable(string, string2, columnMapper, clazz);
        }

        public <T extends Serializable> CassandraRDD<T> cassandraTable(String string, String string2, Class<T> clazz, Map<String, String> map) {
            ClassTag<T> classTag = JavaApiHelper.getClassTag(clazz);
            ColumnMapper<T> columnMapper = JavaApiHelper.javaBeanColumnMapper(clazz, map);
            return this.cassandraTable(string, string2, columnMapper, clazz);
        }
    }

    public static class RDDJavaFunctions<T> {
        public final RDD<T> rdd;
        private final RDDFunctions<T> rddf;
        private final Class<T> targetClass;

        private RDDJavaFunctions(RDD<T> rDD, Class<T> clazz) {
            this.rdd = rDD;
            this.targetClass = clazz;
            this.rddf = new RDDFunctions<T>(rDD, JavaApiHelper.getClassTag(clazz));
        }

        public void saveToCassandra(String string, String string2, RowWriterFactory<T> rowWriterFactory) {
            this.rddf.saveToCassandra(string, string2, rowWriterFactory);
        }

        public void saveToCassandra(String string, String string2, String[] stringArray, RowWriterFactory<T> rowWriterFactory) {
            this.rddf.saveToCassandra(string, string2, JavaApiHelper.toScalaSeq(stringArray), rowWriterFactory);
        }

        public void saveToCassandra(String string, String string2, String[] stringArray, int n, RowWriterFactory<T> rowWriterFactory) {
            this.rddf.saveToCassandra(string, string2, JavaApiHelper.toScalaSeq(stringArray), n, rowWriterFactory);
        }

        public void saveToCassandra(String string, String string2, ColumnMapper<T> columnMapper) {
            RowWriterFactory<T> rowWriterFactory = JavaApiHelper.defaultRowWriterFactory(this.targetClass, columnMapper);
            this.saveToCassandra(string, string2, rowWriterFactory);
        }

        public void saveToCassandra(String string, String string2, String[] stringArray, ColumnMapper<T> columnMapper) {
            RowWriterFactory<T> rowWriterFactory = JavaApiHelper.defaultRowWriterFactory(this.targetClass, columnMapper);
            this.saveToCassandra(string, string2, stringArray, rowWriterFactory);
        }

        public void saveToCassandra(String string, String string2, String[] stringArray, int n, ColumnMapper<T> columnMapper) {
            RowWriterFactory<T> rowWriterFactory = JavaApiHelper.defaultRowWriterFactory(this.targetClass, columnMapper);
            this.saveToCassandra(string, string2, stringArray, n, rowWriterFactory);
        }

        public void saveToCassandra(String string, String string2, Map<String, String> map) {
            this.saveToCassandra(string, string2, JavaApiHelper.javaBeanColumnMapper(this.targetClass, map));
        }

        public void saveToCassandra(String string, String string2, String[] stringArray, Map<String, String> map) {
            this.saveToCassandra(string, string2, stringArray, JavaApiHelper.javaBeanColumnMapper(this.targetClass, map));
        }

        public void saveToCassandra(String string, String string2, String[] stringArray, int n, Map<String, String> map) {
            this.saveToCassandra(string, string2, stringArray, n, JavaApiHelper.javaBeanColumnMapper(this.targetClass, map));
        }

        public void saveToCassandra(String string, String string2) {
            this.saveToCassandra(string, string2, NO_OVERRIDE);
        }

        public void saveToCassandra(String string, String string2, String[] stringArray) {
            this.saveToCassandra(string, string2, stringArray, NO_OVERRIDE);
        }

        public void saveToCassandra(String string, String string2, String[] stringArray, int n) {
            this.saveToCassandra(string, string2, stringArray, n, NO_OVERRIDE);
        }
    }
}

