/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.concurrent.TrieMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001b\ti\u0011i]=oG\u0016CXmY;u_JT!a\u0001\u0003\u0002\r]\u0014\u0018\u000e^3s\u0015\t)a!A\u0005d_:tWm\u0019;pe*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\t\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001U\u0019a\u0002\b\u001a\u0014\u0005\u0001y\u0001C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0018\u0003-\t7/\u001f8d\u0003\u000e$\u0018n\u001c8\u0011\tAA\"$J\u0005\u00033E\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005maB\u0002\u0001\u0003\u0006;\u0001\u0011\rA\b\u0002\u0002)F\u0011qD\t\t\u0003!\u0001J!!I\t\u0003\u000f9{G\u000f[5oOB\u0011\u0001cI\u0005\u0003IE\u00111!\u00118z!\r1s&M\u0007\u0002O)\u0011\u0001&K\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u0016,\u0003\u0011)H/\u001b7\u000b\u00051j\u0013AB2p[6|gN\u0003\u0002/\u0015\u00051qm\\8hY\u0016L!\u0001M\u0014\u0003!1K7\u000f^3oC\ndWMR;ukJ,\u0007CA\u000e3\t\u0015\u0019\u0004A1\u0001\u001f\u0005\u0005\u0011\u0006\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002%5\f\u0007pQ8oGV\u0014(/\u001a8u)\u0006\u001c8n\u001d\t\u0003!]J!\u0001O\t\u0003\u0007%sG\u000fC\u0003;\u0001\u0011\u00051(\u0001\u0004=S:LGO\u0010\u000b\u0004yyz\u0004\u0003B\u001f\u00015Ej\u0011A\u0001\u0005\u0006-e\u0002\ra\u0006\u0005\u0006ke\u0002\rA\u000e\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u00035y6/^2dKN\u001c8i\\;oiV\t1\t\u0005\u0002E\u00176\tQI\u0003\u0002G\u000f\u00061\u0011\r^8nS\u000eT!\u0001\u000b%\u000b\u0005)J%\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u0016\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bB\u0002(\u0001A\u0003%1)\u0001\b`gV\u001c7-Z:t\u0007>,h\u000e\u001e\u0011\t\u000fA\u0003!\u0019!C\u0005\u0005\u0006iqLZ1jYV\u0014XmQ8v]RDaA\u0015\u0001!\u0002\u0013\u0019\u0015AD0gC&dWO]3D_VtG\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003%\u0019X-\\1qQ>\u0014X-F\u0001W!\t9\u0006,D\u0001H\u0013\tIvIA\u0005TK6\f\u0007\u000f[8sK\"11\f\u0001Q\u0001\nY\u000b!b]3nCBDwN]3!\u0011\u001di\u0006A1A\u0005\ny\u000ba\u0002]3oI&twMR;ukJ,7/F\u0001`!\u0011\u0001G-\n4\u000e\u0003\u0005T!\u0001\u000b2\u000b\u0005\r\f\u0012AC2pY2,7\r^5p]&\u0011Q-\u0019\u0002\b)JLW-T1q!\t\u0001r-\u0003\u0002i#\t9!i\\8mK\u0006t\u0007B\u00026\u0001A\u0003%q,A\bqK:$\u0017N\\4GkR,(/Z:!\u0011\u0015a\u0007\u0001\"\u0001n\u00031)\u00070Z2vi\u0016\f5/\u001f8d)\t)c\u000eC\u0003pW\u0002\u0007!$\u0001\u0003uCN\\\u0007\"B9\u0001\t\u0003\u0011\u0018AH<bSR4uN]\"veJ,g\u000e\u001e7z\u000bb,7-\u001e;j]\u001e$\u0016m]6t)\u0005\u0019\bC\u0001\tu\u0013\t)\u0018C\u0001\u0003V]&$\b\"B<\u0001\t\u0003A\u0018\u0001D:vG\u000e,7o]\"pk:$X#\u0001\u001c\t\u000bi\u0004A\u0011\u0001=\u0002\u0019\u0019\f\u0017\u000e\\;sK\u000e{WO\u001c;")
public class AsyncExecutor<T, R> {
    private final Function1<T, ListenableFuture<R>> asyncAction;
    private final AtomicInteger com$datastax$spark$connector$writer$AsyncExecutor$$_successCount;
    private final AtomicInteger com$datastax$spark$connector$writer$AsyncExecutor$$_failureCount;
    private final Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    private final TrieMap<ListenableFuture<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;

    public AtomicInteger com$datastax$spark$connector$writer$AsyncExecutor$$_successCount() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$_successCount;
    }

    public AtomicInteger com$datastax$spark$connector$writer$AsyncExecutor$$_failureCount() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$_failureCount;
    }

    public Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    }

    public TrieMap<ListenableFuture<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;
    }

    /*
     * WARNING - void declaration
     */
    public ListenableFuture<R> executeAsync(T task) {
        void var2_2;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().acquire();
        SettableFuture settable = SettableFuture.create();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().put((Object)settable, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        ListenableFuture future = (ListenableFuture)this.asyncAction.apply(task);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<R>(this, settable){
            private final /* synthetic */ AsyncExecutor $outer;
            private final SettableFuture settable$1;

            private void release() {
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().release();
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().remove((Object)this.settable$1);
            }

            public void onSuccess(R result) {
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$_successCount().incrementAndGet();
                this.release();
                this.settable$1.set(result);
            }

            public void onFailure(Throwable throwable) {
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$_failureCount().incrementAndGet();
                this.release();
                this.settable$1.setException(throwable);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.settable$1 = settable$1;
            }
        });
        return var2_2;
    }

    public void waitForCurrentlyExecutingTasks() {
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().snapshot().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<ListenableFuture<R>, Object> check$ifrefutable$1) {
                Tuple2<ListenableFuture<R>, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Try<R> apply(Tuple2<ListenableFuture<R>, Object> x$1) {
                Tuple2<ListenableFuture<R>, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    ListenableFuture future = (ListenableFuture)tuple2._1();
                    Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, future){
                        public static final long serialVersionUID = 0L;
                        private final ListenableFuture future$1;

                        public final R apply() {
                            return (R)this.future$1.get();
                        }
                        {
                            this.future$1 = future$1;
                        }
                    });
                    return try_;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public int successCount() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$_successCount().get();
    }

    public int failureCount() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$_failureCount().get();
    }

    public AsyncExecutor(Function1<T, ListenableFuture<R>> asyncAction, int maxConcurrentTasks) {
        this.asyncAction = asyncAction;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$_successCount = new AtomicInteger(0);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$_failureCount = new AtomicInteger(0);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore = new Semaphore(maxConcurrentTasks);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures = new TrieMap();
    }
}

