/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.AuthConf$;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.NoAuthConf$;
import java.net.InetAddress;
import org.apache.spark.SparkConf;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class CassandraConnectorConf$
implements Serializable {
    public static final CassandraConnectorConf$ MODULE$;
    private final int DefaultRpcPort;
    private final int DefaultNativePort;
    private final String CassandraConnectionHostProperty;
    private final String CassandraConnectionRpcPortProperty;
    private final String CassandraConnectionNativePortProperty;

    static {
        new CassandraConnectorConf$();
    }

    public int DefaultRpcPort() {
        return this.DefaultRpcPort;
    }

    public int DefaultNativePort() {
        return this.DefaultNativePort;
    }

    public String CassandraConnectionHostProperty() {
        return this.CassandraConnectionHostProperty;
    }

    public String CassandraConnectionRpcPortProperty() {
        return this.CassandraConnectionRpcPortProperty;
    }

    public String CassandraConnectionNativePortProperty() {
        return this.CassandraConnectionNativePortProperty;
    }

    public CassandraConnectorConf apply(InetAddress host, int nativePort, int rpcPort, AuthConf authConf) {
        return new CassandraConnectorConf((Set<InetAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{host}))), nativePort, rpcPort, authConf);
    }

    public CassandraConnectorConf apply(SparkConf conf) {
        InetAddress host = InetAddress.getByName(conf.get(this.CassandraConnectionHostProperty(), InetAddress.getLocalHost().getHostAddress()));
        int rpcPort = conf.getInt(this.CassandraConnectionRpcPortProperty(), this.DefaultRpcPort());
        int nativePort = conf.getInt(this.CassandraConnectionNativePortProperty(), this.DefaultNativePort());
        AuthConf authConf = AuthConf$.MODULE$.fromSparkConf(conf);
        return new CassandraConnectorConf((Set<InetAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{host}))), nativePort, rpcPort, authConf);
    }

    public int apply$default$2() {
        return this.DefaultNativePort();
    }

    public int apply$default$3() {
        return this.DefaultRpcPort();
    }

    public AuthConf apply$default$4() {
        return NoAuthConf$.MODULE$;
    }

    public CassandraConnectorConf apply(Set<InetAddress> hosts, int nativePort, int rpcPort, AuthConf authConf) {
        return new CassandraConnectorConf(hosts, nativePort, rpcPort, authConf);
    }

    public Option<Tuple4<Set<InetAddress>, Object, Object, AuthConf>> unapply(CassandraConnectorConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4(x$0.hosts(), (Object)BoxesRunTime.boxToInteger((int)x$0.nativePort()), (Object)BoxesRunTime.boxToInteger((int)x$0.rpcPort()), (Object)x$0.authConf()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraConnectorConf$() {
        MODULE$ = this;
        this.DefaultRpcPort = 9160;
        this.DefaultNativePort = 9042;
        this.CassandraConnectionHostProperty = "spark.cassandra.connection.host";
        this.CassandraConnectionRpcPortProperty = "spark.cassandra.connection.rpc.port";
        this.CassandraConnectionNativePortProperty = "spark.cassandra.connection.native.port";
    }
}

