/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import org.apache.spark.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;

public final class PreparedStatementCache$
implements Logging {
    public static final PreparedStatementCache$ MODULE$;
    private final TrieMap<Cluster, TrieMap<String, PreparedStatement>> clusterCache;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new PreparedStatementCache$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private TrieMap<Cluster, TrieMap<String, PreparedStatement>> clusterCache() {
        return this.clusterCache;
    }

    private Option<PreparedStatement> get(Cluster cluster, String query) {
        return this.clusterCache().get((Object)cluster).flatMap((Function1)new Serializable(query){
            public static final long serialVersionUID = 0L;
            private final String query$1;

            public final Option<PreparedStatement> apply(TrieMap<String, PreparedStatement> statementCache) {
                return statementCache.get((Object)this.query$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PreparedStatement apply(PreparedStatement statement) {
                        return statement;
                    }
                });
            }
            {
                this.query$1 = query$1;
            }
        });
    }

    private PreparedStatement put(Cluster cluster, String query, PreparedStatement statement) {
        Option option;
        block4: {
            block3: {
                Option option2;
                block2: {
                    option = this.clusterCache().get((Object)cluster);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    TrieMap statementCache = (TrieMap)some.x();
                    option2 = statementCache.put((Object)query, (Object)statement);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                option2 = this.clusterCache().put((Object)cluster, (Object)TrieMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)query), (Object)statement)})));
            }
            return statement;
        }
        throw new MatchError((Object)option);
    }

    public void remove(Cluster cluster) {
        PreparedStatementCache$ preparedStatementCache$ = this;
        synchronized (preparedStatementCache$) {
            this.clusterCache().remove((Object)cluster);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareStatement(Session session, RegularStatement query) {
        Cluster cluster = session.getCluster();
        Option<PreparedStatement> option = this.get(cluster, query.toString());
        if (option instanceof Some) {
            Some some = (Some)option;
            PreparedStatement stmt = (PreparedStatement)some.x();
            return stmt;
        }
        None$ none$ = None$.MODULE$;
        Option<PreparedStatement> option2 = option;
        if (none$ == null) {
            if (option2 != null) {
                throw new MatchError(option);
            }
        } else if (!none$.equals(option2)) throw new MatchError(option);
        PreparedStatementCache$ preparedStatementCache$ = this;
        synchronized (preparedStatementCache$) {
            Option<PreparedStatement> option3;
            block10: {
                PreparedStatement preparedStatement;
                option3 = this.get(cluster, query.toString());
                if (option3 instanceof Some) {
                    PreparedStatement stmt;
                    Some some = (Some)option3;
                    preparedStatement = stmt = (PreparedStatement)some.x();
                } else {
                    None$ none$2 = None$.MODULE$;
                    Option<PreparedStatement> option4 = option3;
                    if (none$2 != null ? !none$2.equals(option4) : option4 != null) break block10;
                    PreparedStatement stmt = session.prepare(query);
                    preparedStatement = this.put(cluster, query.toString(), stmt);
                }
                PreparedStatement preparedStatement2 = preparedStatement;
                return preparedStatement2;
            }
            throw new MatchError(option3);
        }
    }

    private PreparedStatementCache$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.clusterCache = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

