/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ClusteringColumn;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.ColumnDef$;
import com.datastax.spark.connector.cql.ColumnRole;
import com.datastax.spark.connector.cql.KeyspaceDef;
import com.datastax.spark.connector.cql.PartitionKeyColumn$;
import com.datastax.spark.connector.cql.RegularColumn$;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.StaticColumn$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.ColumnType$;
import org.apache.spark.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Schema$
implements Logging,
Serializable {
    public static final Schema$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new Schema$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ColumnDef com$datastax$spark$connector$cql$Schema$$toColumnDef(ColumnMetadata column, ColumnRole columnRole) {
        TableMetadata table = column.getTable();
        KeyspaceMetadata keyspace = table.getKeyspace();
        ColumnType<?> columnType = ColumnType$.MODULE$.fromDriverType(column.getType());
        return new ColumnDef(keyspace.getName(), table.getName(), column.getName(), columnRole, columnType);
    }

    public Seq<ColumnDef> com$datastax$spark$connector$cql$Schema$$fetchPartitionKey(TableMetadata table) {
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(table.getPartitionKey()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(ColumnMetadata column) {
                return Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$toColumnDef(column, PartitionKeyColumn$.MODULE$);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public Seq<ColumnDef> com$datastax$spark$connector$cql$Schema$$fetchClusteringColumns(TableMetadata table) {
        return (Seq)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(table.getClusteringColumns()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<ColumnMetadata, Object> check$ifrefutable$1) {
                Tuple2<ColumnMetadata, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(Tuple2<ColumnMetadata, Object> x$1) {
                Tuple2<ColumnMetadata, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    ColumnMetadata column = (ColumnMetadata)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    ColumnDef columnDef = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$toColumnDef(column, new ClusteringColumn(index));
                    return columnDef;
                }
                throw new MatchError(tuple2);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public Buffer<ColumnDef> com$datastax$spark$connector$cql$Schema$$fetchRegularColumns(TableMetadata table) {
        Set primaryKey = JavaConversions$.MODULE$.asScalaBuffer(table.getPrimaryKey()).toSet();
        Buffer regularColumns = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(table.getColumns()).filterNot((Function1)new Serializable(primaryKey){
            public static final long serialVersionUID = 0L;
            private final Set primaryKey$1;

            public final boolean apply(ColumnMetadata elem) {
                return this.primaryKey$1.contains((Object)elem);
            }
            {
                this.primaryKey$1 = primaryKey$1;
            }
        });
        return (Buffer)regularColumns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnDef apply(ColumnMetadata column) {
                return column.isStatic() ? ColumnDef$.MODULE$.apply(column, StaticColumn$.MODULE$) : ColumnDef$.MODULE$.apply(column, RegularColumn$.MODULE$);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public Schema fromCassandra(CassandraConnector connector, Option<String> keyspaceName, Option<String> tableName) {
        return (Schema)connector.withClusterDo(new Serializable(keyspaceName, tableName){
            public static final long serialVersionUID = 0L;
            private final Option keyspaceName$1;
            private final Option tableName$1;

            public final Schema apply(Cluster cluster) {
                String clusterName = cluster.getMetadata().getClusterName();
                Schema$.MODULE$.logDebug((Function0<String>)new Serializable(this, clusterName){
                    public static final long serialVersionUID = 0L;
                    private final String clusterName$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieving database schema from cluster ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterName$1}));
                    }
                    {
                        this.clusterName$1 = clusterName$1;
                    }
                });
                Set keyspaces = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchKeyspaces$1(cluster.getMetadata(), this.keyspaceName$1, this.tableName$1);
                Schema$.MODULE$.logDebug((Function0<String>)new Serializable(this, clusterName, keyspaces){
                    public static final long serialVersionUID = 0L;
                    private final String clusterName$1;
                    private final Set keyspaces$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " keyspaces fetched from cluster ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.keyspaces$1.size()), this.clusterName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.keyspaces$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(KeyspaceDef x$2) {
                                return x$2.keyspaceName();
                            }
                        }, Set$.MODULE$.canBuildFrom())).mkString("{", ",", "}")}))).toString();
                    }
                    {
                        this.clusterName$1 = clusterName$1;
                        this.keyspaces$1 = keyspaces$1;
                    }
                });
                return new Schema(clusterName, (Set<KeyspaceDef>)keyspaces);
            }
            {
                this.keyspaceName$1 = keyspaceName$1;
                this.tableName$1 = tableName$1;
            }
        });
    }

    public Option<String> fromCassandra$default$2() {
        return None$.MODULE$;
    }

    public Option<String> fromCassandra$default$3() {
        return None$.MODULE$;
    }

    public Schema apply(String clusterName, Set<KeyspaceDef> keyspaces) {
        return new Schema(clusterName, keyspaces);
    }

    public Option<Tuple2<String, Set<KeyspaceDef>>> unapply(Schema x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.clusterName(), x$0.keyspaces()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final boolean com$datastax$spark$connector$cql$Schema$$isKeyspaceSelected$1(KeyspaceMetadata keyspace, Option keyspaceName$1) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = keyspaceName$1;
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    bl = true;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                String name = (String)some.x();
                String string = keyspace.getName();
                String string2 = name;
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public final boolean com$datastax$spark$connector$cql$Schema$$isTableSelected$1(TableMetadata table, Option tableName$1) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = tableName$1;
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    bl = true;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                String name = (String)some.x();
                String string = table.getName();
                String string2 = name;
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public final Set com$datastax$spark$connector$cql$Schema$$fetchTables$1(KeyspaceMetadata keyspace, Option tableName$1) {
        return (Set)JavaConversions$.MODULE$.collectionAsScalaIterable(keyspace.getTables()).toSet().withFilter((Function1)new Serializable(tableName$1){
            public static final long serialVersionUID = 0L;
            private final Option tableName$1;

            public final boolean apply(TableMetadata table) {
                return Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$isTableSelected$1(table, this.tableName$1);
            }
            {
                this.tableName$1 = tableName$1;
            }
        }).map((Function1)new Serializable(keyspace){
            public static final long serialVersionUID = 0L;
            private final KeyspaceMetadata keyspace$1;

            public final TableDef apply(TableMetadata table) {
                Seq<ColumnDef> partitionKey = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchPartitionKey(table);
                Seq<ColumnDef> clusteringColumns = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchClusteringColumns(table);
                Buffer<ColumnDef> regularColumns = Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchRegularColumns(table);
                return new TableDef(this.keyspace$1.getName(), table.getName(), partitionKey, clusteringColumns, (Seq<ColumnDef>)regularColumns);
            }
            {
                this.keyspace$1 = keyspace$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public final Set com$datastax$spark$connector$cql$Schema$$fetchKeyspaces$1(Metadata metadata, Option keyspaceName$1, Option tableName$1) {
        return (Set)JavaConversions$.MODULE$.asScalaBuffer(metadata.getKeyspaces()).toSet().withFilter((Function1)new Serializable(keyspaceName$1){
            public static final long serialVersionUID = 0L;
            private final Option keyspaceName$1;

            public final boolean apply(KeyspaceMetadata keyspace) {
                return Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$isKeyspaceSelected$1(keyspace, this.keyspaceName$1);
            }
            {
                this.keyspaceName$1 = keyspaceName$1;
            }
        }).map((Function1)new Serializable(tableName$1){
            public static final long serialVersionUID = 0L;
            private final Option tableName$1;

            public final KeyspaceDef apply(KeyspaceMetadata keyspace) {
                return new KeyspaceDef(keyspace.getName(), (Set<TableDef>)Schema$.MODULE$.com$datastax$spark$connector$cql$Schema$$fetchTables$1(keyspace, this.tableName$1));
            }
            {
                this.tableName$1 = tableName$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private Schema$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

