/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.AuthConf$;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.NoAuthConf$;
import java.net.InetAddress;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CassandraConnectorConf$
implements Logging,
Serializable {
    public static final CassandraConnectorConf$ MODULE$;
    private final int DefaultRpcPort;
    private final int DefaultNativePort;
    private final String CassandraConnectionHostProperty;
    private final String CassandraConnectionRpcPortProperty;
    private final String CassandraConnectionNativePortProperty;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new CassandraConnectorConf$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int DefaultRpcPort() {
        return this.DefaultRpcPort;
    }

    public int DefaultNativePort() {
        return this.DefaultNativePort;
    }

    public String CassandraConnectionHostProperty() {
        return this.CassandraConnectionHostProperty;
    }

    public String CassandraConnectionRpcPortProperty() {
        return this.CassandraConnectionRpcPortProperty;
    }

    public String CassandraConnectionNativePortProperty() {
        return this.CassandraConnectionNativePortProperty;
    }

    public CassandraConnectorConf apply(InetAddress host, int nativePort, int rpcPort, AuthConf authConf) {
        return new CassandraConnectorConf((Set<InetAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{host}))), nativePort, rpcPort, authConf);
    }

    public CassandraConnectorConf apply(SparkConf conf) {
        Set hosts = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])conf.get(this.CassandraConnectionHostProperty(), InetAddress.getLocalHost().getHostAddress()).split(",")).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<InetAddress> apply(String host) {
                Iterable iterable;
                try {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)InetAddress.getByName(host)));
                }
                catch (Throwable throwable) {
                    Iterable iterable2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    CassandraConnectorConf$.MODULE$.logError((Function0<String>)new Serializable(this, host){
                        public static final long serialVersionUID = 0L;
                        private final String host$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1}));
                        }
                        {
                            this.host$1 = host$1;
                        }
                    }, e);
                    iterable = iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetAddress.class)))).toSet();
        int rpcPort = conf.getInt(this.CassandraConnectionRpcPortProperty(), this.DefaultRpcPort());
        int nativePort = conf.getInt(this.CassandraConnectionNativePortProperty(), this.DefaultNativePort());
        AuthConf authConf = AuthConf$.MODULE$.fromSparkConf(conf);
        return new CassandraConnectorConf((Set<InetAddress>)hosts, nativePort, rpcPort, authConf);
    }

    public int apply$default$2() {
        return this.DefaultNativePort();
    }

    public int apply$default$3() {
        return this.DefaultRpcPort();
    }

    public AuthConf apply$default$4() {
        return NoAuthConf$.MODULE$;
    }

    public CassandraConnectorConf apply(Set<InetAddress> hosts, int nativePort, int rpcPort, AuthConf authConf) {
        return new CassandraConnectorConf(hosts, nativePort, rpcPort, authConf);
    }

    public Option<Tuple4<Set<InetAddress>, Object, Object, AuthConf>> unapply(CassandraConnectorConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4(x$0.hosts(), (Object)BoxesRunTime.boxToInteger((int)x$0.nativePort()), (Object)BoxesRunTime.boxToInteger((int)x$0.rpcPort()), (Object)x$0.authConf()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraConnectorConf$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.DefaultRpcPort = 9160;
        this.DefaultNativePort = 9042;
        this.CassandraConnectionHostProperty = "spark.cassandra.connection.host";
        this.CassandraConnectionRpcPortProperty = "spark.cassandra.connection.rpc.port";
        this.CassandraConnectionNativePortProperty = "spark.cassandra.connection.native.port";
    }
}

