/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.writer.QueryExecutor;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.TableWriter$;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import org.apache.spark.Logging;
import org.apache.spark.TaskContext;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\t%e\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016<&/\u001b;fe*\u00111\u0001B\u0001\u0007oJLG/\u001a:\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001+\tqQg\u0005\u0003\u0001\u001fUA\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0011-%\u0011q#\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00033}i\u0011A\u0007\u0006\u0003\u000fmQ!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO&\u0011\u0001E\u0007\u0002\b\u0019><w-\u001b8h\u0011!)\u0001A!A!\u0002\u0013\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0005\u0003\r\u0019\u0017\u000f\\\u0005\u0003O\u0011\u0012!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\u0005uC\ndW\rR3g!\t\u00193&\u0003\u0002-I\tAA+\u00192mK\u0012+g\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003%\u0011xn^,sSR,'\u000fE\u00021cMj\u0011AA\u0005\u0003e\t\u0011\u0011BU8x/JLG/\u001a:\u0011\u0005Q*D\u0002\u0001\u0003\u0006m\u0001\u0011\ra\u000e\u0002\u0002)F\u0011\u0001h\u000f\t\u0003!eJ!AO\t\u0003\u000f9{G\u000f[5oOB\u0011\u0001\u0003P\u0005\u0003{E\u00111!\u00118z\u0011!y\u0004A!A!\u0002\u0013\u0001\u0015aE7bq\n\u000bGo\u00195TSj,\u0017J\u001c\"zi\u0016\u001c\bC\u0001\tB\u0013\t\u0011\u0015CA\u0002J]RD\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0013[\u0006D()\u0019;dQNK'0Z%o%><8\u000fE\u0002\u0011\r\u0002K!aR\t\u0003\r=\u0003H/[8o\u0011!I\u0005A!A!\u0002\u0013\u0001\u0015\u0001\u00059be\u0006dG.\u001a7jg6dUM^3m\u0011!Y\u0005A!A!\u0002\u0013a\u0015\u0001E2p]NL7\u000f^3oGfdUM^3m!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0003d_J,'BA)\t\u0003\u0019!'/\u001b<fe&\u00111K\u0014\u0002\u0011\u0007>t7/[:uK:\u001c\u0017\u0010T3wK2DQ!\u0016\u0001\u0005\nY\u000ba\u0001P5oSRtD\u0003C,Y3j[F,\u00180\u0011\u0007A\u00021\u0007C\u0003\u0006)\u0002\u0007!\u0005C\u0003*)\u0002\u0007!\u0006C\u0003/)\u0002\u0007q\u0006C\u0003@)\u0002\u0007\u0001\tC\u0003E)\u0002\u0007Q\tC\u0003J)\u0002\u0007\u0001\tC\u0003L)\u0002\u0007A\nC\u0004a\u0001\t\u0007I\u0011A1\u0002\u0019-,\u0017p\u001d9bG\u0016t\u0015-\\3\u0016\u0003\t\u0004\"a\u00194\u000f\u0005A!\u0017BA3\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015\f\u0002B\u00026\u0001A\u0003%!-A\u0007lKf\u001c\b/Y2f\u001d\u0006lW\r\t\u0005\bY\u0002\u0011\r\u0011\"\u0001b\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0003\u0004o\u0001\u0001\u0006IAY\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0003b\u00029\u0001\u0005\u0004%\t!]\u0001\fG>dW/\u001c8OC6,7/F\u0001s!\r\u00198P\u0019\b\u0003ift!!\u001e=\u000e\u0003YT!a\u001e\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012B\u0001>\u0012\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001`?\u0003\u0007M+\u0017O\u0003\u0002{#!1q\u0010\u0001Q\u0001\nI\fAbY8mk6tg*Y7fg\u0002B\u0011\"a\u0001\u0001\u0005\u0004%\t!!\u0002\u0002\u000f\r|G.^7ogV\u0011\u0011q\u0001\t\u0007\u0003\u0013\ty!!\u0005\u000e\u0005\u0005-!bAA\u0007#\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007q\fY\u0001E\u0002$\u0003'I1!!\u0006%\u0005%\u0019u\u000e\\;n]\u0012+g\r\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\u0004\u0003!\u0019w\u000e\\;n]N\u0004\u0003bBA\u000f\u0001\u0011%\u0011qD\u0001\u0006cV|G/\u001a\u000b\u0004E\u0006\u0005\u0002bBA\u0012\u00037\u0001\rAY\u0001\u0005]\u0006lW\rC\u0005\u0002(\u0001A)\u0019!C\u0005C\u0006A\u0012/^3ssR+W\u000e\u001d7bi\u0016,6/\u001b8h\u0013:\u001cXM\u001d;\t\u0013\u0005-\u0002\u0001#A!B\u0013\u0011\u0017!G9vKJLH+Z7qY\u0006$X-V:j]\u001eLen]3si\u0002B\u0011\"a\f\u0001\u0011\u000b\u0007I\u0011B1\u00021E,XM]=UK6\u0004H.\u0019;f+NLgnZ+qI\u0006$X\rC\u0005\u00024\u0001A\t\u0011)Q\u0005E\u0006I\u0012/^3ssR+W\u000e\u001d7bi\u0016,6/\u001b8h+B$\u0017\r^3!\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI$A\bjg\u000e{WO\u001c;feV\u0003H-\u0019;f+\t\tY\u0004E\u0002\u0011\u0003{I1!a\u0010\u0012\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0011\u0001A\u0003%\u00111H\u0001\u0011SN\u001cu.\u001e8uKJ,\u0006\u000fZ1uK\u0002B\u0001\"a\u0012\u0001\u0005\u0004%I!Y\u0001\u000ecV,'/\u001f+f[Bd\u0017\r^3\t\u000f\u0005-\u0003\u0001)A\u0005E\u0006q\u0011/^3ssR+W\u000e\u001d7bi\u0016\u0004\u0003bBA(\u0001\u0011%\u0011\u0011K\u0001\u0011aJ,\u0007/\u0019:f'R\fG/Z7f]R$B!a\u0015\u0002ZA\u0019Q*!\u0016\n\u0007\u0005]cJA\tQe\u0016\u0004\u0018M]3e'R\fG/Z7f]RD\u0001\"a\u0017\u0002N\u0001\u0007\u0011QL\u0001\bg\u0016\u001c8/[8o!\ri\u0015qL\u0005\u0004\u0003Cr%aB*fgNLwN\u001c\u0005\b\u0003K\u0002A\u0011BA4\u0003-\u0019'/Z1uK\n\u000bGo\u00195\u0015\r\u0005%\u0014qNA;!\ri\u00151N\u0005\u0004\u0003[r%A\u0004\"bi\u000eD7\u000b^1uK6,g\u000e\u001e\u0005\t\u0003c\n\u0019\u00071\u0001\u0002t\u0005!A-\u0019;b!\u0015\tI!a\u00044\u0011!\t9(a\u0019A\u0002\u0005M\u0013\u0001B:u[RDq!a\u001f\u0001\t\u0013\ti(\u0001\u000bnK\u0006\u001cXO]3NCbLen]3siNK'0\u001a\u000b\b\u0001\u0006}\u0014qQAE\u0011!\t\t(!\u001fA\u0002\u0005\u0005\u0005#BA\u0005\u0003\u0007\u001b\u0014\u0002BAC\u0003\u0017\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\t\u0003o\nI\b1\u0001\u0002T!A\u00111RA=\u0001\u0004\ti)A\u0007rk\u0016\u0014\u00180\u0012=fGV$xN\u001d\t\u0004a\u0005=\u0015bAAI\u0005\ti\u0011+^3ss\u0016CXmY;u_JDq!!&\u0001\t\u0013\t9*\u0001\tpaRLW.^7CCR\u001c\u0007nU5{KR9\u0001)!'\u0002\u001c\u0006u\u0005\u0002CA9\u0003'\u0003\r!!!\t\u0011\u0005]\u00141\u0013a\u0001\u0003'B\u0001\"a#\u0002\u0014\u0002\u0007\u0011Q\u0012\u0005\b\u0003C\u0003A\u0011BAR\u000319(/\u001b;f\u0005\u0006$8\r[3e))\t)+a+\u0002.\u0006=\u0016\u0011\u0017\t\u0004!\u0005\u001d\u0016bAAU#\t!QK\\5u\u0011!\t\t(a(A\u0002\u0005\u0005\u0005\u0002CA<\u0003?\u0003\r!a\u0015\t\u0011\u0005-\u0015q\u0014a\u0001\u0003\u001bCq!a-\u0002 \u0002\u0007\u0001)A\u0005cCR\u001c\u0007nU5{K\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0016AD<sSR,WK\u001c2bi\u000eDW\r\u001a\u000b\t\u0003K\u000bY,!0\u0002@\"A\u0011\u0011OA[\u0001\u0004\t\t\t\u0003\u0005\u0002x\u0005U\u0006\u0019AA*\u0011!\tY)!.A\u0002\u00055\u0005bBAb\u0001\u0011\u0005\u0011QY\u0001\u0006oJLG/\u001a\u000b\u0007\u0003K\u000b9-!5\t\u0011\u0005%\u0017\u0011\u0019a\u0001\u0003\u0017\f1\u0002^1tW\u000e{g\u000e^3yiB\u0019\u0011$!4\n\u0007\u0005='DA\u0006UCN\\7i\u001c8uKb$\b\u0002CA9\u0003\u0003\u0004\r!!!\b\u000f\u0005U'\u0001#\u0001\u0002X\u0006YA+\u00192mK^\u0013\u0018\u000e^3s!\r\u0001\u0014\u0011\u001c\u0004\u0007\u0003\tA\t!a7\u0014\t\u0005ew\"\u0006\u0005\b+\u0006eG\u0011AAp)\t\t9\u000e\u0003\u0006\u0002d\u0006e'\u0019!C\u0001\u0003K\fq\u0003R3gCVdG\u000fU1sC2dW\r\\5t[2+g/\u001a7\u0016\u0003\u0001C\u0001\"!;\u0002Z\u0002\u0006I\u0001Q\u0001\u0019\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000eT3wK2\u0004\u0003BCAw\u00033\u0014\r\u0011\"\u0001\u0002f\u0006!R*Z1tkJ,G-\u00138tKJ$8oQ8v]RD\u0001\"!=\u0002Z\u0002\u0006I\u0001Q\u0001\u0016\u001b\u0016\f7/\u001e:fI&s7/\u001a:ug\u000e{WO\u001c;!\u0011)\t)0!7C\u0002\u0013\u0005\u0011Q]\u0001\u0018\t\u00164\u0017-\u001e7u\u0005\u0006$8\r[*ju\u0016LeNQ=uKND\u0001\"!?\u0002Z\u0002\u0006I\u0001Q\u0001\u0019\t\u00164\u0017-\u001e7u\u0005\u0006$8\r[*ju\u0016LeNQ=uKN\u0004\u0003\u0002CA\u007f\u00033$\t!a@\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\t\u0005!\u0011\u0002\u000b\u0013\u0005\u0007\u0011)Ca\n\u0003*\t-\"Q\u0006B\u001c\u0005w\u0011y\u0004\u0006\u0004\u0003\u0006\t-!1\u0004\t\u0005a\u0001\u00119\u0001E\u00025\u0005\u0013!aANA~\u0005\u00049\u0004B\u0003B\u0007\u0003w\f\t\u0011q\u0001\u0003\u0010\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\tE!q\u0003B\u0004\u001b\t\u0011\u0019BC\u0002\u0003\u0016E\tqA]3gY\u0016\u001cG/\u0003\u0003\u0003\u001a\tM!\u0001C\"mCN\u001cH+Y4\t\u0015\tu\u00111`A\u0001\u0002\b\u0011y\"\u0001\u0006fm&$WM\\2fII\u0002R\u0001\rB\u0011\u0005\u000fI1Aa\t\u0003\u0005A\u0011vn^,sSR,'OR1di>\u0014\u0018\u0010\u0003\u0004\u0006\u0003w\u0004\rA\t\u0005\u0007A\u0006m\b\u0019\u00012\t\r1\fY\u00101\u0001c\u0011\u0019Y\u00151 a\u0001\u0019\"9\u0001/a?A\u0002\t=\u0002\u0003\u0002B\u0019\u0005gi\u0011\u0001B\u0005\u0004\u0005k!!AD\"pYVlgnU3mK\u000e$xN\u001d\u0005\n\u0005s\tY\u0010%AA\u0002\u0001\u000b\u0001CY1uG\"\u001c\u0016N_3J]\nKH/Z:\t\u0013\tu\u00121 I\u0001\u0002\u0004)\u0015a\u00042bi\u000eD7+\u001b>f\u0013:\u0014vn^:\t\u0011%\u000bY\u0010%AA\u0002\u0001C!Ba\u0011\u0002ZF\u0005I\u0011\u0001B#\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u00122T\u0003\u0002B$\u0005;*\"A!\u0013+\u0007\u0001\u0013Ye\u000b\u0002\u0003NA!!q\nB-\u001b\t\u0011\tF\u0003\u0003\u0003T\tU\u0013!C;oG\",7m[3e\u0015\r\u00119&E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B.\u0005#\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u00191$\u0011\tb\u0001o!Q!\u0011MAm#\u0003%\tAa\u0019\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uI]*BA!\u001a\u0003jU\u0011!q\r\u0016\u0004\u000b\n-CA\u0002\u001c\u0003`\t\u0007q\u0007\u0003\u0006\u0003n\u0005e\u0017\u0013!C\u0001\u0005_\nq\"\u00199qYf$C-\u001a4bk2$H\u0005O\u000b\u0005\u0005\u000f\u0012\t\b\u0002\u00047\u0005W\u0012\ra\u000e\u0005\u000b\u0005k\nI.!A\u0005\n\t]\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u001f\u0011\t\tm$QQ\u0007\u0003\u0005{RAAa \u0003\u0002\u0006!A.\u00198h\u0015\t\u0011\u0019)\u0001\u0003kCZ\f\u0017\u0002\u0002BD\u0005{\u0012aa\u00142kK\u000e$\b")
public class TableWriter<T>
implements Serializable,
Logging {
    private final CassandraConnector connector;
    public final RowWriter<T> com$datastax$spark$connector$writer$TableWriter$$rowWriter;
    private final int maxBatchSizeInBytes;
    private final Option<Object> maxBatchSizeInRows;
    public final int com$datastax$spark$connector$writer$TableWriter$$parallelismLevel;
    public final ConsistencyLevel com$datastax$spark$connector$writer$TableWriter$$consistencyLevel;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private final Seq<ColumnDef> columns;
    private String queryTemplateUsingInsert;
    private String queryTemplateUsingUpdate;
    private final boolean isCounterUpdate;
    private final String queryTemplate;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    public static <T> int apply$default$8() {
        return TableWriter$.MODULE$.apply$default$8();
    }

    public static <T> Option<Object> apply$default$7() {
        return TableWriter$.MODULE$.apply$default$7();
    }

    public static <T> int apply$default$6() {
        return TableWriter$.MODULE$.apply$default$6();
    }

    public static <T> TableWriter<T> apply(CassandraConnector cassandraConnector, String string, String string2, ConsistencyLevel consistencyLevel, ColumnSelector columnSelector, int n, Option<Object> option, int n2, ClassTag<T> classTag, RowWriterFactory<T> rowWriterFactory) {
        return TableWriter$.MODULE$.apply(cassandraConnector, string, string2, consistencyLevel, columnSelector, n, option, n2, classTag, rowWriterFactory);
    }

    public static int DefaultBatchSizeInBytes() {
        return TableWriter$.MODULE$.DefaultBatchSizeInBytes();
    }

    public static int MeasuredInsertsCount() {
        return TableWriter$.MODULE$.MeasuredInsertsCount();
    }

    public static int DefaultParallelismLevel() {
        return TableWriter$.MODULE$.DefaultParallelismLevel();
    }

    private String queryTemplateUsingInsert$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq quotedColumnNames2 = (Seq)this.columnNames().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TableWriter $outer;

                    public final String apply(String name) {
                        return this.$outer.com$datastax$spark$connector$writer$TableWriter$$quote(name);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String columnSpec = quotedColumnNames2.mkString(", ");
                String valueSpec = ((TraversableOnce)quotedColumnNames2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$1) {
                        return new StringBuilder().append((Object)":").append((Object)x$1).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                this.queryTemplateUsingInsert = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", ".", " (", ") VALUES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.com$datastax$spark$connector$writer$TableWriter$$quote(this.keyspaceName()), this.com$datastax$spark$connector$writer$TableWriter$$quote(this.tableName()), columnSpec, valueSpec}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.queryTemplateUsingInsert;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String queryTemplateUsingUpdate$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Tuple2 tuple23 = this.columns().partition((Function1)new $anonfun$3(this));
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Seq primaryKey = (Seq)tuple23._1();
                Seq regularColumns = (Seq)tuple23._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
                Seq primaryKey2 = (Seq)tuple24._1();
                Seq regularColumns2 = (Seq)tuple24._2();
                Tuple2 tuple25 = regularColumns2.partition((Function1)new $anonfun$4(this));
                if (tuple25 == null) throw new MatchError((Object)tuple25);
                Seq counterColumns = (Seq)tuple25._1();
                Seq nonCounterColumns = (Seq)tuple25._2();
                Tuple2 tuple26 = tuple2 = new Tuple2((Object)counterColumns, (Object)nonCounterColumns);
                Seq counterColumns2 = (Seq)tuple26._1();
                Seq nonCounterColumns2 = (Seq)tuple26._2();
                Seq setNonCounterColumnsClause = (Seq)this.quotedColumnNames$1(nonCounterColumns2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq setCounterColumnsClause = (Seq)this.quotedColumnNames$1(counterColumns2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String setClause = ((TraversableOnce)setNonCounterColumnsClause.$plus$plus((GenTraversableOnce)setCounterColumnsClause, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String whereClause = ((TraversableOnce)this.quotedColumnNames$1(primaryKey2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
                this.queryTemplateUsingUpdate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", ".", " SET ", " WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.com$datastax$spark$connector$writer$TableWriter$$quote(this.keyspaceName()), this.com$datastax$spark$connector$writer$TableWriter$$quote(this.tableName()), setClause, whereClause}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.queryTemplateUsingUpdate;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public Seq<ColumnDef> columns() {
        return this.columns;
    }

    public String com$datastax$spark$connector$writer$TableWriter$$quote(String name) {
        return new StringBuilder().append((Object)"\"").append((Object)name).append((Object)"\"").toString();
    }

    private String queryTemplateUsingInsert() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.queryTemplateUsingInsert$lzycompute() : this.queryTemplateUsingInsert;
    }

    private String queryTemplateUsingUpdate() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.queryTemplateUsingUpdate$lzycompute() : this.queryTemplateUsingUpdate;
    }

    private boolean isCounterUpdate() {
        return this.isCounterUpdate;
    }

    private String queryTemplate() {
        return this.queryTemplate;
    }

    public PreparedStatement com$datastax$spark$connector$writer$TableWriter$$prepareStatement(Session session) {
        try {
            return session.prepare(this.queryTemplate());
        }
        catch (Throwable throwable) {
            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to prepare statement ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.queryTemplate()}))).append((Object)throwable.getMessage()).toString(), throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public BatchStatement com$datastax$spark$connector$writer$TableWriter$$createBatch(Seq<T> data, PreparedStatement stmt) {
        void var3_3;
        BatchStatement batchStmt = this.isCounterUpdate() ? new BatchStatement(BatchStatement.Type.COUNTER) : new BatchStatement(BatchStatement.Type.UNLOGGED);
        data.foreach((Function1)new Serializable(this, stmt, batchStmt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final PreparedStatement stmt$1;
            private final BatchStatement batchStmt$1;

            public final BatchStatement apply(T row) {
                return this.batchStmt$1.add((Statement)this.$outer.com$datastax$spark$connector$writer$TableWriter$$rowWriter.bind(row, this.stmt$1));
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.stmt$1 = stmt$1;
                this.batchStmt$1 = var3_3;
            }
        });
        return var3_3;
    }

    private int measureMaxInsertSize(Iterator<T> data, PreparedStatement stmt, QueryExecutor queryExecutor) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing ", " rows to ", ".", " and measuring maximum serialized row size..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)TableWriter$.MODULE$.MeasuredInsertsCount()), this.$outer.keyspaceName(), this.$outer.tableName()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        IntRef maxInsertSize = new IntRef(1);
        data.take(TableWriter$.MODULE$.MeasuredInsertsCount()).foreach((Function1)new Serializable(this, stmt, queryExecutor, maxInsertSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final PreparedStatement stmt$2;
            private final QueryExecutor queryExecutor$1;
            private final IntRef maxInsertSize$1;

            public final void apply(T row) {
                BoundStatement insert = this.$outer.com$datastax$spark$connector$writer$TableWriter$$rowWriter.bind(row, this.stmt$2);
                this.queryExecutor$1.executeAsync(insert);
                int size = this.$outer.com$datastax$spark$connector$writer$TableWriter$$rowWriter.estimateSizeInBytes(row);
                if (size > this.maxInsertSize$1.elem) {
                    this.maxInsertSize$1.elem = size;
                }
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.stmt$2 = stmt$2;
                this.queryExecutor$1 = var3_3;
                this.maxInsertSize$1 = var4_4;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, maxInsertSize){
            public static final long serialVersionUID = 0L;
            private final IntRef maxInsertSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum serialized row size: "})).s((Seq)Nil$.MODULE$)).append((Object)BoxesRunTime.boxToInteger((int)this.maxInsertSize$1.elem)).append((Object)" B").toString();
            }
            {
                this.maxInsertSize$1 = maxInsertSize$1;
            }
        });
        return maxInsertSize.elem;
    }

    public int com$datastax$spark$connector$writer$TableWriter$$optimumBatchSize(Iterator<T> data, PreparedStatement stmt, QueryExecutor queryExecutor) {
        Option<Object> option;
        block4: {
            int n;
            block3: {
                block2: {
                    int size;
                    option = this.maxBatchSizeInRows;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    n = size = BoxesRunTime.unboxToInt((Object)some.x());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                int maxInsertSize = this.measureMaxInsertSize(data, stmt, queryExecutor);
                n = package$.MODULE$.max(1, this.maxBatchSizeInBytes / (maxInsertSize * 2));
            }
            return n;
        }
        throw new MatchError(option);
    }

    public void com$datastax$spark$connector$writer$TableWriter$$writeBatched(Iterator<T> data, PreparedStatement stmt, QueryExecutor queryExecutor, int batchSize) {
        data.grouped(batchSize).foreach((Function1)new Serializable(this, stmt, queryExecutor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final PreparedStatement stmt$3;
            private final QueryExecutor queryExecutor$2;

            public final ListenableFuture<ResultSet> apply(Seq<T> batch) {
                BatchStatement batchStmt = this.$outer.com$datastax$spark$connector$writer$TableWriter$$createBatch(batch, this.stmt$3);
                return this.queryExecutor$2.executeAsync(batchStmt);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.stmt$3 = stmt$3;
                this.queryExecutor$2 = var3_3;
            }
        });
    }

    public void com$datastax$spark$connector$writer$TableWriter$$writeUnbatched(Iterator<T> data, PreparedStatement stmt, QueryExecutor queryExecutor) {
        data.foreach((Function1)new Serializable(this, stmt, queryExecutor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final PreparedStatement stmt$4;
            private final QueryExecutor queryExecutor$3;

            public final ListenableFuture<ResultSet> apply(T row) {
                return this.queryExecutor$3.executeAsync(this.$outer.com$datastax$spark$connector$writer$TableWriter$$rowWriter.bind(row, this.stmt$4));
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.stmt$4 = stmt$4;
                this.queryExecutor$3 = var3_3;
            }
        });
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        this.connector.withSessionDo(new Serializable(this, data){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final Iterator data$1;

            public final void apply(Session session) {
                CountingIterator<T> rowIterator = new CountingIterator<T>(this.data$1);
                long startTime = System.currentTimeMillis();
                PreparedStatement stmt = this.$outer.com$datastax$spark$connector$writer$TableWriter$$prepareStatement(session);
                stmt.setConsistencyLevel(this.$outer.com$datastax$spark$connector$writer$TableWriter$$consistencyLevel);
                QueryExecutor queryExecutor = new QueryExecutor(session, this.$outer.com$datastax$spark$connector$writer$TableWriter$$parallelismLevel);
                int batchSize = this.$outer.com$datastax$spark$connector$writer$TableWriter$$optimumBatchSize(rowIterator, stmt, queryExecutor);
                this.$outer.logInfo((Function0<String>)new Serializable(this, batchSize){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;
                    private final int batchSize$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing data partition to ", ".", " in batches of ", " rows each."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName(), BoxesRunTime.boxToInteger((int)this.batchSize$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.batchSize$1 = batchSize$1;
                    }
                });
                int n = batchSize;
                switch (n) {
                    default: {
                        this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeBatched(rowIterator, stmt, queryExecutor, batchSize);
                        break;
                    }
                    case 1: {
                        this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeUnbatched(rowIterator, stmt, queryExecutor);
                    }
                }
                queryExecutor.waitForCurrentlyExecutingTasks();
                if (queryExecutor.failureCount() > 0) {
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write ", " batches to ", ".", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)queryExecutor.failureCount()), this.$outer.keyspaceName(), this.$outer.tableName()})));
                }
                long endTime = System.currentTimeMillis();
                double duration = (double)(endTime - startTime) / 1000.0;
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$write$1 $outer;
                    private final CountingIterator rowIterator$1;
                    private final QueryExecutor queryExecutor$4;
                    private final double duration$1;

                    public final String apply() {
                        Integer arg$1 = BoxesRunTime.boxToInteger((int)this.rowIterator$1.count());
                        Integer arg$2 = BoxesRunTime.boxToInteger((int)this.queryExecutor$4.successCount());
                        String arg$3 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName();
                        String arg$4 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName();
                        double arg$5 = this.duration$1;
                        return new StringOps(Predef$.MODULE$.augmentString("Wrote %s rows in %s batches to %s.%s in %.3f s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1, arg$2, arg$3, arg$4, BoxesRunTime.boxToDouble((double)arg$5)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rowIterator$1 = rowIterator$1;
                        this.queryExecutor$4 = queryExecutor$4;
                        this.duration$1 = duration$1;
                    }
                });
            }

            public /* synthetic */ TableWriter com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.data$1 = data$1;
            }
        });
    }

    private final Seq quotedColumnNames$1(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$6) {
                return x$6.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;

            public final String apply(String name) {
                return this.$outer.com$datastax$spark$connector$writer$TableWriter$$quote(name);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public TableWriter(CassandraConnector connector, TableDef tableDef, RowWriter<T> rowWriter, int maxBatchSizeInBytes, Option<Object> maxBatchSizeInRows, int parallelismLevel, ConsistencyLevel consistencyLevel) {
        this.connector = connector;
        this.com$datastax$spark$connector$writer$TableWriter$$rowWriter = rowWriter;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
        this.maxBatchSizeInRows = maxBatchSizeInRows;
        this.com$datastax$spark$connector$writer$TableWriter$$parallelismLevel = parallelismLevel;
        this.com$datastax$spark$connector$writer$TableWriter$$consistencyLevel = consistencyLevel;
        Logging.class.$init$((Logging)this);
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = rowWriter.columnNames();
        this.columns = (Seq)this.columnNames().map(tableDef.columnByName(), Seq$.MODULE$.canBuildFrom());
        this.isCounterUpdate = tableDef.allColumns().exists((Function1)new $anonfun$8(this));
        this.queryTemplate = this.isCounterUpdate() ? this.queryTemplateUsingUpdate() : this.queryTemplateUsingInsert();
    }
}

