package com.datastax.spark.connector.types

import scala.language.existentials
import scala.reflect.runtime.universe._

trait CollectionColumnType[T] extends ColumnType[T] {
  def isCollection = true
}

case class ListType[T](elemType: ColumnType[T]) extends CollectionColumnType[Vector[T]] {
  @transient
  lazy val scalaTypeTag = TypeTag.synchronized {
    implicit val elemTypeTag = elemType.scalaTypeTag
    implicitly[TypeTag[Vector[T]]]
  }

  def cqlTypeName = s"list<${elemType.cqlTypeName}>"
}

case class SetType[T](elemType: ColumnType[T]) extends CollectionColumnType[Set[T]] {
  @transient
  lazy val scalaTypeTag = TypeTag.synchronized {
    implicit val elemTypeTag = elemType.scalaTypeTag
    implicitly[TypeTag[Set[T]]]
  }

  def cqlTypeName = s"set<${elemType.cqlTypeName}>"
}

case class MapType[K, V](keyType: ColumnType[K], valueType: ColumnType[V]) extends CollectionColumnType[Map[K, V]] {
  @transient
  lazy val scalaTypeTag = TypeTag.synchronized {
    implicit val keyTypeTag = keyType.scalaTypeTag
    implicit val valueTypeTag = valueType.scalaTypeTag
    implicitly[TypeTag[Map[K, V]]]
  }

  def cqlTypeName = s"map<${keyType.cqlTypeName}, ${valueType.cqlTypeName}>"
}

