/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.foundation.TreeKeyIterator;
import com.db4o.internal.TreeInt;

public class IDMappingCollector {
    private static final int ID_BATCH_SIZE = 4096;
    private TreeInt _ids;

    void createIDMapping(DefragmentServicesImpl context, int objectID, boolean isClassID) {
        if (this.batchFull()) {
            this.flush(context);
        }
        this._ids = TreeInt.add(this._ids, isClassID ? -objectID : objectID);
    }

    private boolean batchFull() {
        return this._ids != null && this._ids.size() == 4096;
    }

    public void flush(DefragmentServicesImpl context) {
        if (this._ids == null) {
            return;
        }
        TreeKeyIterator idIter = new TreeKeyIterator(this._ids);
        while (idIter.moveNext()) {
            int objectID = (Integer)idIter.current();
            boolean isClassID = false;
            if (objectID < 0) {
                objectID = -objectID;
                isClassID = true;
            }
            context.mapIDs(objectID, context.targetNewId(), isClassID);
        }
        context.mapping().commit();
        this._ids = null;
    }
}

