/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.Algorithms4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Comparison4;
import com.db4o.foundation.Sortable4;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays4 {
    public static int[] copyOf(int[] src, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(src, 0, copy, 0, Math.min(src.length, newLength));
        return copy;
    }

    public static int indexOfIdentity(Object[] array, Object element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfEquals(Object[] array, Object expected) {
        for (int i = 0; i < array.length; ++i) {
            if (!expected.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static boolean equals(byte[] x, byte[] y) {
        if (x == y) {
            return true;
        }
        if (x == null) {
            return false;
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (y[i] == x[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] x, Object[] y) {
        if (x == y) {
            return true;
        }
        if (x == null) {
            return false;
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (Arrays4.objectsAreEqual(y[i], x[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean objectsAreEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public static boolean containsInstanceOf(Object[] array, Class klass) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!klass.isInstance(array[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> void fill(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static Collection4 asList(Object[] arr) {
        Collection4<Object> coll = new Collection4<Object>();
        for (int arrIdx = 0; arrIdx < arr.length; ++arrIdx) {
            coll.add(arr[arrIdx]);
        }
        return coll;
    }

    public static Object[] merge(Object[] a, Object[] b, Class arrayType) {
        Object[] merged = (Object[])Array.newInstance(arrayType, a.length + b.length);
        System.arraycopy(a, 0, merged, 0, a.length);
        System.arraycopy(b, 0, merged, a.length, b.length);
        return merged;
    }

    public static void sort(final Object[] array, final Comparison4 comparator) {
        Algorithms4.sort(new Sortable4(){

            public void swap(int leftIndex, int rightIndex) {
                Object leftValue = array[leftIndex];
                array[leftIndex] = array[rightIndex];
                array[rightIndex] = leftValue;
            }

            public int size() {
                return array.length;
            }

            public int compare(int leftIndex, int rightIndex) {
                return comparator.compare(array[leftIndex], array[rightIndex]);
            }
        });
    }
}

