/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ObjectInfo;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualAttributes;

public class FrozenObjectInfo
implements ObjectInfo {
    private final Db4oDatabase _sourceDatabase;
    private final long _uuidLongPart;
    private final long _id;
    private final long _commitTimestamp;
    private final Object _object;

    public FrozenObjectInfo(Object object, long id, Db4oDatabase sourceDatabase, long uuidLongPart, long commitTimestamp) {
        this._sourceDatabase = sourceDatabase;
        this._uuidLongPart = uuidLongPart;
        this._id = id;
        this._commitTimestamp = commitTimestamp;
        this._object = object;
    }

    private FrozenObjectInfo(ObjectReference ref, VirtualAttributes virtualAttributes) {
        this(ref == null ? null : ref.getObject(), ref == null ? -1L : (long)ref.getID(), virtualAttributes == null ? null : virtualAttributes.i_database, virtualAttributes == null ? -1L : virtualAttributes.i_uuid, virtualAttributes == null ? 0L : virtualAttributes.i_version);
    }

    public FrozenObjectInfo(Transaction trans, ObjectReference ref, boolean committed) {
        this(ref, FrozenObjectInfo.isInstantiatedReference(ref) ? ref.virtualAttributes(trans, committed) : null);
    }

    private static boolean isInstantiatedReference(ObjectReference ref) {
        return ref != null && ref.getObject() != null;
    }

    public long getInternalID() {
        return this._id;
    }

    public Object getObject() {
        return this._object;
    }

    public Db4oUUID getUUID() {
        if (this._sourceDatabase == null) {
            return null;
        }
        return new Db4oUUID(this._uuidLongPart, this._sourceDatabase.getSignature());
    }

    public long getVersion() {
        return this.getCommitTimestamp();
    }

    public long getCommitTimestamp() {
        return this._commitTimestamp;
    }

    public long sourceDatabaseId(Transaction trans) {
        if (this._sourceDatabase == null) {
            return -1L;
        }
        return this._sourceDatabase.getID(trans);
    }

    public long uuidLongPart() {
        return this._uuidLongPart;
    }
}

