/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.EmbeddedObjectContainer;
import com.db4o.ObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.DatabaseMaximumSizeReachedException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.InvalidIDException;
import com.db4o.ext.InvalidSlotException;
import com.db4o.ext.OldFormatException;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.IntArrayList;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Lock4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ArrayType;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Const4;
import com.db4o.internal.ExternalObjectContainer;
import com.db4o.internal.IDHandler;
import com.db4o.internal.Indexable4;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerSession;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.SystemInfoFileImpl;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.convert.ConversionStage;
import com.db4o.internal.convert.Converter;
import com.db4o.internal.events.EventRegistryImpl;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.BlockAwareFreespaceManager;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.ids.StandardIdSystemFactory;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.ids.TransactionalIdSystemImpl;
import com.db4o.internal.qlin.QLinRoot;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.processor.QQueryBase;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.HybridQueryResult;
import com.db4o.internal.query.result.IdListQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.references.ReferenceSystem;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChangeFactory;
import com.db4o.qlin.QLin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalObjectContainer
extends ExternalObjectContainer
implements InternalObjectContainer,
EmbeddedObjectContainer {
    protected FileHeader _fileHeader;
    private final Collection4 _dirtyClassMetadata = new Collection4();
    private FreespaceManager _freespaceManager;
    private boolean i_isServer = false;
    private Lock4 _semaphoresLock = new Lock4();
    private Hashtable4 _semaphores;
    private int _blockEndAddress;
    private SystemData _systemData;
    private IdSystem _idSystem;
    private final byte[] _pointerBuffer = new byte[8];
    protected final ByteArrayBuffer _pointerIo = new ByteArrayBuffer(8);

    LocalObjectContainer(Configuration config) {
        super(config);
    }

    @Override
    public Transaction newTransaction(Transaction parentTransaction, ReferenceSystem referenceSystem, boolean isSystemTransaction) {
        TransactionalIdSystem systemIdSystem = null;
        if (!isSystemTransaction) {
            systemIdSystem = this.systemTransaction().idSystem();
        }
        Closure4<IdSystem> idSystem = new Closure4<IdSystem>(){

            @Override
            public IdSystem run() {
                return LocalObjectContainer.this.idSystem();
            }
        };
        TransactionalIdSystem transactionalIdSystem = this.newTransactionalIdSystem(systemIdSystem, idSystem);
        return new LocalTransaction(this, parentTransaction, transactionalIdSystem, referenceSystem);
    }

    public TransactionalIdSystem newTransactionalIdSystem(TransactionalIdSystem systemIdSystem, Closure4<IdSystem> idSystem) {
        return new TransactionalIdSystemImpl(new Closure4<FreespaceManager>(){

            @Override
            public FreespaceManager run() {
                return LocalObjectContainer.this.freespaceManager();
            }
        }, idSystem, (TransactionalIdSystemImpl)systemIdSystem);
    }

    public FreespaceManager freespaceManager() {
        return this._freespaceManager;
    }

    public void blockSizeReadFromFile(int size) {
        this.blockSize(size);
        this.setRegularEndAddress(this.fileLength());
    }

    public void setRegularEndAddress(long address) {
        this._blockEndAddress = this._blockConverter.bytesToBlocks(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void close2() {
        try {
            if (!this._config.isReadOnly()) {
                this.commitTransaction();
                this.shutdown();
            }
        }
        finally {
            this.shutdownObjectContainer();
        }
    }

    @Override
    public void commit1(Transaction trans) {
        trans.commit();
    }

    void configureNewFile() {
        this.blockSize(this.configImpl().blockSize());
        this._fileHeader = FileHeader.newCurrentFileHeader();
        this.setRegularEndAddress(this._fileHeader.length());
        this.newSystemData(this.configImpl().freespaceSystem(), this.configImpl().idSystemType());
        this.systemData().converterVersion(12);
        this.createStringIO(this._systemData.stringEncoding());
        this.createIdSystem();
        this.initializeClassMetadataRepository();
        this.initalizeWeakReferenceSupport();
        this.generateNewIdentity();
        AbstractFreespaceManager blockedFreespaceManager = AbstractFreespaceManager.createNew(this);
        this.installFreespaceManager(blockedFreespaceManager);
        this.initNewClassCollection();
        this.initializeEssentialClasses();
        this._fileHeader.initNew(this);
        blockedFreespaceManager.start(0);
    }

    private void newSystemData(byte freespaceSystemType, byte idSystemType) {
        this._systemData = new SystemData();
        this._systemData.stringEncoding(this.configImpl().encoding());
        this._systemData.freespaceSystem(freespaceSystemType);
        this._systemData.idSystemType(idSystemType);
    }

    @Override
    public int converterVersion() {
        return this._systemData.converterVersion();
    }

    @Override
    public long currentVersion() {
        return this._timeStampIdGenerator.last();
    }

    void initNewClassCollection() {
        this.classCollection().initTables(1);
    }

    public final BTree createBTreeClassIndex(int id) {
        return new BTree(this._transaction, id, (Indexable4)new IDHandler());
    }

    public final AbstractQueryResult newQueryResult(Transaction trans) {
        return this.newQueryResult(trans, this.config().evaluationMode());
    }

    @Override
    public final AbstractQueryResult newQueryResult(Transaction trans, QueryEvaluationMode mode) {
        if (trans == null) {
            throw new ArgumentNullException();
        }
        if (mode == QueryEvaluationMode.IMMEDIATE) {
            return new IdListQueryResult(trans);
        }
        return new HybridQueryResult(trans, mode);
    }

    @Override
    public final boolean delete4(Transaction transaction, ObjectReference ref, Object obj, int cascade, boolean userCall) {
        int id = ref.getID();
        StatefulBuffer reader = this.readStatefulBufferById(transaction, id);
        if (reader != null) {
            if (obj != null && !this.showInternalClasses() && Const4.CLASS_INTERNAL.isAssignableFrom(obj.getClass())) {
                return false;
            }
            reader.setCascadeDeletes(cascade);
            transaction.idSystem().notifySlotDeleted(id, SlotChangeFactory.USER_OBJECTS);
            ClassMetadata classMetadata = ref.classMetadata();
            classMetadata.delete(reader, obj);
            return true;
        }
        return false;
    }

    public abstract long fileLength();

    public abstract String fileName();

    public void free(Slot slot) {
        if (slot.isNull()) {
            return;
        }
        if (this._freespaceManager == null) {
            return;
        }
        if (DTrace.enabled) {
            DTrace.FILE_FREE.logLength((long)slot.address(), slot.length());
        }
        this._freespaceManager.free(slot);
    }

    public void free(int address, int a_length) {
        this.free(new Slot(address, a_length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateNewIdentity() {
        Object object = this._lock;
        synchronized (object) {
            this.setIdentity(Db4oDatabase.generate());
        }
    }

    @Override
    public AbstractQueryResult queryAllObjects(Transaction trans) {
        return this.getAll(trans, this.config().evaluationMode());
    }

    public AbstractQueryResult getAll(Transaction trans, QueryEvaluationMode mode) {
        AbstractQueryResult queryResult = this.newQueryResult(trans, mode);
        queryResult.loadFromClassIndexes(this.classCollection().iterator());
        return queryResult;
    }

    public int allocatePointerSlot() {
        int id = this.allocateSlot(8).address();
        if (!this.isValidPointer(id)) {
            return this.allocatePointerSlot();
        }
        this.writePointer(id, Slot.ZERO);
        if (DTrace.enabled) {
            DTrace.GET_POINTER_SLOT.log(id);
        }
        return id;
    }

    protected boolean isValidPointer(int id) {
        return !this._handlers.isSystemHandler(id);
    }

    public Slot allocateSlot(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException();
        }
        if (this._freespaceManager != null && this._freespaceManager.isStarted()) {
            Slot slot = this._freespaceManager.allocateSlot(length);
            if (slot != null) {
                if (DTrace.enabled) {
                    DTrace.GET_SLOT.logLength((long)slot.address(), slot.length());
                }
                return slot;
            }
            while (this.growDatabaseByConfiguredSize()) {
                slot = this._freespaceManager.allocateSlot(length);
                if (slot == null) continue;
                if (DTrace.enabled) {
                    DTrace.GET_SLOT.logLength((long)slot.address(), slot.length());
                }
                return slot;
            }
        }
        Slot appendedSlot = this.appendBytes(length);
        if (DTrace.enabled) {
            DTrace.GET_SLOT.logLength((long)appendedSlot.address(), appendedSlot.length());
        }
        return appendedSlot;
    }

    private boolean growDatabaseByConfiguredSize() {
        int reservedStorageSpace = this.configImpl().databaseGrowthSize();
        if (reservedStorageSpace <= 0) {
            return false;
        }
        int reservedBlocks = this._blockConverter.bytesToBlocks(reservedStorageSpace);
        int reservedBytes = this._blockConverter.blocksToBytes(reservedBlocks);
        Slot slot = new Slot(this._blockEndAddress, reservedBlocks);
        this.writeBytes(new ByteArrayBuffer(reservedBytes), this._blockEndAddress, 0);
        this._freespaceManager.free(this._blockConverter.toNonBlockedLength(slot));
        this._blockEndAddress += reservedBlocks;
        return true;
    }

    public final Slot appendBytes(long bytes) {
        int blockCount = this._blockConverter.bytesToBlocks(bytes);
        int blockedStartAddress = this._blockEndAddress;
        int blockedEndAddress = this._blockEndAddress + blockCount;
        this.checkBlockedAddress(blockedEndAddress);
        this._blockEndAddress = blockedEndAddress;
        Slot slot = new Slot(blockedStartAddress, blockCount);
        return this._blockConverter.toNonBlockedLength(slot);
    }

    private void checkBlockedAddress(int blockedAddress) {
        if (blockedAddress < 0) {
            this.switchToReadOnlyMode();
            throw new DatabaseMaximumSizeReachedException();
        }
    }

    private void switchToReadOnlyMode() {
        this._config.readOnly(true);
    }

    void ensureLastSlotWritten() {
        if (this._blockEndAddress > this._blockConverter.bytesToBlocks(this.fileLength())) {
            StatefulBuffer writer = this.createStatefulBuffer(this.systemTransaction(), this._blockEndAddress - 1, this.blockSize());
            writer.write();
        }
    }

    @Override
    public Db4oDatabase identity() {
        return this._systemData.identity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentity(Db4oDatabase identity) {
        Object object = this.lock();
        synchronized (object) {
            this._systemData.identity(identity);
            this._timeStampIdGenerator.generate();
            this._fileHeader.writeVariablePart(this);
        }
    }

    @Override
    boolean isServer() {
        return this.i_isServer;
    }

    @Override
    public final int idForNewUserObject(Transaction trans) {
        return trans.idSystem().newId(SlotChangeFactory.USER_OBJECTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void raiseCommitTimestamp(long minimumVersion) {
        Object object = this.lock();
        synchronized (object) {
            this._timeStampIdGenerator.setMinimumNext(minimumVersion);
        }
    }

    @Override
    public StatefulBuffer readStatefulBufferById(Transaction a_ta, int a_id) {
        return this.readStatefulBufferById(a_ta, a_id, false);
    }

    @Override
    public ByteArrayBuffer[] readSlotBuffers(Transaction transaction, int[] ids) {
        ByteArrayBuffer[] buffers = new ByteArrayBuffer[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            buffers[i] = ids[i] == 0 ? null : this.readBufferById(transaction, ids[i]);
        }
        return buffers;
    }

    @Override
    public ByteArrayBuffer readBufferById(Transaction trans, int id) {
        return this.readBufferById(trans, id, false);
    }

    @Override
    public final ByteArrayBuffer readBufferById(Transaction trans, int id, boolean lastCommitted) {
        Slot slot;
        if (id <= 0) {
            throw new IllegalArgumentException();
        }
        Slot slot2 = slot = lastCommitted ? trans.idSystem().committedSlot(id) : trans.idSystem().currentSlot(id);
        if (DTrace.enabled) {
            DTrace.SLOT_READ.logLength((long)id, slot);
        }
        return this.readBufferBySlot(slot);
    }

    @Override
    public StatefulBuffer readStatefulBufferById(Transaction trans, int id, boolean lastCommitted) {
        Slot slot;
        if (id <= 0) {
            throw new IllegalArgumentException();
        }
        Slot slot2 = slot = lastCommitted ? trans.idSystem().committedSlot(id) : trans.idSystem().currentSlot(id);
        if (DTrace.enabled) {
            DTrace.SLOT_READ.logLength((long)id, slot);
        }
        return this.readStatefulBufferBySlot(trans, id, slot);
    }

    public ByteArrayBuffer readBufferBySlot(Slot slot) {
        if (Slot.isNull(slot)) {
            return null;
        }
        if (DTrace.enabled) {
            DTrace.READ_SLOT.logLength((long)slot.address(), slot.length());
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(slot.length());
        buffer.readEncrypt(this, slot.address());
        return buffer;
    }

    public StatefulBuffer readStatefulBufferBySlot(Transaction trans, int id, Slot slot) {
        if (Slot.isNull(slot)) {
            return null;
        }
        if (DTrace.enabled) {
            DTrace.READ_SLOT.logLength((long)slot.address(), slot.length());
        }
        StatefulBuffer buffer = this.createStatefulBuffer(trans, slot.address(), slot.length());
        buffer.setID(id);
        buffer.readEncrypt(this, slot.address());
        return buffer;
    }

    @Override
    protected boolean doFinalize() {
        return this._fileHeader != null;
    }

    void readThis() throws OldFormatException {
        this.newSystemData((byte)1, (byte)0);
        this.blockSizeReadFromFile(1);
        this._fileHeader = FileHeader.read(this);
        if (this.config().generateCommitTimestamps().isUnspecified()) {
            this.config().generateCommitTimestamps(this._systemData.idToTimestampIndexId() != 0);
        }
        this.createStringIO(this._systemData.stringEncoding());
        this.createIdSystem();
        this.initializeClassMetadataRepository();
        this.initalizeWeakReferenceSupport();
        this.setNextTimeStampId(this.systemData().lastTimeStampID());
        this.classCollection().setID(this._systemData.classCollectionID());
        this.classCollection().read(this.systemTransaction());
        Converter.convert(new ConversionStage.ClassCollectionAvailableStage(this));
        this._fileHeader.readIdentity(this);
        if (this._config.isReadOnly()) {
            return;
        }
        if (!this.configImpl().commitRecoveryDisabled()) {
            this._fileHeader.completeInterruptedTransaction(this);
        }
        AbstractFreespaceManager blockedFreespaceManager = AbstractFreespaceManager.createNew(this, this._systemData.freespaceSystem());
        this.installFreespaceManager(blockedFreespaceManager);
        blockedFreespaceManager.read(this, this._systemData.inMemoryFreespaceSlot());
        blockedFreespaceManager.start(this._systemData.bTreeFreespaceId());
        this._fileHeader = this._fileHeader.convert(this);
        if (this.freespaceMigrationRequired(blockedFreespaceManager)) {
            this.migrateFreespace(blockedFreespaceManager);
        }
        this.writeHeader(true, false);
        if (Converter.convert(new ConversionStage.SystemUpStage(this))) {
            this._systemData.converterVersion(12);
            this._fileHeader.writeVariablePart(this);
            this.transaction().commit();
        }
    }

    private void installFreespaceManager(FreespaceManager blockedFreespaceManager) {
        this._freespaceManager = this.blockSize() == 1 ? blockedFreespaceManager : new BlockAwareFreespaceManager(blockedFreespaceManager, this._blockConverter);
    }

    protected void createIdSystem() {
        this._idSystem = StandardIdSystemFactory.newInstance(this);
    }

    private boolean freespaceMigrationRequired(FreespaceManager freespaceManager) {
        if (freespaceManager == null) {
            return false;
        }
        byte readSystem = this._systemData.freespaceSystem();
        byte configuredSystem = this.configImpl().freespaceSystem();
        if (freespaceManager.systemType() == configuredSystem) {
            return false;
        }
        if (configuredSystem != 0) {
            return true;
        }
        return AbstractFreespaceManager.migrationRequired(readSystem);
    }

    private void migrateFreespace(FreespaceManager oldFreespaceManager) {
        AbstractFreespaceManager newFreespaceManager = AbstractFreespaceManager.createNew(this, this.configImpl().freespaceSystem());
        newFreespaceManager.start(0);
        this.systemData().freespaceSystem(this.configImpl().freespaceSystem());
        this.installFreespaceManager(newFreespaceManager);
        AbstractFreespaceManager.migrate(oldFreespaceManager, newFreespaceManager);
        this._fileHeader.writeVariablePart(this);
    }

    @Override
    public final void releaseSemaphore(String name) {
        this.releaseSemaphore(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void releaseSemaphore(final Transaction trans, final String name) {
        Object object = this._lock;
        synchronized (object) {
            if (this._semaphores == null) {
                return;
            }
        }
        this._semaphoresLock.run(new Closure4(){

            public Object run() {
                Transaction transaction = LocalObjectContainer.this.checkTransaction(trans);
                if (LocalObjectContainer.this._semaphores != null && transaction == LocalObjectContainer.this._semaphores.get(name)) {
                    LocalObjectContainer.this._semaphores.remove(name);
                }
                LocalObjectContainer.this._semaphoresLock.awake();
                return null;
            }
        });
    }

    @Override
    public void releaseSemaphores(final Transaction trans) {
        if (this._semaphores != null) {
            final Hashtable4 semaphores = this._semaphores;
            this._semaphoresLock.run(new Closure4(){

                public Object run() {
                    semaphores.forEachKeyForIdentity(new Visitor4(){

                        public void visit(Object a_object) {
                            semaphores.remove(a_object);
                        }
                    }, trans);
                    LocalObjectContainer.this._semaphoresLock.awake();
                    return null;
                }
            });
        }
    }

    @Override
    public final void rollback1(Transaction trans) {
        trans.rollback();
    }

    @Override
    public final void setDirtyInSystemTransaction(PersistentBase a_object) {
        a_object.setStateDirty();
        a_object.cacheDirty(this._dirtyClassMetadata);
    }

    @Override
    public final boolean setSemaphore(String name, int timeout) {
        return this.setSemaphore(null, name, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setSemaphore(final Transaction trans, final String name, final int timeout) {
        if (name == null) {
            throw new NullPointerException();
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._semaphores == null) {
                this._semaphores = new Hashtable4(10);
            }
        }
        final BooleanByRef acquired = new BooleanByRef();
        this._semaphoresLock.run(new Closure4(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                try {
                    Transaction transaction = LocalObjectContainer.this.checkTransaction(trans);
                    Object candidateTransaction = LocalObjectContainer.this._semaphores.get(name);
                    if (trans == candidateTransaction) {
                        acquired.value = true;
                        Object var3_3 = null;
                        return var3_3;
                    }
                    if (candidateTransaction == null) {
                        LocalObjectContainer.this._semaphores.put(name, (Object)transaction);
                        acquired.value = true;
                        Object var3_4 = null;
                        return var3_4;
                    }
                    long endtime = System.currentTimeMillis() + (long)timeout;
                    long waitTime = timeout;
                    while (waitTime > 0L) {
                        LocalObjectContainer.this._semaphoresLock.awake();
                        LocalObjectContainer.this._semaphoresLock.snooze(waitTime);
                        if (LocalObjectContainer.this.classCollection() == null) {
                            acquired.value = false;
                            Object var7_7 = null;
                            return var7_7;
                        }
                        candidateTransaction = LocalObjectContainer.this._semaphores.get(name);
                        if (candidateTransaction == null) {
                            LocalObjectContainer.this._semaphores.put(name, (Object)transaction);
                            acquired.value = true;
                            Object var7_8 = null;
                            return var7_8;
                        }
                        waitTime = endtime - System.currentTimeMillis();
                    }
                    acquired.value = false;
                    Object var7_9 = null;
                    return var7_9;
                }
                finally {
                    LocalObjectContainer.this._semaphoresLock.awake();
                }
            }
        });
        return acquired.value;
    }

    public void setServer(boolean flag) {
        this.i_isServer = flag;
    }

    public abstract void syncFiles();

    public abstract void syncFiles(Runnable var1);

    @Override
    protected String defaultToString() {
        return this.fileName();
    }

    @Override
    public void shutdown() {
        this.writeHeader(false, true);
    }

    public final void commitTransaction() {
        this._transaction.commit();
    }

    public abstract void writeBytes(ByteArrayBuffer var1, int var2, int var3);

    @Override
    public final void writeDirtyClassMetadata() {
        this.writeCachedDirty();
    }

    private void writeCachedDirty() {
        Iterator4 i = this._dirtyClassMetadata.iterator();
        while (i.moveNext()) {
            PersistentBase dirty = (PersistentBase)i.current();
            dirty.write(this.systemTransaction());
            dirty.notCachedDirty();
        }
        this._dirtyClassMetadata.clear();
    }

    public final void writeEncrypt(ByteArrayBuffer buffer, int address, int addressOffset) {
        this._handlers.encrypt(buffer);
        this.writeBytes(buffer, address, addressOffset);
        this._handlers.decrypt(buffer);
    }

    public void writeHeader(boolean startFileLockingThread, boolean shuttingDown) {
        if (shuttingDown) {
            this._freespaceManager.write(this);
            this._freespaceManager = null;
        }
        StatefulBuffer writer = this.createStatefulBuffer(this.systemTransaction(), 0, this._fileHeader.length());
        this._fileHeader.writeFixedPart(this, startFileLockingThread, shuttingDown, writer, this.blockSize());
        if (shuttingDown) {
            this.ensureLastSlotWritten();
        }
        this.syncFiles();
    }

    @Override
    public final void writeNew(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, ByteArrayBuffer buffer) {
        this.writeEncrypt(buffer, pointer.address(), 0);
        if (classMetadata == null) {
            return;
        }
        classMetadata.addToIndex(trans, pointer.id());
    }

    public abstract void overwriteDeletedBytes(int var1, int var2);

    public void overwriteDeletedBlockedSlot(Slot slot) {
        this.overwriteDeletedBytes(slot.address(), this._blockConverter.blocksToBytes(slot.length()));
    }

    public final void writeTransactionPointer(int pointer) {
        this._fileHeader.writeTransactionPointer(this.systemTransaction(), pointer);
    }

    public final Slot allocateSlotForUserObjectUpdate(Transaction trans, int id, int length) {
        Slot slot = this.allocateSlot(length);
        trans.idSystem().notifySlotUpdated(id, slot, SlotChangeFactory.USER_OBJECTS);
        return slot;
    }

    public final Slot allocateSlotForNewUserObject(Transaction trans, int id, int length) {
        Slot slot = this.allocateSlot(length);
        trans.idSystem().notifySlotCreated(id, slot, SlotChangeFactory.USER_OBJECTS);
        return slot;
    }

    @Override
    public final void writeUpdate(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, ArrayType arrayType, ByteArrayBuffer buffer) {
        int address = pointer.address();
        if (address == 0) {
            address = this.allocateSlotForUserObjectUpdate(trans, pointer.id(), pointer.length()).address();
        }
        this.writeEncrypt(buffer, address, 0);
    }

    public void setNextTimeStampId(long val) {
        this._timeStampIdGenerator.setMinimumNext(val);
    }

    @Override
    public SystemInfo systemInfo() {
        return new SystemInfoFileImpl(this);
    }

    public FileHeader getFileHeader() {
        return this._fileHeader;
    }

    public void installDebugFreespaceManager(FreespaceManager manager) {
        this._freespaceManager = manager;
    }

    public SystemData systemData() {
        return this._systemData;
    }

    @Override
    public long[] getIDsForClass(Transaction trans, ClassMetadata clazz) {
        final IntArrayList ids = new IntArrayList();
        clazz.index().traverseAll(trans, new Visitor4(){

            public void visit(Object obj) {
                ids.add((Integer)obj);
            }
        });
        return ids.asLong();
    }

    @Override
    public QueryResult classOnlyQuery(QQueryBase query, ClassMetadata clazz) {
        if (!clazz.hasClassIndex()) {
            return new IdListQueryResult(query.transaction());
        }
        AbstractQueryResult queryResult = this.newQueryResult(query.transaction());
        queryResult.loadFromClassIndex(clazz);
        return queryResult;
    }

    @Override
    public QueryResult executeQuery(QQuery query) {
        AbstractQueryResult queryResult = this.newQueryResult(query.transaction());
        queryResult.loadFromQuery(query);
        return queryResult;
    }

    public LocalTransaction localSystemTransaction() {
        return (LocalTransaction)this.systemTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int instanceCount(ClassMetadata clazz, Transaction trans) {
        Object object = this.lock();
        synchronized (object) {
            return clazz.indexEntryCount(trans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectContainer openSession() {
        Object object = this.lock();
        synchronized (object) {
            return new ObjectContainerSession(this);
        }
    }

    @Override
    public boolean isDeleted(Transaction trans, int id) {
        return trans.idSystem().isDeleted(id);
    }

    public void writePointer(int id, Slot slot) {
        if (DTrace.enabled) {
            DTrace.WRITE_POINTER.log(id);
            DTrace.WRITE_POINTER.logLength(slot);
        }
        this._pointerIo.seek(0);
        this._pointerIo.writeInt(slot.address());
        this._pointerIo.writeInt(slot.length());
        this.writeBytes(this._pointerIo, id, 0);
    }

    public Slot debugReadPointerSlot(int id) {
        return null;
    }

    public final Slot readPointerSlot(int id) {
        if (!this.isValidId(id)) {
            throw new InvalidIDException(id);
        }
        this.readBytes(this._pointerBuffer, id, 8);
        int address = this._pointerBuffer[3] & 0xFF | (this._pointerBuffer[2] & 0xFF) << 8 | (this._pointerBuffer[1] & 0xFF) << 16 | this._pointerBuffer[0] << 24;
        int length = this._pointerBuffer[7] & 0xFF | (this._pointerBuffer[6] & 0xFF) << 8 | (this._pointerBuffer[5] & 0xFF) << 16 | this._pointerBuffer[4] << 24;
        if (!this.isValidSlot(address, length)) {
            throw new InvalidSlotException(address, length, id);
        }
        return new Slot(address, length);
    }

    private boolean isValidId(int id) {
        return this.fileLength() >= (long)id;
    }

    private boolean isValidSlot(int address, int length) {
        long fileLength = this.fileLength();
        boolean validAddress = fileLength >= (long)address;
        boolean validLength = fileLength >= (long)length;
        boolean validSlot = fileLength >= (long)(address + length);
        return validAddress && validLength && validSlot;
    }

    @Override
    protected void closeIdSystem() {
        if (this._idSystem != null) {
            this._idSystem.close();
        }
    }

    public IdSystem idSystem() {
        return this._idSystem;
    }

    public Runnable commitHook() {
        this._systemData.lastTimeStampID(this._timeStampIdGenerator.last());
        return this._fileHeader.commit(false);
    }

    public final Slot allocateSafeSlot(int length) {
        Slot reusedSlot = this.freespaceManager().allocateSafeSlot(length);
        if (reusedSlot != null) {
            return reusedSlot;
        }
        return this.appendBytes(length);
    }

    @Override
    public EventRegistryImpl newEventRegistry() {
        return new EventRegistryImpl();
    }

    public <T> QLin<T> from(Class<T> clazz) {
        return new QLinRoot<T>(this.query(), clazz);
    }
}

