/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNode;

public final class BTreePointer {
    private final BTreeNode _node;
    private final int _index;
    private final Transaction _transaction;
    private final ByteArrayBuffer _nodeReader;

    public static BTreePointer max(BTreePointer x, BTreePointer y) {
        if (x == null) {
            return x;
        }
        if (y == null) {
            return y;
        }
        if (x.compareTo(y) > 0) {
            return x;
        }
        return y;
    }

    public static BTreePointer min(BTreePointer x, BTreePointer y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (x.compareTo(y) < 0) {
            return x;
        }
        return y;
    }

    public BTreePointer(Transaction transaction, ByteArrayBuffer nodeReader, BTreeNode node, int index) {
        if (transaction == null || node == null) {
            throw new ArgumentNullException();
        }
        this._transaction = transaction;
        this._nodeReader = nodeReader;
        this._node = node;
        this._index = index;
    }

    public final int index() {
        return this._index;
    }

    public final BTreeNode node() {
        return this._node;
    }

    public final Object key() {
        return this._node.key(this._transaction, this._nodeReader, this._index);
    }

    public BTreePointer next() {
        for (int indexInMyNode = this._index + 1; indexInMyNode < this._node.count(); ++indexInMyNode) {
            if (!this._node.indexIsValid(this._transaction, indexInMyNode)) continue;
            return new BTreePointer(this._transaction, this._nodeReader, this._node, indexInMyNode);
        }
        int newIndex = -1;
        BTreeNode nextNode = this._node;
        ByteArrayBuffer nextReader = null;
        while (newIndex == -1) {
            if ((nextNode = nextNode.nextNode()) == null) {
                return null;
            }
            nextReader = nextNode.prepareRead(this._transaction);
            newIndex = nextNode.firstKeyIndex(this._transaction);
        }
        this.btree().convertCacheEvictedNodesToReadMode();
        return new BTreePointer(this._transaction, nextReader, nextNode, newIndex);
    }

    public BTreePointer previous() {
        for (int indexInMyNode = this._index - 1; indexInMyNode >= 0; --indexInMyNode) {
            if (!this._node.indexIsValid(this._transaction, indexInMyNode)) continue;
            return new BTreePointer(this._transaction, this._nodeReader, this._node, indexInMyNode);
        }
        int newIndex = -1;
        BTreeNode previousNode = this._node;
        ByteArrayBuffer previousReader = null;
        while (newIndex == -1) {
            if ((previousNode = previousNode.previousNode()) == null) {
                return null;
            }
            previousReader = previousNode.prepareRead(this._transaction);
            newIndex = previousNode.lastKeyIndex(this._transaction);
        }
        return new BTreePointer(this._transaction, previousReader, previousNode, newIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BTreePointer)) {
            return false;
        }
        BTreePointer other = (BTreePointer)obj;
        if (this._index != other._index) {
            return false;
        }
        return this._node.equals(other._node);
    }

    public int hashCode() {
        return this._node.hashCode();
    }

    public String toString() {
        return "BTreePointer(index=" + this._index + ", node=" + this._node + ")";
    }

    public int compareTo(BTreePointer y) {
        if (null == y) {
            throw new ArgumentNullException();
        }
        if (this.btree() != y.btree()) {
            throw new IllegalArgumentException();
        }
        return this.btree().compareKeys(this._transaction.context(), this.key(), y.key());
    }

    private BTree btree() {
        return this._node.btree();
    }

    public static boolean lessThan(BTreePointer x, BTreePointer y) {
        return BTreePointer.min(x, y) == x && !BTreePointer.equals(x, y);
    }

    public static boolean equals(BTreePointer x, BTreePointer y) {
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public boolean isValid() {
        return this._node.indexIsValid(this._transaction, this._index);
    }
}

