/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.freespace.BTreeFreespaceManager;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.freespace.FreespaceManagerIx;
import com.db4o.internal.freespace.InMemoryFreespaceManager;
import com.db4o.internal.slots.Slot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFreespaceManager
implements FreespaceManager {
    public static final byte FM_DEBUG = 127;
    public static final byte FM_DEFAULT = 0;
    public static final byte FM_LEGACY_RAM = 1;
    public static final byte FM_RAM = 2;
    public static final byte FM_IX = 3;
    public static final byte FM_BTREE = 4;
    private static final int INTS_IN_SLOT = 12;
    public static final int REMAINDER_SIZE_LIMIT = 20;
    protected Procedure4<Slot> _slotFreedCallback;
    private final int _discardLimit;

    public static byte checkType(byte systemType) {
        if (systemType == 0) {
            return 2;
        }
        return systemType;
    }

    public AbstractFreespaceManager(Procedure4<Slot> slotFreedCallback, int discardLimit) {
        this._slotFreedCallback = slotFreedCallback;
        this._discardLimit = discardLimit;
    }

    public static AbstractFreespaceManager createNew(LocalObjectContainer file) {
        return AbstractFreespaceManager.createNew(file, file.systemData().freespaceSystem());
    }

    public static AbstractFreespaceManager createNew(final LocalObjectContainer file, byte systemType) {
        systemType = AbstractFreespaceManager.checkType(systemType);
        int unblockedDiscardLimit = file.configImpl().discardFreeSpace();
        int blockedDiscardLimit = unblockedDiscardLimit == Integer.MAX_VALUE ? unblockedDiscardLimit : file.blockConverter().bytesToBlocks(unblockedDiscardLimit);
        Procedure4<Slot> slotFreedCallback = new Procedure4<Slot>(){

            @Override
            public void apply(Slot slot) {
                file.overwriteDeletedBlockedSlot(slot);
            }
        };
        switch (systemType) {
            case 3: {
                return new FreespaceManagerIx(blockedDiscardLimit);
            }
            case 4: {
                return new BTreeFreespaceManager(file, slotFreedCallback, blockedDiscardLimit);
            }
        }
        return new InMemoryFreespaceManager(slotFreedCallback, blockedDiscardLimit);
    }

    public static int initSlot(LocalObjectContainer file) {
        int address = file.allocateSlot(AbstractFreespaceManager.slotLength()).address();
        AbstractFreespaceManager.slotEntryToZeroes(file, address);
        return address;
    }

    @Override
    public void migrateTo(final FreespaceManager fm) {
        this.traverse(new Visitor4(){

            public void visit(Object obj) {
                fm.free((Slot)obj);
            }
        });
    }

    static void slotEntryToZeroes(LocalObjectContainer file, int address) {
        StatefulBuffer writer = new StatefulBuffer(file.systemTransaction(), address, AbstractFreespaceManager.slotLength());
        for (int i = 0; i < 12; ++i) {
            writer.writeInt(0);
        }
        writer.writeEncrypt();
    }

    static final int slotLength() {
        return 48;
    }

    @Override
    public int totalFreespace() {
        final IntByRef mint = new IntByRef();
        this.traverse(new Visitor4(){

            public void visit(Object obj) {
                Slot slot = (Slot)obj;
                mint.value += slot.length();
            }
        });
        return mint.value;
    }

    protected int discardLimit() {
        return this._discardLimit;
    }

    protected final boolean splitRemainder(int length) {
        if (this.canDiscard(length)) {
            return false;
        }
        return length > 20;
    }

    final boolean canDiscard(int length) {
        return length == 0 || length < this.discardLimit();
    }

    public static void migrate(FreespaceManager oldFM, FreespaceManager newFM) {
        oldFM.migrateTo(newFM);
        oldFM.freeSelf();
    }

    public void debugCheckIntegrity() {
        final IntByRef lastStart = new IntByRef();
        final IntByRef lastEnd = new IntByRef();
        this.traverse(new Visitor4(){

            public void visit(Object obj) {
                Slot slot = (Slot)obj;
                if (slot.address() <= lastEnd.value) {
                    throw new IllegalStateException();
                }
                lastStart.value = slot.address();
                lastEnd.value = slot.address() + slot.length();
            }
        });
    }

    public static boolean migrationRequired(byte systemType) {
        return systemType == 1 || systemType == 3;
    }

    @Override
    public void slotFreed(Slot slot) {
        if (this._slotFreedCallback == null) {
            return;
        }
        this._slotFreedCallback.apply(slot);
    }
}

