/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.slots;

import com.db4o.DTrace;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.TreeInt;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.TransactionalIdSystemImpl;
import com.db4o.internal.slots.Slot;

public class SlotChange
extends TreeInt {
    private SlotChangeOperation _firstOperation;
    private SlotChangeOperation _currentOperation;
    protected Slot _newSlot;

    public SlotChange(int id) {
        super(id);
    }

    public Object shallowClone() {
        SlotChange sc = new SlotChange(0);
        sc.newSlot(this._newSlot);
        return super.shallowCloneInternal(sc);
    }

    public void accumulateFreeSlot(TransactionalIdSystemImpl idSystem, FreespaceCommitter freespaceCommitter, boolean forFreespace) {
        if (this.forFreespace() != forFreespace) {
            return;
        }
        if (this._firstOperation == SlotChangeOperation.create) {
            return;
        }
        if (this._currentOperation == SlotChangeOperation.update || this._currentOperation == SlotChangeOperation.delete) {
            Slot slot = this.modifiedSlotInParentIdSystem(idSystem);
            if (Slot.isNull(slot)) {
                slot = idSystem.committedSlot(this._key);
            }
            if (!Slot.isNull(slot)) {
                freespaceCommitter.delayedFree(slot, this.freeToSystemFreespaceSystem());
            }
        }
    }

    protected boolean forFreespace() {
        return false;
    }

    protected Slot modifiedSlotInParentIdSystem(TransactionalIdSystemImpl idSystem) {
        return idSystem.modifiedSlotInParentIdSystem(this._key);
    }

    public boolean isDeleted() {
        return this.slotModified() && this._newSlot.isNull();
    }

    public boolean isNew() {
        return this._firstOperation == SlotChangeOperation.create;
    }

    private final boolean isFreeOnRollback() {
        return !Slot.isNull(this._newSlot);
    }

    public final boolean slotModified() {
        return this._newSlot != null;
    }

    public Slot newSlot() {
        return this._newSlot;
    }

    public Object read(ByteArrayBuffer reader) {
        SlotChange change = new SlotChange(reader.readInt());
        Slot newSlot = new Slot(reader.readInt(), reader.readInt());
        change.newSlot(newSlot);
        return change;
    }

    public void rollback(FreespaceManager freespaceManager) {
        if (this.isFreeOnRollback()) {
            freespaceManager.free(this._newSlot);
        }
    }

    public void write(ByteArrayBuffer writer) {
        if (this.slotModified()) {
            writer.writeInt(this._key);
            writer.writeInt(this._newSlot.address());
            writer.writeInt(this._newSlot.length());
        }
    }

    public final void writePointer(LocalObjectContainer container) {
        if (this.slotModified()) {
            container.writePointer(this._key, this._newSlot);
        }
    }

    private void newSlot(Slot slot) {
        this._newSlot = slot;
    }

    public void notifySlotUpdated(FreespaceManager freespaceManager, Slot slot) {
        if (DTrace.enabled) {
            DTrace.NOTIFY_SLOT_UPDATED.logLength((long)this._key, slot);
        }
        this.freePreviouslyModifiedSlot(freespaceManager);
        this._newSlot = slot;
        this.operation(SlotChangeOperation.update);
    }

    protected void freePreviouslyModifiedSlot(FreespaceManager freespaceManager) {
        if (Slot.isNull(this._newSlot)) {
            return;
        }
        this.free(freespaceManager, this._newSlot);
        this._newSlot = null;
    }

    protected void free(FreespaceManager freespaceManager, Slot slot) {
        if (slot.isNull()) {
            return;
        }
        if (freespaceManager == null) {
            return;
        }
        freespaceManager.free(slot);
    }

    private void operation(SlotChangeOperation operation) {
        if (this._firstOperation == null) {
            this._firstOperation = operation;
        }
        this._currentOperation = operation;
    }

    public void notifySlotCreated(Slot slot) {
        if (DTrace.enabled) {
            DTrace.NOTIFY_SLOT_CREATED.log(this._key);
            DTrace.NOTIFY_SLOT_CREATED.logLength(slot);
        }
        this.operation(SlotChangeOperation.create);
        this._newSlot = slot;
    }

    public void notifyDeleted(FreespaceManager freespaceManager) {
        if (DTrace.enabled) {
            DTrace.NOTIFY_SLOT_DELETED.log(this._key);
        }
        this.operation(SlotChangeOperation.delete);
        this.freePreviouslyModifiedSlot(freespaceManager);
        this._newSlot = Slot.ZERO;
    }

    public boolean removeId() {
        return false;
    }

    public String toString() {
        String str = "id: " + this._key;
        if (this._newSlot != null) {
            str = str + " newSlot: " + this._newSlot;
        }
        return str;
    }

    protected boolean freeToSystemFreespaceSystem() {
        return false;
    }

    private static class SlotChangeOperation {
        private final String _type;
        static final SlotChangeOperation create = new SlotChangeOperation("create");
        static final SlotChangeOperation update = new SlotChangeOperation("update");
        static final SlotChangeOperation delete = new SlotChangeOperation("delete");

        public SlotChangeOperation(String type) {
            this._type = type;
        }

        public String toString() {
            return this._type;
        }
    }
}

