/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.transactionlog;

import com.db4o.foundation.Visitable;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;
import com.db4o.internal.transactionlog.TransactionLogHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedTransactionLogHandler
extends TransactionLogHandler {
    public EmbeddedTransactionLogHandler(LocalObjectContainer container) {
        super(container);
    }

    @Override
    public void completeInterruptedTransaction(int transactionId1, int transactionId2) {
        if (transactionId1 <= 0 || transactionId1 != transactionId2) {
            return;
        }
        StatefulBuffer bytes = new StatefulBuffer(this._container.systemTransaction(), transactionId1, 4);
        bytes.read();
        int length = bytes.readInt();
        if (length > 0) {
            bytes = new StatefulBuffer(this._container.systemTransaction(), transactionId1, length);
            bytes.read();
            bytes.incrementOffset(4);
            this.readWriteSlotChanges(bytes);
        }
        this._container.writeTransactionPointer(0);
        this.flushDatabaseFile();
    }

    @Override
    public Slot allocateSlot(boolean appendToFile, int slotChangeCount) {
        Slot slot;
        int transactionLogByteCount = this.transactionLogSlotLength(slotChangeCount);
        FreespaceManager freespaceManager = this._container.freespaceManager();
        if (!appendToFile && freespaceManager != null && (slot = freespaceManager.allocateTransactionLogSlot(transactionLogByteCount)) != null) {
            return slot;
        }
        return this._container.appendBytes(transactionLogByteCount);
    }

    private void freeSlot(Slot slot) {
        if (slot == null) {
            return;
        }
        if (this._container.freespaceManager() == null) {
            return;
        }
        this._container.freespaceManager().freeSafeSlot(slot);
    }

    @Override
    public void applySlotChanges(Visitable<SlotChange> slotChangeTree, int slotChangeCount, Slot reservedSlot) {
        if (slotChangeCount > 0) {
            Slot transactionLogSlot = this.slotLongEnoughForLog(slotChangeCount, reservedSlot) ? reservedSlot : this.allocateSlot(true, slotChangeCount);
            StatefulBuffer buffer = new StatefulBuffer(this._container.systemTransaction(), transactionLogSlot);
            buffer.writeInt(transactionLogSlot.length());
            buffer.writeInt(slotChangeCount);
            this.appendSlotChanges(buffer, slotChangeTree);
            buffer.write();
            Runnable commitHook = this._container.commitHook();
            this.flushDatabaseFile();
            this._container.writeTransactionPointer(transactionLogSlot.address());
            this.flushDatabaseFile();
            if (this.writeSlots(slotChangeTree)) {
                this.flushDatabaseFile();
            }
            this._container.writeTransactionPointer(0);
            commitHook.run();
            this.flushDatabaseFile();
            if (transactionLogSlot != reservedSlot) {
                this.freeSlot(transactionLogSlot);
            }
        }
        this.freeSlot(reservedSlot);
    }

    private boolean slotLongEnoughForLog(int slotChangeCount, Slot slot) {
        return slot != null && slot.length() >= this.transactionLogSlotLength(slotChangeCount);
    }

    @Override
    public void close() {
    }
}

