/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data.style;

import java.io.Serializable;
import org.apache.poi.xwpf.usermodel.XWPFTable;

public class BorderStyle
implements Serializable {
    public static final BorderStyle DEFAULT = BorderStyle.builder().build();
    private static final long serialVersionUID = 1L;
    private int size;
    private String color;
    private XWPFTable.XWPFBorderType type;
    private int space = 0;

    public BorderStyle() {
    }

    private BorderStyle(Builder builder) {
        this.size = builder.size;
        this.color = builder.color;
        this.type = builder.type;
        this.space = builder.space;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public XWPFTable.XWPFBorderType getType() {
        return this.type;
    }

    public void setType(XWPFTable.XWPFBorderType type) {
        this.type = type;
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int space) {
        this.space = space;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        DEFAULT.setSize(4);
        DEFAULT.setColor("auto");
        DEFAULT.setType(XWPFTable.XWPFBorderType.SINGLE);
    }

    public static final class Builder {
        private int size;
        private String color;
        private XWPFTable.XWPFBorderType type;
        private int space;

        private Builder() {
        }

        public Builder withSize(int size) {
            this.size = size;
            return this;
        }

        public Builder withColor(String color) {
            this.color = color;
            return this;
        }

        public Builder withType(XWPFTable.XWPFBorderType type) {
            this.type = type;
            return this;
        }

        public Builder withSpace(int space) {
            this.space = space;
            return this;
        }

        public BorderStyle build() {
            return new BorderStyle(this);
        }
    }
}

