/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.util.UnitUtils;
import java.math.BigInteger;

public class Page {
    public static final Page A4_NORMAL = new Page(210, 297, new PageMargin(1440L, 1440L, 1800L, 1800L));
    public static final Page A4_NARROW = new Page(210, 297, new PageMargin(720L, 720L, 720L, 720L));
    public static final Page A4_MEDIUM = new Page(210, 297, new PageMargin(1440L, 1440L, 1080L, 1080L));
    public static final Page A4_EXTEND = new Page(210, 297, new PageMargin(1440L, 1440L, 2880L, 2880L));
    private int pageWidth;
    private int pageHeight;
    private PageMargin pageMar;

    Page(int width, int height, PageMargin pageMar) {
        this.pageWidth = width;
        this.pageHeight = height;
        this.pageMar = pageMar;
    }

    public BigInteger contentWidth() {
        int pageWidthTwips = UnitUtils.cm2Twips((double)this.pageWidth / 10.0);
        return BigInteger.valueOf(pageWidthTwips - this.pageMar.left.intValue() - this.pageMar.right.intValue());
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public PageMargin getPageMar() {
        return this.pageMar;
    }

    static class PageMargin {
        private BigInteger top;
        private BigInteger bottom;
        private BigInteger right;
        private BigInteger left;
        private BigInteger gutter = BigInteger.ZERO;

        public PageMargin(long t, long b, long r, long l) {
            this.top = BigInteger.valueOf(t);
            this.bottom = BigInteger.valueOf(b);
            this.right = BigInteger.valueOf(r);
            this.left = BigInteger.valueOf(l);
        }

        public BigInteger getTop() {
            return this.top;
        }

        public BigInteger getBottom() {
            return this.bottom;
        }

        public BigInteger getRight() {
            return this.right;
        }

        public BigInteger getLeft() {
            return this.left;
        }

        public BigInteger getGutter() {
            return this.gutter;
        }
    }
}

