/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.exception.ReflectionException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;

public class XWPFNumberingWrapper {
    private final XWPFNumbering numbering;
    private List<XWPFNum> nums;
    private List<XWPFAbstractNum> abstractNums;

    public XWPFNumberingWrapper(XWPFNumbering numbering) {
        this.numbering = numbering;
        this.nums = this.tryGetNums();
        this.abstractNums = this.tryGetAbstractNums();
    }

    private List<XWPFNum> tryGetNums() {
        try {
            Field field = XWPFNumbering.class.getDeclaredField("nums");
            field.setAccessible(true);
            return (List)field.get(this.numbering);
        }
        catch (Exception e) {
            throw new ReflectionException("nums", XWPFNumbering.class, e);
        }
    }

    private List<XWPFAbstractNum> tryGetAbstractNums() {
        try {
            Field field = XWPFNumbering.class.getDeclaredField("abstractNums");
            field.setAccessible(true);
            return (List)field.get(this.numbering);
        }
        catch (Exception e) {
            throw new ReflectionException("abstractNums", XWPFNumbering.class, e);
        }
    }

    public List<XWPFAbstractNum> getAbstractNums() {
        return this.abstractNums;
    }

    public List<XWPFNum> getNums() {
        return this.nums;
    }

    public XWPFNumbering getNumbering() {
        return this.numbering;
    }

    public int getAbstractNumsSize() {
        return this.abstractNums == null ? 0 : this.abstractNums.size();
    }

    public BigInteger getMaxIdOfAbstractNum() {
        if (this.abstractNums == null) {
            return BigInteger.ZERO;
        }
        BigInteger max = BigInteger.ZERO;
        for (XWPFAbstractNum abstractNum : this.abstractNums) {
            CTAbstractNum ctAbstractNum = abstractNum.getCTAbstractNum();
            BigInteger abstractNumId = ctAbstractNum.getAbstractNumId();
            if (null == abstractNumId || abstractNumId.compareTo(max) != 1) continue;
            max = abstractNumId;
        }
        return max;
    }

    public BigInteger getNextAbstractNumID() {
        return this.getMaxIdOfAbstractNum().add(BigInteger.valueOf(1L));
    }
}

