/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import com.diffplug.common.base.Errors;
import com.diffplug.common.collect.HashBasedTable;
import com.diffplug.common.collect.Table;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.extra.GitWorkarounds;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;

public abstract class GitRatchet<Project>
implements AutoCloseable {
    private static final int TREE = 0;
    private static final int INDEX = 1;
    private static final int WORKDIR = 2;
    Map<Project, Repository> gitRoots = new HashMap<Project, Repository>();
    Table<Repository, String, ObjectId> rootTreeShaCache = HashBasedTable.create();
    Map<Project, ObjectId> subtreeShaCache = new HashMap<Project, ObjectId>();

    public boolean isClean(Project project, ObjectId treeSha, File file) throws IOException {
        Repository repo = this.repositoryFor(project);
        String relativePath = FileSignature.pathNativeToUnix((String)repo.getWorkTree().toPath().relativize(file.toPath()).toString());
        return this.isClean(project, treeSha, relativePath);
    }

    public boolean isClean(Project project, ObjectId treeSha, String relativePathUnix) throws IOException {
        Repository repo = this.repositoryFor(project);
        DirCache dirCache = repo.readDirCache();
        try (TreeWalk treeWalk = new TreeWalk(repo);){
            boolean hasDirCache;
            treeWalk.setRecursive(true);
            treeWalk.addTree((AnyObjectId)treeSha);
            treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(dirCache));
            treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(repo));
            treeWalk.setFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)relativePathUnix), (TreeFilter)new IndexDiffFilter(1, 2)));
            if (!treeWalk.next()) {
                boolean bl = true;
                return bl;
            }
            AbstractTreeIterator treeIterator = treeWalk.getTree(0, AbstractTreeIterator.class);
            DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(1, DirCacheIterator.class);
            WorkingTreeIterator workingTreeIterator = (WorkingTreeIterator)treeWalk.getTree(2, WorkingTreeIterator.class);
            boolean hasTree = treeIterator != null;
            boolean bl = hasDirCache = dirCacheIterator != null;
            if (!hasTree) {
                boolean bl2 = false;
                return bl2;
            }
            if (hasDirCache) {
                boolean indexEqualsWC;
                boolean treeEqualsIndex = treeIterator.idEqual((AbstractTreeIterator)dirCacheIterator) && treeIterator.getEntryRawMode() == dirCacheIterator.getEntryRawMode();
                boolean bl3 = indexEqualsWC = !workingTreeIterator.isModified(dirCacheIterator.getDirCacheEntry(), true, treeWalk.getObjectReader());
                if (treeEqualsIndex != indexEqualsWC) {
                    boolean bl4 = false;
                    return bl4;
                }
                if (treeEqualsIndex) {
                    throw new IllegalStateException("Index status for " + relativePathUnix + " against treeSha " + treeSha + " is invalid.");
                }
                boolean bl5 = GitRatchet.worktreeIsCleanCheckout(treeWalk);
                return bl5;
            }
            boolean bl6 = GitRatchet.worktreeIsCleanCheckout(treeWalk);
            return bl6;
        }
    }

    private static boolean worktreeIsCleanCheckout(TreeWalk treeWalk) {
        return treeWalk.idEqual(0, 2);
    }

    protected Repository repositoryFor(Project project) throws IOException {
        Repository repo = this.gitRoots.get(project);
        if (repo == null) {
            if (GitRatchet.isGitRoot(this.getDir(project))) {
                repo = GitRatchet.createRepo(this.getDir(project));
            } else {
                Project parentProj = this.getParent(project);
                if (parentProj == null) {
                    repo = GitRatchet.traverseParentsUntil(this.getDir(project).getParentFile(), null);
                    if (repo == null) {
                        throw new IllegalArgumentException("Cannot find git repository in any parent directory");
                    }
                } else {
                    repo = GitRatchet.traverseParentsUntil(this.getDir(project).getParentFile(), this.getDir(parentProj));
                    if (repo == null) {
                        repo = this.repositoryFor(parentProj);
                    }
                }
            }
            this.gitRoots.put(project, repo);
        }
        return repo;
    }

    protected abstract File getDir(Project var1);

    @Nullable
    protected abstract Project getParent(Project var1);

    @Nullable
    private static Repository traverseParentsUntil(File startWith, File file) throws IOException {
        while (startWith != null && !Objects.equals(startWith, file)) {
            if (GitRatchet.isGitRoot(startWith)) {
                return GitRatchet.createRepo(startWith);
            }
            startWith = startWith.getParentFile();
        }
        return null;
    }

    private static boolean isGitRoot(File dir) {
        File dotGit = GitWorkarounds.getDotGitDir(dir);
        return dotGit != null && RepositoryCache.FileKey.isGitRepository((File)dotGit, (FS)FS.DETECTED);
    }

    static Repository createRepo(File dir) throws IOException {
        return FileRepositoryBuilder.create((File)GitWorkarounds.getDotGitDir(dir));
    }

    public synchronized ObjectId rootTreeShaOf(Project project, String reference) {
        try {
            Repository repo = this.repositoryFor(project);
            ObjectId treeSha = (ObjectId)this.rootTreeShaCache.get((Object)repo, (Object)reference);
            if (treeSha == null) {
                try (RevWalk revWalk = new RevWalk(repo);){
                    ObjectId commitSha = repo.resolve(reference);
                    if (commitSha == null) {
                        throw new IllegalArgumentException("No such reference '" + reference + "'");
                    }
                    RevCommit ratchetFrom = revWalk.parseCommit((AnyObjectId)commitSha);
                    RevCommit head = revWalk.parseCommit((AnyObjectId)repo.resolve("HEAD"));
                    revWalk.setRevFilter(RevFilter.MERGE_BASE);
                    revWalk.markStart(ratchetFrom);
                    revWalk.markStart(head);
                    RevCommit mergeBase = revWalk.next();
                    treeSha = Optional.ofNullable(mergeBase).orElse(ratchetFrom).getTree();
                }
                this.rootTreeShaCache.put((Object)repo, (Object)reference, (Object)treeSha);
            }
            return treeSha;
        }
        catch (IOException e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }

    public synchronized ObjectId subtreeShaOf(Project project, ObjectId rootTreeSha) {
        try {
            ObjectId subtreeSha = this.subtreeShaCache.get(project);
            if (subtreeSha == null) {
                Repository repo = this.repositoryFor(project);
                File directory = this.getDir(project);
                if (repo.getWorkTree().equals(directory)) {
                    subtreeSha = rootTreeSha;
                } else {
                    String subpath = FileSignature.pathNativeToUnix((String)repo.getWorkTree().toPath().relativize(directory.toPath()).toString());
                    TreeWalk treeWalk = TreeWalk.forPath((Repository)repo, (String)subpath, (AnyObjectId[])new AnyObjectId[]{rootTreeSha});
                    subtreeSha = treeWalk == null ? ObjectId.zeroId() : treeWalk.getObjectId(0);
                }
                this.subtreeShaCache.put(project, subtreeSha);
            }
            return subtreeSha;
        }
        catch (IOException e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }

    @Override
    public void close() {
        this.gitRoots.values().stream().distinct().forEach(Repository::close);
    }
}

