/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SpotlessCache;
import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class JarState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<String> mavenCoordinates;
    private final FileSignature fileSignature;

    private JarState(Collection<String> mavenCoordinates, FileSignature fileSignature) {
        this.mavenCoordinates = new TreeSet<String>(mavenCoordinates);
        this.fileSignature = fileSignature;
    }

    public static JarState from(String mavenCoordinate, Provisioner provisioner) throws IOException {
        return JarState.from(Collections.singletonList(mavenCoordinate), provisioner);
    }

    public static JarState from(Collection<String> mavenCoordinates, Provisioner provisioner) throws IOException {
        return JarState.provisionWithTransitives(true, mavenCoordinates, provisioner);
    }

    public static JarState withoutTransitives(Collection<String> mavenCoordinates, Provisioner provisioner) throws IOException {
        return JarState.provisionWithTransitives(false, mavenCoordinates, provisioner);
    }

    private static JarState provisionWithTransitives(boolean withTransitives, Collection<String> mavenCoordinates, Provisioner provisioner) throws IOException {
        Objects.requireNonNull(mavenCoordinates, "mavenCoordinates");
        Objects.requireNonNull(provisioner, "provisioner");
        Set<File> jars = provisioner.provisionWithTransitives(withTransitives, mavenCoordinates);
        if (jars.isEmpty()) {
            throw new NoSuchElementException("Resolved to an empty result: " + mavenCoordinates.stream().collect(Collectors.joining(", ")));
        }
        FileSignature fileSignature = FileSignature.signAsSet(jars);
        return new JarState(mavenCoordinates, fileSignature);
    }

    URL[] jarUrls() {
        return (URL[])this.fileSignature.files().stream().map(File::toURI).map(ThrowingEx.wrap(URI::toURL)).toArray(URL[]::new);
    }

    public ClassLoader getClassLoader() {
        return SpotlessCache.instance().classloader(this);
    }

    public ClassLoader getClassLoader(Serializable key) {
        return SpotlessCache.instance().classloader(key, this);
    }

    public Set<String> getMavenCoordinates() {
        return Collections.unmodifiableSet(this.mavenCoordinates);
    }
}

