/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.markdown;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class FlexmarkStep {
    private static final String DEFAULT_VERSION = "0.62.2";
    private static final String NAME = "flexmark-java";
    private static final String MAVEN_COORDINATE = "com.vladsch.flexmark:flexmark-all:";

    private FlexmarkStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return FlexmarkStep.create(FlexmarkStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(JarState.from(MAVEN_COORDINATE + version, provisioner)), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;

        State(JarState jarState) {
            this.jarState = jarState;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.markdown.FlexmarkFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(new Class[0]);
            return (FormatterFunc)constructor.newInstance(new Object[0]);
        }
    }
}

