/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.gherkin;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.gherkin.GherkinUtilsConfig;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class GherkinUtilsStep {
    private static final String MAVEN_COORDINATE = "io.cucumber:gherkin-utils:";
    private static final String DEFAULT_VERSION = "8.0.2";

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static FormatterStep create(GherkinUtilsConfig gherkinSimpleConfig, String formatterVersion, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.createLazy("gherkin", () -> new State(gherkinSimpleConfig, formatterVersion, provisioner), State::toFormatter);
    }

    private GherkinUtilsStep() {
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final GherkinUtilsConfig gherkinSimpleConfig;
        private final JarState jarState;

        private State(GherkinUtilsConfig gherkinSimpleConfig, String formatterVersion, Provisioner provisioner) throws IOException {
            this.gherkinSimpleConfig = gherkinSimpleConfig;
            this.jarState = JarState.from(GherkinUtilsStep.MAVEN_COORDINATE + formatterVersion, provisioner);
        }

        FormatterFunc toFormatter() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.gherkin.GherkinUtilsFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(GherkinUtilsConfig.class);
            return (FormatterFunc)constructor.newInstance(this.gherkinSimpleConfig);
        }
    }
}

