/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.biome;

import java.util.Locale;

enum OS {
    LINUX,
    MAC_OS,
    WINDOWS;


    public static OS guess() {
        String osName = System.getProperty("os.name");
        if (osName == null || osName.isBlank()) {
            throw new IllegalStateException("No OS information is available, specify the Biome executable manually");
        }
        String osNameUpper = osName.toUpperCase(Locale.ROOT);
        if (osNameUpper.contains("SUNOS") || osName.contains("AIX")) {
            throw new IllegalStateException("Unsupported OS " + osName + ", specify the path to the Biome executable manually");
        }
        if (osNameUpper.contains("WINDOWS")) {
            return WINDOWS;
        }
        if (osNameUpper.contains("MAC")) {
            return MAC_OS;
        }
        return LINUX;
    }
}

