/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.json;

import com.diffplug.spotless.glue.json.AJacksonFormatterFunc;
import com.diffplug.spotless.json.JacksonJsonConfig;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.util.Collection;
import java.util.Map;

public class JacksonJsonFormatterFunc
extends AJacksonFormatterFunc {
    private JacksonJsonConfig jacksonConfig;

    public JacksonJsonFormatterFunc(JacksonJsonConfig jacksonConfig) {
        super(jacksonConfig);
        this.jacksonConfig = jacksonConfig;
    }

    @Override
    protected Class<?> inferType(String input) {
        if (input.trim().startsWith("[")) {
            return Collection.class;
        }
        return Map.class;
    }

    @Override
    protected JsonFactory makeJsonFactory() {
        JsonFactory jsonFactory = new JsonFactoryBuilder().build();
        this.jacksonConfig.getJsonFeatureToToggle().forEach((rawFeature, toggle) -> {
            JsonGenerator.Feature feature = JsonGenerator.Feature.valueOf((String)rawFeature);
            jsonFactory.configure(feature, toggle.booleanValue());
        });
        return jsonFactory;
    }

    protected DefaultPrettyPrinter makePrettyPrinter() {
        boolean spaceBeforeSeparator = this.jacksonConfig.isSpaceBeforeSeparator();
        DefaultIndenter indenter = new DefaultIndenter("  ", "\n");
        SpotlessJsonPrettyPrinter printer = new SpotlessJsonPrettyPrinter(spaceBeforeSeparator);
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        return printer;
    }

    protected static class SpotlessJsonPrettyPrinter
    extends DefaultPrettyPrinter {
        private static final long serialVersionUID = 1L;
        private final boolean spaceBeforeSeparator;

        public SpotlessJsonPrettyPrinter(boolean spaceBeforeSeparator) {
            this.spaceBeforeSeparator = spaceBeforeSeparator;
            if (this._objectFieldValueSeparatorWithSpaces == null || this._objectFieldValueSeparatorWithSpaces.isEmpty()) {
                return;
            }
            boolean startsWithSpace = Character.isWhitespace(this._objectFieldValueSeparatorWithSpaces.charAt(0));
            if (spaceBeforeSeparator && !startsWithSpace) {
                this._objectFieldValueSeparatorWithSpaces = String.format(" %s", this._objectFieldValueSeparatorWithSpaces);
            } else if (!spaceBeforeSeparator && startsWithSpace) {
                this._objectFieldValueSeparatorWithSpaces = this._objectFieldValueSeparatorWithSpaces.substring(1);
            }
        }

        public DefaultPrettyPrinter createInstance() {
            return new SpotlessJsonPrettyPrinter(this.spaceBeforeSeparator);
        }
    }
}

