/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.npm;

import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import com.diffplug.spotless.npm.NpmPathResolver;
import java.io.File;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractNpmFormatterStepFactory
implements FormatterStepFactory {
    @Parameter
    private String npmExecutable;
    @Parameter
    private String nodeExecutable;
    @Parameter
    private String npmrc;

    protected File npm(FormatterStepConfig stepConfig) {
        File npm = this.npmExecutable != null ? stepConfig.getFileLocator().locateFile(this.npmExecutable) : null;
        return npm;
    }

    protected File node(FormatterStepConfig stepConfig) {
        File node = this.nodeExecutable != null ? stepConfig.getFileLocator().locateFile(this.nodeExecutable) : null;
        return node;
    }

    protected File npmrc(FormatterStepConfig stepConfig) {
        File npmrc = this.npmrc != null ? stepConfig.getFileLocator().locateFile(this.npmrc) : null;
        return npmrc;
    }

    protected File buildDir(FormatterStepConfig stepConfig) {
        return stepConfig.getFileLocator().getBuildDir();
    }

    protected File baseDir(FormatterStepConfig stepConfig) {
        return stepConfig.getFileLocator().getBaseDir();
    }

    protected NpmPathResolver npmPathResolver(FormatterStepConfig stepConfig) {
        return new NpmPathResolver(this.npm(stepConfig), this.node(stepConfig), this.npmrc(stepConfig), Collections.singletonList(this.baseDir(stepConfig)));
    }

    protected boolean moreThanOneNonNull(Object ... objects) {
        return Arrays.stream(objects).filter(Objects::nonNull).filter(o -> !(o instanceof String) || !((String)o).isEmpty()).count() > 1L;
    }

    protected Map<String, String> propertiesAsMap(Properties devDependencyProperties) {
        return devDependencyProperties.stringPropertyNames().stream().map(name -> new AbstractMap.SimpleEntry<String, String>((String)name, devDependencyProperties.getProperty((String)name))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

