/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatExceptionPolicyStrict;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.cpp.ClangFormatStep;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import com.diffplug.spotless.extra.wtp.EclipseWtpFormatterStep;
import com.diffplug.spotless.generic.EndWithNewlineStep;
import com.diffplug.spotless.generic.IndentStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.generic.PipeStepPair;
import com.diffplug.spotless.generic.ReplaceRegexStep;
import com.diffplug.spotless.generic.ReplaceStep;
import com.diffplug.spotless.generic.TrimTrailingWhitespaceStep;
import com.diffplug.spotless.npm.NpmPathResolver;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import groovy.lang.Closure;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;

public class FormatExtension {
    final SpotlessExtension spotless;
    final List<Action<FormatExtension>> lazyActions = new ArrayList<Action<FormatExtension>>();
    LineEnding lineEndings;
    Charset encoding;
    private static final String RATCHETFROM_NOT_SET_AT_FORMAT_LEVEL = " not set at format level ";
    private String ratchetFrom = " not set at format level ";
    final FormatExceptionPolicyStrict exceptionPolicy = new FormatExceptionPolicyStrict();
    protected FileCollection target;
    protected FileCollection targetExclude;
    protected final List<FormatterStep> steps = new ArrayList<FormatterStep>();
    private Serializable globalState = new NeverUpToDateBetweenRuns();
    @Nullable
    private PipeStepPair togglePair;

    @Inject
    public FormatExtension(SpotlessExtension spotless) {
        this.spotless = Objects.requireNonNull(spotless);
    }

    protected final Provisioner provisioner() {
        return this.spotless.getRegisterDependenciesTask().rootProvisioner;
    }

    private String formatName() {
        for (Map.Entry<String, FormatExtension> entry : this.spotless.formats.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("This format is not contained by any SpotlessExtension.");
    }

    public LineEnding getLineEndings() {
        return this.lineEndings == null ? this.spotless.getLineEndings() : this.lineEndings;
    }

    public void setLineEndings(LineEnding lineEndings) {
        this.lineEndings = Objects.requireNonNull(lineEndings);
    }

    public Charset getEncoding() {
        return this.encoding == null ? this.spotless.getEncoding() : this.encoding;
    }

    public void setEncoding(String name) {
        this.setEncoding(Charset.forName(Objects.requireNonNull(name)));
    }

    public String getRatchetFrom() {
        return this.ratchetFrom == RATCHETFROM_NOT_SET_AT_FORMAT_LEVEL ? this.spotless.getRatchetFrom() : this.ratchetFrom;
    }

    public void setRatchetFrom(String ratchetFrom) {
        this.ratchetFrom = ratchetFrom;
    }

    public void ratchetFrom(String ratchetFrom) {
        this.setRatchetFrom(ratchetFrom);
    }

    public void setEncoding(Charset charset) {
        this.encoding = Objects.requireNonNull(charset);
    }

    public void ignoreErrorForStep(String stepName) {
        this.exceptionPolicy.excludeStep(Objects.requireNonNull(stepName));
    }

    public void ignoreErrorForPath(String relativePath) {
        this.exceptionPolicy.excludePath(Objects.requireNonNull(relativePath));
    }

    public void encoding(String charset) {
        this.setEncoding(charset);
    }

    public void target(Object ... targets) {
        this.target = this.parseTargetsIsExclude(targets, false);
    }

    public void targetExclude(Object ... targets) {
        this.targetExclude = this.parseTargetsIsExclude(targets, true);
    }

    private FileCollection parseTargetsIsExclude(Object[] targets, boolean isExclude) {
        PluginGradlePreconditions.requireElementsNonNull(targets);
        if (targets.length == 0) {
            return this.getProject().files(new Object[0]);
        }
        if (targets.length == 1) {
            return this.parseTargetIsExclude(targets[0], isExclude);
        }
        ConfigurableFileCollection union = this.getProject().files(new Object[0]);
        for (Object target : targets) {
            union = union.plus(this.parseTargetIsExclude(target, isExclude));
        }
        return union;
    }

    protected final FileCollection parseTarget(Object target) {
        return this.parseTargetIsExclude(target, false);
    }

    private final FileCollection parseTargetIsExclude(Object target, boolean isExclude) {
        if (target instanceof Collection) {
            return this.parseTargetsIsExclude(((Collection)target).toArray(), isExclude);
        }
        if (target instanceof FileCollection) {
            return (FileCollection)target;
        }
        if (target instanceof String) {
            File dir = this.getProject().getProjectDir();
            ConfigurableFileTree matchedFiles = this.getProject().fileTree((Object)dir);
            String targetString = (String)target;
            matchedFiles.include(new String[]{targetString});
            if (isExclude) {
                return matchedFiles;
            }
            if (targetString.startsWith("**/") || targetString.startsWith("**\\")) {
                ArrayList<String> excludes = new ArrayList<String>();
                excludes.add(".git");
                if (this.getProject() == this.getProject().getRootProject()) {
                    excludes.add(".gradle");
                }
                FormatExtension.relativizeIfSubdir(excludes, dir, this.getProject().getBuildDir());
                for (Project subproject : this.getProject().getSubprojects()) {
                    FormatExtension.relativizeIfSubdir(excludes, dir, subproject.getBuildDir());
                }
                matchedFiles.exclude(excludes);
            }
            return matchedFiles;
        }
        return this.getProject().files(new Object[]{target});
    }

    private static void relativizeIfSubdir(List<String> relativePaths, File root, File dest) {
        String relativized = FormatExtension.relativize(root, dest);
        if (relativized != null) {
            relativePaths.add(relativized);
        }
    }

    @Nullable
    static String relativize(File root, File dest) {
        String rootPath = root.getAbsolutePath();
        String destPath = dest.getAbsolutePath();
        if (!destPath.startsWith(rootPath)) {
            return null;
        }
        return destPath.substring(rootPath.length());
    }

    public void addStep(FormatterStep newStep) {
        Objects.requireNonNull(newStep);
        int existingIdx = this.getExistingStepIdx(newStep.getName());
        if (existingIdx != -1) {
            throw new GradleException("Multiple steps with name '" + newStep.getName() + "' for spotless format '" + this.formatName() + "'");
        }
        this.steps.add(newStep);
    }

    protected int getExistingStepIdx(String stepName) {
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!this.steps.get(i).getName().equals(stepName)) continue;
            return i;
        }
        return -1;
    }

    protected void replaceStep(FormatterStep replacementStep) {
        int existingIdx = this.getExistingStepIdx(replacementStep.getName());
        if (existingIdx == -1) {
            throw new GradleException("Cannot replace step '" + replacementStep.getName() + "' for spotless format '" + this.formatName() + "' because it hasn't been added yet.");
        }
        this.steps.set(existingIdx, replacementStep);
    }

    public void clearSteps() {
        this.steps.clear();
    }

    public void bumpThisNumberIfACustomStepChanges(int number) {
        this.globalState = Integer.valueOf(number);
    }

    public void custom(String name, Closure<String> formatter) {
        Objects.requireNonNull(formatter, "formatter");
        this.custom(name, arg_0 -> formatter.call(arg_0));
    }

    public void custom(String name, FormatterFunc formatter) {
        Objects.requireNonNull(formatter, "formatter");
        this.addStep(FormatterStep.createLazy((String)name, () -> this.globalState, unusedState -> formatter));
    }

    public void replace(String name, CharSequence original, CharSequence after) {
        this.addStep(ReplaceStep.create((String)name, (CharSequence)original, (CharSequence)after));
    }

    public void replaceRegex(String name, String regex, String replacement) {
        this.addStep(ReplaceRegexStep.create((String)name, (String)regex, (String)replacement));
    }

    public void trimTrailingWhitespace() {
        this.addStep(TrimTrailingWhitespaceStep.create());
    }

    public void endWithNewline() {
        this.addStep(EndWithNewlineStep.create());
    }

    public void indentWithSpaces(int numSpacesPerTab) {
        this.addStep(IndentStep.Type.SPACE.create(numSpacesPerTab));
    }

    public void indentWithSpaces() {
        this.addStep(IndentStep.Type.SPACE.create());
    }

    public void indentWithTabs(int tabToSpaces) {
        this.addStep(IndentStep.Type.TAB.create(tabToSpaces));
    }

    public void indentWithTabs() {
        this.addStep(IndentStep.Type.TAB.create());
    }

    public LicenseHeaderConfig licenseHeader(String licenseHeader, String delimiter) {
        LicenseHeaderConfig config = new LicenseHeaderConfig(LicenseHeaderStep.headerDelimiter((String)licenseHeader, (String)delimiter));
        this.addStep(config.createStep());
        return config;
    }

    public LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile, String delimiter) {
        LicenseHeaderConfig config = new LicenseHeaderConfig(LicenseHeaderStep.headerDelimiter(() -> {
            File file = this.getProject().file(licenseHeaderFile);
            byte[] data = Files.readAllBytes(file.toPath());
            return new String(data, this.getEncoding());
        }, (String)delimiter));
        this.addStep(config.createStep());
        return config;
    }

    public PrettierConfig prettier() {
        return this.prettier(PrettierFormatterStep.defaultDevDependencies());
    }

    public PrettierConfig prettier(String version) {
        return this.prettier(PrettierFormatterStep.defaultDevDependenciesWithPrettier((String)version));
    }

    public PrettierConfig prettier(Map<String, String> devDependencies) {
        PrettierConfig prettierConfig = new PrettierConfig(devDependencies);
        this.addStep(prettierConfig.createStep());
        return prettierConfig;
    }

    public ClangFormatConfig clangFormat() {
        return this.clangFormat(ClangFormatStep.defaultVersion());
    }

    public ClangFormatConfig clangFormat(String version) {
        return new ClangFormatConfig(version);
    }

    public EclipseWtpConfig eclipseWtp(EclipseWtpFormatterStep type) {
        return this.eclipseWtp(type, EclipseWtpFormatterStep.defaultVersion());
    }

    public EclipseWtpConfig eclipseWtp(EclipseWtpFormatterStep type, String version) {
        return new EclipseWtpConfig(type, version);
    }

    public void withinBlocks(String name, String open, String close, Action<FormatExtension> configure) {
        this.withinBlocks(name, open, close, FormatExtension.class, configure);
    }

    public <T extends FormatExtension> void withinBlocks(String name, String open, String close, Class<T> clazz, Action<T> configure) {
        this.withinBlocksHelper(PipeStepPair.named((String)name).openClose(open, close), clazz, configure);
    }

    public void withinBlocksRegex(String name, String regex, Action<FormatExtension> configure) {
        this.withinBlocksRegex(name, regex, FormatExtension.class, configure);
    }

    public <T extends FormatExtension> void withinBlocksRegex(String name, String regex, Class<T> clazz, Action<T> configure) {
        this.withinBlocksHelper(PipeStepPair.named((String)name).regex(regex), clazz, configure);
    }

    private <T extends FormatExtension> void withinBlocksHelper(PipeStepPair.Builder builder, Class<T> clazz, Action<T> configure) {
        T formatExtension = this.spotless.instantiateFormatExtension(clazz);
        configure.execute(formatExtension);
        FormatterStep step = builder.buildStepWhichAppliesSubSteps(this.spotless.project.getRootDir().toPath(), ((FormatExtension)formatExtension).steps);
        this.addStep(step);
    }

    public void toggleOffOnRegex(String regex) {
        this.togglePair = PipeStepPair.named((String)PipeStepPair.defaultToggleName()).regex(regex).buildPair();
    }

    public void toggleOffOn(String off, String on) {
        this.togglePair = PipeStepPair.named((String)PipeStepPair.defaultToggleName()).openClose(off, on).buildPair();
    }

    public void toggleOffOn() {
        this.toggleOffOn(PipeStepPair.defaultToggleOff(), PipeStepPair.defaultToggleOn());
    }

    public void toggleOffOnDisable() {
        this.togglePair = null;
    }

    protected void setupTask(SpotlessTask task) {
        List<FormatterStep> steps;
        task.setEncoding(this.getEncoding().name());
        task.setExceptionPolicy((FormatExceptionPolicy)this.exceptionPolicy);
        FileCollection totalTarget = this.targetExclude == null ? this.target : this.target.minus(this.targetExclude);
        task.setTarget((Iterable<File>)totalTarget);
        if (this.togglePair != null) {
            steps = new ArrayList<FormatterStep>(this.steps.size() + 2);
            steps.add(this.togglePair.in());
            steps.addAll(this.steps);
            steps.add(this.togglePair.out());
        } else {
            steps = this.steps;
        }
        task.setSteps(steps);
        task.setLineEndingsPolicy(this.getLineEndings().createPolicy(this.getProject().getProjectDir(), () -> totalTarget));
        if (this.spotless.project != this.spotless.project.getRootProject()) {
            this.spotless.getRegisterDependenciesTask().hookSubprojectTask(task);
        }
        if (this.getRatchetFrom() != null) {
            task.setupRatchet(this.spotless.getRegisterDependenciesTask().gitRatchet, this.getRatchetFrom());
        }
    }

    protected Project getProject() {
        return this.spotless.project;
    }

    public SpotlessApply createIndependentApplyTask(String taskName) {
        SpotlessTask spotlessTask = (SpotlessTask)this.spotless.project.getTasks().create(taskName + "Helper", SpotlessTaskImpl.class);
        this.setupTask(spotlessTask);
        Task clean = this.spotless.project.getTasks().getByName("clean");
        spotlessTask.mustRunAfter(new Object[]{clean});
        SpotlessApply applyTask = (SpotlessApply)this.spotless.project.getTasks().create(taskName, SpotlessApply.class);
        applyTask.setSpotlessOutDirectory(spotlessTask.getOutputDirectory());
        applyTask.linkSource(spotlessTask);
        applyTask.dependsOn(new Object[]{spotlessTask});
        return applyTask;
    }

    protected GradleException noDefaultTargetException() {
        return new GradleException("Spotless failure, no target set!  You must set a target for " + this.formatName());
    }

    public class EclipseWtpConfig {
        private final EclipseBasedStepBuilder builder;

        EclipseWtpConfig(EclipseWtpFormatterStep type, String version) {
            this.builder = type.createBuilder(FormatExtension.this.provisioner());
            this.builder.setVersion(version);
            FormatExtension.this.addStep(this.builder.build());
        }

        public void configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = FormatExtension.this.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            FormatExtension.this.replaceStep(this.builder.build());
        }
    }

    public class ClangFormatConfig {
        ClangFormatStep stepCfg;

        ClangFormatConfig(String version) {
            this.stepCfg = ClangFormatStep.withVersion((String)version);
            FormatExtension.this.addStep(this.createStep());
        }

        public ClangFormatConfig style(String style) {
            this.stepCfg = this.stepCfg.withStyle(style);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public ClangFormatConfig pathToExe(String pathToBlack) {
            this.stepCfg = this.stepCfg.withPathToExe(pathToBlack);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return this.stepCfg.create();
        }
    }

    public class PrettierConfig
    extends NpmStepConfig<PrettierConfig> {
        @Nullable
        Object prettierConfigFile;
        @Nullable
        Map<String, Object> prettierConfig;
        final Map<String, String> devDependencies;

        PrettierConfig(Map<String, String> devDependencies) {
            this.devDependencies = Objects.requireNonNull(devDependencies);
        }

        public PrettierConfig configFile(Object prettierConfigFile) {
            this.prettierConfigFile = prettierConfigFile;
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public PrettierConfig config(Map<String, Object> prettierConfig) {
            this.prettierConfig = new TreeMap<String, Object>(prettierConfig);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        @Override
        FormatterStep createStep() {
            Project project = FormatExtension.this.getProject();
            return PrettierFormatterStep.create(this.devDependencies, (Provisioner)FormatExtension.this.provisioner(), (File)project.getBuildDir(), (NpmPathResolver)new NpmPathResolver(this.npmFileOrNull(), this.npmrcFileOrNull(), new File[]{project.getProjectDir(), project.getRootDir()}), (com.diffplug.spotless.npm.PrettierConfig)new com.diffplug.spotless.npm.PrettierConfig(this.prettierConfigFile != null ? project.file(this.prettierConfigFile) : null, this.prettierConfig));
        }
    }

    public abstract class NpmStepConfig<T extends NpmStepConfig<?>> {
        @Nullable
        protected Object npmFile;
        @Nullable
        protected Object npmrcFile;

        public T npmExecutable(Object npmFile) {
            this.npmFile = npmFile;
            FormatExtension.this.replaceStep(this.createStep());
            return (T)this;
        }

        public T npmrc(Object npmrcFile) {
            this.npmrcFile = npmrcFile;
            FormatExtension.this.replaceStep(this.createStep());
            return (T)this;
        }

        File npmFileOrNull() {
            return this.fileOrNull(this.npmFile);
        }

        File npmrcFileOrNull() {
            return this.fileOrNull(this.npmrcFile);
        }

        private File fileOrNull(Object npmFile) {
            return npmFile != null ? FormatExtension.this.getProject().file(npmFile) : null;
        }

        abstract FormatterStep createStep();
    }

    public class LicenseHeaderConfig {
        LicenseHeaderStep builder;
        Boolean updateYearWithLatest = null;

        public LicenseHeaderConfig(LicenseHeaderStep builder) {
            this.builder = builder;
        }

        public LicenseHeaderConfig delimiter(String delimiter) {
            this.builder = this.builder.withDelimiter(delimiter);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public LicenseHeaderConfig yearSeparator(String yearSeparator) {
            this.builder = this.builder.withYearSeparator(yearSeparator);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public LicenseHeaderConfig updateYearWithLatest(boolean updateYearWithLatest) {
            this.updateYearWithLatest = updateYearWithLatest;
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        FormatterStep createStep() {
            return this.builder.withYearModeLazy(() -> {
                if ("true".equals(FormatExtension.this.spotless.project.findProperty(LicenseHeaderStep.FLAG_SET_LICENSE_HEADER_YEARS_FROM_GIT_HISTORY()))) {
                    return LicenseHeaderStep.YearMode.SET_FROM_GIT;
                }
                boolean updateYear = this.updateYearWithLatest == null ? FormatExtension.this.getRatchetFrom() != null : this.updateYearWithLatest;
                return updateYear ? LicenseHeaderStep.YearMode.UPDATE_TO_TODAY : LicenseHeaderStep.YearMode.PRESERVE;
            }).build();
        }
    }

    static class NeverUpToDateBetweenRuns
    extends LazyForwardingEquality<Integer> {
        private static final long serialVersionUID = 1L;
        private static final Random RANDOM = new Random();

        NeverUpToDateBetweenRuns() {
        }

        protected Integer calculateState() throws Exception {
            return RANDOM.nextInt();
        }
    }
}

