/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.IdeHook;
import com.diffplug.gradle.spotless.RegisterDependenciesTask;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.gradle.spotless.SpotlessCheck;
import com.diffplug.gradle.spotless.SpotlessDiagnoseTask;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessPlugin;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class SpotlessExtensionImpl
extends SpotlessExtension {
    private final TaskProvider<RegisterDependenciesTask> registerDependenciesTask;
    final TaskProvider<?> rootCheckTask;
    final TaskProvider<?> rootApplyTask;
    final TaskProvider<?> rootDiagnoseTask;

    public SpotlessExtensionImpl(Project project) {
        super(project);
        this.rootCheckTask = project.getTasks().register("spotlessCheck", task -> {
            task.setGroup("Verification");
            task.setDescription("Checks that sourcecode satisfies formatting steps.");
        });
        this.rootApplyTask = project.getTasks().register("spotlessApply", task -> {
            task.setGroup("Verification");
            task.setDescription("Applies code formatting steps to sourcecode in-place.");
        });
        this.rootDiagnoseTask = project.getTasks().register("spotlessDiagnose", task -> task.setGroup("Verification"));
        TaskContainer rootProjectTasks = project.getRootProject().getTasks();
        this.registerDependenciesTask = !rootProjectTasks.getNames().contains("spotlessInternalRegisterDependencies") ? rootProjectTasks.register("spotlessInternalRegisterDependencies", RegisterDependenciesTask.class, RegisterDependenciesTask::setup) : rootProjectTasks.named("spotlessInternalRegisterDependencies", RegisterDependenciesTask.class);
        project.afterEvaluate(unused -> {
            if (this.enforceCheck) {
                project.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{this.rootCheckTask}));
            }
        });
    }

    @Override
    RegisterDependenciesTask getRegisterDependenciesTask() {
        return (RegisterDependenciesTask)((Object)this.registerDependenciesTask.get());
    }

    @Override
    protected void createFormatTasks(String name, FormatExtension formatExtension) {
        boolean isIdeHook = this.project.hasProperty("spotlessIdeHook");
        TaskContainer tasks = this.project.getTasks();
        TaskProvider cleanTask = tasks.named("clean");
        String taskName = "spotless" + SpotlessPlugin.capitalize(name);
        TaskProvider spotlessTask = tasks.register(taskName, SpotlessTaskImpl.class, task -> {
            task.setEnabled(!isIdeHook);
            task.mustRunAfter(new Object[]{cleanTask});
        });
        this.project.afterEvaluate(unused -> spotlessTask.configure(task -> {
            for (Action<FormatExtension> lazyAction : formatExtension.lazyActions) {
                lazyAction.execute((Object)formatExtension);
            }
            formatExtension.setupTask((SpotlessTask)((Object)((Object)task)));
        }));
        TaskProvider applyTask = tasks.register(taskName + "Apply", SpotlessApply.class, task -> {
            task.setEnabled(!isIdeHook);
            task.dependsOn(new Object[]{spotlessTask});
            task.setSpotlessOutDirectory(((SpotlessTaskImpl)((Object)((Object)spotlessTask.get()))).getOutputDirectory());
            task.linkSource((SpotlessTask)((Object)((Object)spotlessTask.get())));
        });
        this.rootApplyTask.configure(task -> {
            task.dependsOn(new Object[]{applyTask});
            if (isIdeHook) {
                task.doLast(unused -> IdeHook.performHook((SpotlessTask)((Object)((Object)((Object)spotlessTask.get())))));
            }
        });
        TaskProvider checkTask = tasks.register(taskName + "Check", SpotlessCheck.class, task -> {
            task.setEnabled(!isIdeHook);
            task.dependsOn(new Object[]{spotlessTask});
            task.setSpotlessOutDirectory(((SpotlessTaskImpl)((Object)((Object)spotlessTask.get()))).getOutputDirectory());
            task.source = (SpotlessTask)((Object)((Object)spotlessTask.get()));
            task.mustRunAfter(new Object[]{applyTask});
        });
        this.rootCheckTask.configure(task -> task.dependsOn(new Object[]{checkTask}));
        TaskProvider diagnoseTask = tasks.register(taskName + "Diagnose", SpotlessDiagnoseTask.class, task -> {
            task.source = (SpotlessTask)((Object)((Object)spotlessTask.get()));
            task.mustRunAfter(new Object[]{cleanTask});
        });
        this.rootDiagnoseTask.configure(task -> task.dependsOn(new Object[]{diagnoseTask}));
    }
}

