/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

@CacheableTask
public class SpotlessTaskImpl
extends SpotlessTask {
    @TaskAction
    public void performAction(InputChanges inputs) throws Exception {
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> target'");
        }
        if (!inputs.isIncremental()) {
            this.getLogger().info("Not incremental: removing prior outputs");
            this.getProject().delete(new Object[]{this.outputDirectory});
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        try (Formatter formatter = this.buildFormatter();){
            for (FileChange fileChange : inputs.getFileChanges(this.target)) {
                File input = fileChange.getFile();
                if (fileChange.getChangeType() == ChangeType.REMOVED) {
                    this.deletePreviousResult(input);
                    continue;
                }
                if (!input.isFile()) continue;
                this.processInputFile(formatter, input);
            }
        }
    }

    private void processInputFile(Formatter formatter, File input) throws IOException {
        File output = this.getOutputFile(input);
        this.getLogger().debug("Applying format to " + input + " and writing to " + output);
        PaddedCell.DirtyState dirtyState = this.ratchet != null && this.ratchet.isClean(this.getProject(), this.rootTreeSha, input) ? PaddedCell.isClean() : PaddedCell.calculateDirtyState((Formatter)formatter, (File)input);
        if (dirtyState.isClean()) {
            Files.deleteIfExists(output.toPath());
        } else if (dirtyState.didNotConverge()) {
            this.getLogger().warn("Skipping '" + input + "' because it does not converge.  Run `spotlessDiagnose` to understand why");
        } else {
            Path parentDir = output.toPath().getParent();
            if (parentDir == null) {
                throw new IllegalStateException("Every file has a parent folder.");
            }
            Files.createDirectories(parentDir, new FileAttribute[0]);
            Files.copy(input.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            dirtyState.writeCanonicalTo(output);
        }
    }

    private void deletePreviousResult(File input) throws IOException {
        File output = this.getOutputFile(input);
        if (output.isDirectory()) {
            Files.walk(output.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        } else {
            Files.deleteIfExists(output.toPath());
        }
    }

    private File getOutputFile(File input) {
        String outputFileName = FormatExtension.relativize(this.getProject().getProjectDir(), input);
        if (outputFileName == null) {
            throw new IllegalArgumentException(StringPrinter.buildString(printer -> {
                printer.println("Spotless error! All target files must be within the project root. In project " + this.getProject().getPath());
                printer.println("  root dir: " + this.getProject().getProjectDir().getAbsolutePath());
                printer.println("    target: " + input.getAbsolutePath());
            }));
        }
        return new File(this.outputDirectory, outputFileName);
    }
}

