/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.api;

import java.io.Serializable;

public class DocumentType
implements Serializable,
Comparable<DocumentType> {
    public static final DocumentType MS_WORD = new DocumentType("application", "vnd.com.documents4j.any-msword");
    public static final DocumentType RTF = new DocumentType("application", "rtf");
    public static final DocumentType DOCX = new DocumentType("application", "vnd.openxmlformats-officedocument.wordprocessingml.document");
    public static final DocumentType DOC = new DocumentType("application", "msword");
    public static final DocumentType MS_EXCEL = new DocumentType("application", "vnd.com.documents4j.any-msexcel");
    public static final DocumentType XLSX = new DocumentType("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    public static final DocumentType XLS = new DocumentType("application", "vnd.ms-excel");
    public static final DocumentType ODS = new DocumentType("application", "vnd.oasis.opendocument.spreadsheet");
    public static final DocumentType CSV = new DocumentType("text", "csv");
    public static final DocumentType XML = new DocumentType("application", "xml");
    public static final DocumentType MHTML = new DocumentType("application", "x-mimearchive");
    public static final DocumentType HTML = new DocumentType("text", "html");
    public static final DocumentType PDF = new DocumentType("application", "pdf");
    public static final DocumentType PDFA = new DocumentType("application", "vnd.com.documents4j.pdf-a");
    public static final DocumentType TEXT = new DocumentType("text", "plain");
    private final String type;
    private final String subtype;

    public DocumentType(String type, String subtype) {
        if (type == null || subtype == null) {
            throw new NullPointerException("Type elements must not be null");
        }
        this.type = type;
        this.subtype = subtype;
    }

    public DocumentType(String fullType) {
        int separator = fullType.indexOf(47);
        if (separator == -1 || fullType.length() == separator + 1) {
            throw new IllegalArgumentException("Not a legal */* document type: " + fullType);
        }
        this.type = fullType.substring(0, separator);
        this.subtype = fullType.substring(separator + 1);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DocumentType documentType = (DocumentType)other;
        return this.subtype.equals(documentType.subtype) && this.type.equals(documentType.type);
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.subtype.hashCode();
    }

    @Override
    public int compareTo(DocumentType other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        return this.type + "/" + this.subtype;
    }

    public static class Value {
        public static final String APPLICATION = "application";
        public static final String TEXT = "text";
        public static final String DOC = "msword";
        public static final String DOCX = "vnd.openxmlformats-officedocument.wordprocessingml.document";
        public static final String WORD_ANY = "vnd.com.documents4j.any-msword";
        public static final String XLS = "vnd.ms-excel";
        public static final String XLSX = "vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        public static final String EXCEL_ANY = "vnd.com.documents4j.any-msexcel";
        public static final String ODS = "vnd.oasis.opendocument.spreadsheet";
        public static final String PDF = "pdf";
        public static final String PDFA = "vnd.com.documents4j.pdf-a";
        public static final String RTF = "rtf";
        public static final String XML = "xml";
        public static final String MHTML = "x-mimearchive";
        public static final String HTML = "html";
        public static final String CSV = "csv";
        public static final String PLAIN = "plain";

        private Value() {
            throw new UnsupportedOperationException();
        }
    }
}

