/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion.msoffice;

import com.documents4j.api.DocumentType;
import com.documents4j.conversion.AbstractExternalConverter;
import com.documents4j.conversion.ExternalConverterScriptResult;
import com.documents4j.conversion.ProcessFutureWrapper;
import com.documents4j.conversion.msoffice.MicrosoftOfficeFormat;
import com.documents4j.conversion.msoffice.MicrosoftOfficeScript;
import com.documents4j.conversion.msoffice.MicrosoftOfficeTargetNameCorrector;
import com.documents4j.throwables.ConverterAccessException;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.listener.ProcessListener;

public abstract class AbstractMicrosoftOfficeBridge
extends AbstractExternalConverter {
    private final File conversionScript;

    protected AbstractMicrosoftOfficeBridge(File baseFolder, long processTimeout, TimeUnit processTimeoutUnit, MicrosoftOfficeScript conversionScript) {
        super(baseFolder, processTimeout, processTimeoutUnit);
        this.conversionScript = conversionScript.materializeIn(baseFolder);
    }

    protected void tryStart(MicrosoftOfficeScript startupScript) {
        ExternalConverterScriptResult.from((int)this.runNoArgumentScript(startupScript)).resolve();
    }

    protected void tryStop(MicrosoftOfficeScript startupScript) {
        try {
            ExternalConverterScriptResult.from((int)this.runNoArgumentScript(startupScript)).resolve();
        }
        finally {
            this.tryDelete(this.conversionScript);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runNoArgumentScript(MicrosoftOfficeScript microsoftOfficeScript) {
        File script = microsoftOfficeScript.materializeIn(this.getBaseFolder());
        try {
            int n = this.runNoArgumentScript(script);
            return n;
        }
        finally {
            this.tryDelete(script);
        }
    }

    public Future<Boolean> startConversion(File source, DocumentType sourceType, File target, DocumentType targetType) {
        return new ProcessFutureWrapper(this.doStartConversion(source, sourceType, target, targetType));
    }

    protected StartedProcess doStartConversion(File source, DocumentType sourceType, File target, DocumentType targetType) {
        this.getLogger().info("Requested conversion from {} ({}) to {} ({})", new Object[]{source, sourceType, target, targetType});
        try {
            MicrosoftOfficeFormat microsoftOfficeFormat = this.formatOf(targetType);
            return this.makePresetProcessExecutor().command(new String[]{"cmd", "/C", AbstractMicrosoftOfficeBridge.quote((String[])new String[]{this.conversionScript.getAbsolutePath(), source.getAbsolutePath(), target.getAbsolutePath(), microsoftOfficeFormat.getValue()})}).destroyOnExit().addListener((ProcessListener)this.targetNameCorrector(target, microsoftOfficeFormat.getFileExtension())).start();
        }
        catch (IOException e) {
            String message = String.format("Could not start shell script ('%s') for conversion of '%s' (%s) to '%s' (%s)", this.conversionScript, source, sourceType, target, targetType);
            this.getLogger().error(message, (Throwable)e);
            throw new ConverterAccessException(message, (Throwable)e);
        }
    }

    protected abstract MicrosoftOfficeTargetNameCorrector targetNameCorrector(File var1, String var2);

    protected abstract MicrosoftOfficeFormat formatOf(DocumentType var1);

    protected abstract MicrosoftOfficeScript getAssertionScript();

    protected abstract Logger getLogger();

    public boolean isOperational() {
        return this.conversionScript.isFile() && this.runNoArgumentScript(this.getAssertionScript()) == ExternalConverterScriptResult.CONVERTER_INTERACTION_SUCCESSFUL.getExitValue().intValue();
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("baseFolder", (Object)this.getBaseFolder()).add("processTimeout", this.getProcessTimeout()).toString();
    }
}

