/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.util;

import com.documents4j.throwables.ConversionFormatException;
import com.documents4j.throwables.ConversionInputException;
import com.documents4j.throwables.ConverterAccessException;
import com.documents4j.throwables.ConverterException;
import com.documents4j.throwables.FileSystemInteractionException;
import com.google.common.base.Objects;

public abstract class Reaction {
    Reaction() {
    }

    public static Reaction with(boolean value) {
        return new BooleanReaction(value);
    }

    public static Reaction with(IExceptionBuilder builder) {
        return new ExceptionalReaction(builder);
    }

    public abstract boolean apply();

    public static class FileSystemInteractionExceptionBuilder
    implements IExceptionBuilder {
        private final String message;

        public FileSystemInteractionExceptionBuilder(String message) {
            this.message = message;
        }

        @Override
        public RuntimeException make() {
            return new FileSystemInteractionException(this.message);
        }

        public String toString() {
            return Objects.toStringHelper(ConversionInputExceptionBuilder.class).add("message", (Object)this.message).toString();
        }
    }

    public static class ConversionInputExceptionBuilder
    implements IExceptionBuilder {
        private final String message;

        public ConversionInputExceptionBuilder(String message) {
            this.message = message;
        }

        @Override
        public RuntimeException make() {
            return new ConversionInputException(this.message);
        }

        public String toString() {
            return Objects.toStringHelper(ConversionInputExceptionBuilder.class).add("message", (Object)this.message).toString();
        }
    }

    public static class ConversionFormatExceptionBuilder
    implements IExceptionBuilder {
        private final String message;

        public ConversionFormatExceptionBuilder(String message) {
            this.message = message;
        }

        @Override
        public RuntimeException make() {
            return new ConversionFormatException(this.message);
        }

        public String toString() {
            return Objects.toStringHelper(ConversionFormatExceptionBuilder.class).add("message", (Object)this.message).toString();
        }
    }

    public static class ConverterAccessExceptionBuilder
    implements IExceptionBuilder {
        private final String message;

        public ConverterAccessExceptionBuilder(String message) {
            this.message = message;
        }

        @Override
        public RuntimeException make() {
            return new ConverterAccessException(this.message);
        }

        public String toString() {
            return Objects.toStringHelper(ConverterAccessExceptionBuilder.class).add("message", (Object)this.message).toString();
        }
    }

    public static class ConverterExceptionBuilder
    implements IExceptionBuilder {
        private final String message;

        public ConverterExceptionBuilder(String message) {
            this.message = message;
        }

        @Override
        public RuntimeException make() {
            return new ConverterException(this.message);
        }

        public String toString() {
            return Objects.toStringHelper(ConverterExceptionBuilder.class).add("message", (Object)this.message).toString();
        }
    }

    private static class ExceptionalReaction
    extends Reaction {
        private final IExceptionBuilder builder;

        public ExceptionalReaction(IExceptionBuilder builder) {
            this.builder = builder;
        }

        @Override
        public boolean apply() {
            throw this.builder.make();
        }

        public String toString() {
            return Objects.toStringHelper(BooleanReaction.class).add("exceptionBuilder", (Object)this.builder).toString();
        }
    }

    private static class BooleanReaction
    extends Reaction {
        private final boolean value;

        public BooleanReaction(boolean value) {
            this.value = value;
        }

        @Override
        public boolean apply() {
            return this.value;
        }

        public String toString() {
            return Objects.toStringHelper(BooleanReaction.class).add("value", this.value).toString();
        }
    }

    public static interface IExceptionBuilder {
        public RuntimeException make();
    }
}

