/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.builder;

import com.documents4j.api.IConverter;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.util.concurrent.TimeUnit;

public abstract class AbstractConverterBuilder<T extends AbstractConverterBuilder<T>> {
    public static final int DEFAULT_CORE_POOL_SIZE = 15;
    protected int corePoolSize = 15;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 30;
    protected int maximumPoolSize = 30;
    public static final long DEFAULT_KEEP_ALIVE_TIME = TimeUnit.MINUTES.toMillis(10L);
    protected long keepAliveTime = DEFAULT_KEEP_ALIVE_TIME;
    protected File baseFolder;

    protected static void assertNumericArgument(long number, boolean zeroAllowed) {
        AbstractConverterBuilder.assertNumericArgument(number, zeroAllowed, Long.MAX_VALUE);
    }

    protected static void assertNumericArgument(long number, boolean zeroAllowed, long maximum) {
        Preconditions.checkArgument(((zeroAllowed && number == 0L || number > 0L) && number < maximum ? 1 : 0) != 0);
    }

    private static void assertSmallerEquals(int first, int second) {
        Preconditions.checkArgument((first <= second ? 1 : 0) != 0);
    }

    public T baseFolder(File baseFolder) {
        this.baseFolder = baseFolder;
        return (T)this;
    }

    public T workerPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        AbstractConverterBuilder.assertNumericArgument(corePoolSize, true);
        AbstractConverterBuilder.assertNumericArgument(maximumPoolSize, false);
        AbstractConverterBuilder.assertSmallerEquals(corePoolSize, maximumPoolSize);
        AbstractConverterBuilder.assertNumericArgument(keepAliveTime, true);
        AbstractConverterBuilder.assertNumericArgument(keepAliveTime, true);
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveTime = unit.toMillis(keepAliveTime);
        return (T)this;
    }

    protected File normalizedBaseFolder() {
        return this.baseFolder == null ? Files.createTempDir() : this.baseFolder;
    }

    public abstract IConverter build();

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }
}

