/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.IConversionJobWithSourceSpecified;
import com.documents4j.api.IConversionJobWithTargetUnspecified;
import com.documents4j.api.IFileConsumer;
import com.documents4j.api.IInputStreamConsumer;
import com.documents4j.job.FileConsumerToInputStreamConsumer;
import com.documents4j.job.InputStreamConsumerToFileConsumer;
import com.documents4j.job.NoopFileConsumer;
import com.documents4j.job.OutputStreamToInputStreamConsumer;
import java.io.File;
import java.io.OutputStream;

abstract class ConversionJobWithSourceSpecifiedAdapter
implements IConversionJobWithSourceSpecified {
    private static final String PDF_FILE_EXTENSION = ".pdf";
    static final boolean DEFAULT_CLOSE_STREAM = true;

    ConversionJobWithSourceSpecifiedAdapter() {
    }

    public IConversionJobWithTargetUnspecified to(File target) {
        return this.to(target, new NoopFileConsumer());
    }

    public IConversionJobWithTargetUnspecified to(File target, IFileConsumer callback) {
        return this.to(new FileConsumerToInputStreamConsumer(target, callback));
    }

    public IConversionJobWithTargetUnspecified to(OutputStream target) {
        return this.to(target, true);
    }

    public IConversionJobWithTargetUnspecified to(OutputStream target, boolean closeStream) {
        return this.to(new OutputStreamToInputStreamConsumer(target, closeStream));
    }

    public IConversionJobWithTargetUnspecified to(IInputStreamConsumer callback) {
        return this.to(this.makeTemporaryFile(PDF_FILE_EXTENSION), new InputStreamConsumerToFileConsumer(callback));
    }

    protected abstract File makeTemporaryFile(String var1);
}

