/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeleteFileOnCloseInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteFileOnCloseInputStream.class);
    private final File file;
    private final InputStream underlyingInputStream;
    private final AtomicBoolean deletedMark;

    public DeleteFileOnCloseInputStream(File file) throws IOException {
        this.file = file;
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
        this.underlyingInputStream = fileInputStream;
        this.deletedMark = new AtomicBoolean(false);
    }

    @Override
    public int read() throws IOException {
        return this.underlyingInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.underlyingInputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.underlyingInputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.underlyingInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.underlyingInputStream.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.underlyingInputStream.close();
        }
        finally {
            if (this.deletedMark.compareAndSet(false, true) && !this.file.delete()) {
                LOGGER.warn("Could not delete file {} after input stream was closed", (Object)this.file);
            }
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.underlyingInputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.underlyingInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.underlyingInputStream.markSupported();
    }
}

