/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.BulkProcessRequest;
import com.docusign.esign.model.BulkProcessResponse;
import com.docusign.esign.model.BulkProcessResult;
import com.docusign.esign.model.BulkProcessingListSummaries;
import com.docusign.esign.model.BulkProcessingLists;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class BulkProcessDataApi {
    private ApiClient apiClient;

    public BulkProcessDataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BulkProcessDataApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void createBulkProcessRequest(String accountId, String processAction) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkProcessRequest");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling createBulkProcessRequest");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BulkProcessResponse createBulkProcessRequestToQueue(String accountId, String processAction, String bulkProcessListId, BulkProcessRequest bulkProcessRequest) throws ApiException {
        BulkProcessRequest localVarPostBody = bulkProcessRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkProcessRequestToQueue");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling createBulkProcessRequestToQueue");
        }
        if (bulkProcessListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkProcessListId' when calling createBulkProcessRequestToQueue");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString())).replaceAll("\\{bulkProcessListId\\}", this.apiClient.escapeString(bulkProcessListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkProcessResponse> localVarReturnType = new GenericType<BulkProcessResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkProcessResult deleteBulkProcessList(String accountId, String processAction, String bulkProcessListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteBulkProcessList");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling deleteBulkProcessList");
        }
        if (bulkProcessListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkProcessListId' when calling deleteBulkProcessList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString())).replaceAll("\\{bulkProcessListId\\}", this.apiClient.escapeString(bulkProcessListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkProcessResult> localVarReturnType = new GenericType<BulkProcessResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BulkProcessResult deleteBulkProcessLists(String accountId, String processAction, BulkProcessingLists bulkProcessingLists) throws ApiException {
        BulkProcessingLists localVarPostBody = bulkProcessingLists;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteBulkProcessLists");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling deleteBulkProcessLists");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkProcessResult> localVarReturnType = new GenericType<BulkProcessResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void getBulkProcessList(String accountId, String processAction, String bulkProcessListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkProcessList");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling getBulkProcessList");
        }
        if (bulkProcessListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkProcessListId' when calling getBulkProcessList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString())).replaceAll("\\{bulkProcessListId\\}", this.apiClient.escapeString(bulkProcessListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BulkProcessingListSummaries getBulkProcessLists(String accountId, String processAction) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkProcessLists");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling getBulkProcessLists");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkProcessingListSummaries> localVarReturnType = new GenericType<BulkProcessingListSummaries>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateBulkProcessList(String accountId, String processAction, String bulkProcessListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBulkProcessList");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling updateBulkProcessList");
        }
        if (bulkProcessListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkProcessListId' when calling updateBulkProcessList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString())).replaceAll("\\{bulkProcessListId\\}", this.apiClient.escapeString(bulkProcessListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

