/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AppStoreProduct;
import com.docusign.esign.model.CurrencyPlanPrice;
import com.docusign.esign.model.FeatureSet;
import com.docusign.esign.model.SeatDiscount;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains information about a billing plan.")
public class BillingPlan {
    @JsonProperty(value="appStoreProducts")
    private List<AppStoreProduct> appStoreProducts = null;
    @JsonProperty(value="currencyPlanPrices")
    private List<CurrencyPlanPrice> currencyPlanPrices = null;
    @JsonProperty(value="enableSupport")
    private String enableSupport = null;
    @JsonProperty(value="includedSeats")
    private String includedSeats = null;
    @JsonProperty(value="otherDiscountPercent")
    private String otherDiscountPercent = null;
    @JsonProperty(value="paymentCycle")
    private String paymentCycle = null;
    @JsonProperty(value="paymentMethod")
    private String paymentMethod = null;
    @JsonProperty(value="perSeatPrice")
    private String perSeatPrice = null;
    @JsonProperty(value="planClassification")
    private String planClassification = null;
    @JsonProperty(value="planFeatureSets")
    private List<FeatureSet> planFeatureSets = null;
    @JsonProperty(value="planId")
    private String planId = null;
    @JsonProperty(value="planName")
    private String planName = null;
    @JsonProperty(value="seatDiscounts")
    private List<SeatDiscount> seatDiscounts = null;
    @JsonProperty(value="supportIncidentFee")
    private String supportIncidentFee = null;
    @JsonProperty(value="supportPlanFee")
    private String supportPlanFee = null;

    public BillingPlan appStoreProducts(List<AppStoreProduct> appStoreProducts) {
        this.appStoreProducts = appStoreProducts;
        return this;
    }

    public BillingPlan addAppStoreProductsItem(AppStoreProduct appStoreProductsItem) {
        if (this.appStoreProducts == null) {
            this.appStoreProducts = new ArrayList<AppStoreProduct>();
        }
        this.appStoreProducts.add(appStoreProductsItem);
        return this;
    }

    @ApiModelProperty(value="Reserved: TBD")
    public List<AppStoreProduct> getAppStoreProducts() {
        return this.appStoreProducts;
    }

    public void setAppStoreProducts(List<AppStoreProduct> appStoreProducts) {
        this.appStoreProducts = appStoreProducts;
    }

    public BillingPlan currencyPlanPrices(List<CurrencyPlanPrice> currencyPlanPrices) {
        this.currencyPlanPrices = currencyPlanPrices;
        return this;
    }

    public BillingPlan addCurrencyPlanPricesItem(CurrencyPlanPrice currencyPlanPricesItem) {
        if (this.currencyPlanPrices == null) {
            this.currencyPlanPrices = new ArrayList<CurrencyPlanPrice>();
        }
        this.currencyPlanPrices.add(currencyPlanPricesItem);
        return this;
    }

    @ApiModelProperty(value="Contains the currencyCode and currencySymbol for the alternate currency values for envelopeFee, fixedFee, and seatFee that are configured for this plan feature set.")
    public List<CurrencyPlanPrice> getCurrencyPlanPrices() {
        return this.currencyPlanPrices;
    }

    public void setCurrencyPlanPrices(List<CurrencyPlanPrice> currencyPlanPrices) {
        this.currencyPlanPrices = currencyPlanPrices;
    }

    public BillingPlan enableSupport(String enableSupport) {
        this.enableSupport = enableSupport;
        return this;
    }

    @ApiModelProperty(value="When set to **true**, then customer support is provided as part of the account plan.")
    public String getEnableSupport() {
        return this.enableSupport;
    }

    public void setEnableSupport(String enableSupport) {
        this.enableSupport = enableSupport;
    }

    public BillingPlan includedSeats(String includedSeats) {
        this.includedSeats = includedSeats;
        return this;
    }

    @ApiModelProperty(value="The number of seats (users) included.")
    public String getIncludedSeats() {
        return this.includedSeats;
    }

    public void setIncludedSeats(String includedSeats) {
        this.includedSeats = includedSeats;
    }

    public BillingPlan otherDiscountPercent(String otherDiscountPercent) {
        this.otherDiscountPercent = otherDiscountPercent;
        return this;
    }

    @ApiModelProperty(value="")
    public String getOtherDiscountPercent() {
        return this.otherDiscountPercent;
    }

    public void setOtherDiscountPercent(String otherDiscountPercent) {
        this.otherDiscountPercent = otherDiscountPercent;
    }

    public BillingPlan paymentCycle(String paymentCycle) {
        this.paymentCycle = paymentCycle;
        return this;
    }

    @ApiModelProperty(value=" The payment cycle associated with the plan. The possible values are: Monthly or Annually. ")
    public String getPaymentCycle() {
        return this.paymentCycle;
    }

    public void setPaymentCycle(String paymentCycle) {
        this.paymentCycle = paymentCycle;
    }

    public BillingPlan paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public BillingPlan perSeatPrice(String perSeatPrice) {
        this.perSeatPrice = perSeatPrice;
        return this;
    }

    @ApiModelProperty(value="The per seat price for the plan.")
    public String getPerSeatPrice() {
        return this.perSeatPrice;
    }

    public void setPerSeatPrice(String perSeatPrice) {
        this.perSeatPrice = perSeatPrice;
    }

    public BillingPlan planClassification(String planClassification) {
        this.planClassification = planClassification;
        return this;
    }

    @ApiModelProperty(value="Identifies the type of plan. Examples include Business, Corporate, Enterprise, Free.")
    public String getPlanClassification() {
        return this.planClassification;
    }

    public void setPlanClassification(String planClassification) {
        this.planClassification = planClassification;
    }

    public BillingPlan planFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
        return this;
    }

    public BillingPlan addPlanFeatureSetsItem(FeatureSet planFeatureSetsItem) {
        if (this.planFeatureSets == null) {
            this.planFeatureSets = new ArrayList<FeatureSet>();
        }
        this.planFeatureSets.add(planFeatureSetsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<FeatureSet> getPlanFeatureSets() {
        return this.planFeatureSets;
    }

    public void setPlanFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
    }

    public BillingPlan planId(String planId) {
        this.planId = planId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public BillingPlan planName(String planName) {
        this.planName = planName;
        return this;
    }

    @ApiModelProperty(value="The name of the Billing Plan.")
    public String getPlanName() {
        return this.planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public BillingPlan seatDiscounts(List<SeatDiscount> seatDiscounts) {
        this.seatDiscounts = seatDiscounts;
        return this;
    }

    public BillingPlan addSeatDiscountsItem(SeatDiscount seatDiscountsItem) {
        if (this.seatDiscounts == null) {
            this.seatDiscounts = new ArrayList<SeatDiscount>();
        }
        this.seatDiscounts.add(seatDiscountsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<SeatDiscount> getSeatDiscounts() {
        return this.seatDiscounts;
    }

    public void setSeatDiscounts(List<SeatDiscount> seatDiscounts) {
        this.seatDiscounts = seatDiscounts;
    }

    public BillingPlan supportIncidentFee(String supportIncidentFee) {
        this.supportIncidentFee = supportIncidentFee;
        return this;
    }

    @ApiModelProperty(value="The support incident fee charged for each support incident.")
    public String getSupportIncidentFee() {
        return this.supportIncidentFee;
    }

    public void setSupportIncidentFee(String supportIncidentFee) {
        this.supportIncidentFee = supportIncidentFee;
    }

    public BillingPlan supportPlanFee(String supportPlanFee) {
        this.supportPlanFee = supportPlanFee;
        return this;
    }

    @ApiModelProperty(value="The support plan fee charged for this plan.")
    public String getSupportPlanFee() {
        return this.supportPlanFee;
    }

    public void setSupportPlanFee(String supportPlanFee) {
        this.supportPlanFee = supportPlanFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingPlan billingPlan = (BillingPlan)o;
        return Objects.equals(this.appStoreProducts, billingPlan.appStoreProducts) && Objects.equals(this.currencyPlanPrices, billingPlan.currencyPlanPrices) && Objects.equals(this.enableSupport, billingPlan.enableSupport) && Objects.equals(this.includedSeats, billingPlan.includedSeats) && Objects.equals(this.otherDiscountPercent, billingPlan.otherDiscountPercent) && Objects.equals(this.paymentCycle, billingPlan.paymentCycle) && Objects.equals(this.paymentMethod, billingPlan.paymentMethod) && Objects.equals(this.perSeatPrice, billingPlan.perSeatPrice) && Objects.equals(this.planClassification, billingPlan.planClassification) && Objects.equals(this.planFeatureSets, billingPlan.planFeatureSets) && Objects.equals(this.planId, billingPlan.planId) && Objects.equals(this.planName, billingPlan.planName) && Objects.equals(this.seatDiscounts, billingPlan.seatDiscounts) && Objects.equals(this.supportIncidentFee, billingPlan.supportIncidentFee) && Objects.equals(this.supportPlanFee, billingPlan.supportPlanFee);
    }

    public int hashCode() {
        return Objects.hash(this.appStoreProducts, this.currencyPlanPrices, this.enableSupport, this.includedSeats, this.otherDiscountPercent, this.paymentCycle, this.paymentMethod, this.perSeatPrice, this.planClassification, this.planFeatureSets, this.planId, this.planName, this.seatDiscounts, this.supportIncidentFee, this.supportPlanFee);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingPlan {\n");
        sb.append("    appStoreProducts: ").append(this.toIndentedString(this.appStoreProducts)).append("\n");
        sb.append("    currencyPlanPrices: ").append(this.toIndentedString(this.currencyPlanPrices)).append("\n");
        sb.append("    enableSupport: ").append(this.toIndentedString(this.enableSupport)).append("\n");
        sb.append("    includedSeats: ").append(this.toIndentedString(this.includedSeats)).append("\n");
        sb.append("    otherDiscountPercent: ").append(this.toIndentedString(this.otherDiscountPercent)).append("\n");
        sb.append("    paymentCycle: ").append(this.toIndentedString(this.paymentCycle)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    perSeatPrice: ").append(this.toIndentedString(this.perSeatPrice)).append("\n");
        sb.append("    planClassification: ").append(this.toIndentedString(this.planClassification)).append("\n");
        sb.append("    planFeatureSets: ").append(this.toIndentedString(this.planFeatureSets)).append("\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    planName: ").append(this.toIndentedString(this.planName)).append("\n");
        sb.append("    seatDiscounts: ").append(this.toIndentedString(this.seatDiscounts)).append("\n");
        sb.append("    supportIncidentFee: ").append(this.toIndentedString(this.supportIncidentFee)).append("\n");
        sb.append("    supportPlanFee: ").append(this.toIndentedString(this.supportPlanFee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

