/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.DocumentUpdateInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CompleteSignRequest {
    @JsonProperty(value="certificate")
    private String certificate = null;
    @JsonProperty(value="correlationId")
    private String correlationId = null;
    @JsonProperty(value="documentUpdateInfos")
    private List<DocumentUpdateInfo> documentUpdateInfos = null;
    @JsonProperty(value="maxSignatureLength")
    private String maxSignatureLength = null;
    @JsonProperty(value="signingLocation")
    private String signingLocation = null;
    @JsonProperty(value="transactionId")
    private String transactionId = null;

    public CompleteSignRequest certificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    @ApiModelProperty(value="")
    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public CompleteSignRequest correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public CompleteSignRequest documentUpdateInfos(List<DocumentUpdateInfo> documentUpdateInfos) {
        this.documentUpdateInfos = documentUpdateInfos;
        return this;
    }

    public CompleteSignRequest addDocumentUpdateInfosItem(DocumentUpdateInfo documentUpdateInfosItem) {
        if (this.documentUpdateInfos == null) {
            this.documentUpdateInfos = new ArrayList<DocumentUpdateInfo>();
        }
        this.documentUpdateInfos.add(documentUpdateInfosItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<DocumentUpdateInfo> getDocumentUpdateInfos() {
        return this.documentUpdateInfos;
    }

    public void setDocumentUpdateInfos(List<DocumentUpdateInfo> documentUpdateInfos) {
        this.documentUpdateInfos = documentUpdateInfos;
    }

    public CompleteSignRequest maxSignatureLength(String maxSignatureLength) {
        this.maxSignatureLength = maxSignatureLength;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMaxSignatureLength() {
        return this.maxSignatureLength;
    }

    public void setMaxSignatureLength(String maxSignatureLength) {
        this.maxSignatureLength = maxSignatureLength;
    }

    public CompleteSignRequest signingLocation(String signingLocation) {
        this.signingLocation = signingLocation;
        return this;
    }

    @ApiModelProperty(value="Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.")
    public String getSigningLocation() {
        return this.signingLocation;
    }

    public void setSigningLocation(String signingLocation) {
        this.signingLocation = signingLocation;
    }

    public CompleteSignRequest transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value=" Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteSignRequest completeSignRequest = (CompleteSignRequest)o;
        return Objects.equals(this.certificate, completeSignRequest.certificate) && Objects.equals(this.correlationId, completeSignRequest.correlationId) && Objects.equals(this.documentUpdateInfos, completeSignRequest.documentUpdateInfos) && Objects.equals(this.maxSignatureLength, completeSignRequest.maxSignatureLength) && Objects.equals(this.signingLocation, completeSignRequest.signingLocation) && Objects.equals(this.transactionId, completeSignRequest.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.correlationId, this.documentUpdateInfos, this.maxSignatureLength, this.signingLocation, this.transactionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompleteSignRequest {\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    documentUpdateInfos: ").append(this.toIndentedString(this.documentUpdateInfos)).append("\n");
        sb.append("    maxSignatureLength: ").append(this.toIndentedString(this.maxSignatureLength)).append("\n");
        sb.append("    signingLocation: ").append(this.toIndentedString(this.signingLocation)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

