/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import com.dslplatform.json.BinaryConverter;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.StringConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AndroidGeomConverter {
    static final JsonReader.ReadObject<PointF> LocationReader = new JsonReader.ReadObject<PointF>(){

        @Override
        public PointF read(JsonReader reader) throws IOException {
            return AndroidGeomConverter.deserializeLocation(reader);
        }
    };
    static final JsonWriter.WriteObject<PointF> LocationWriter = new JsonWriter.WriteObject<PointF>(){

        @Override
        public void write(JsonWriter writer, PointF value) {
            AndroidGeomConverter.serializeLocationNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Point> PointReader = new JsonReader.ReadObject<Point>(){

        @Override
        public Point read(JsonReader reader) throws IOException {
            return AndroidGeomConverter.deserializePoint(reader);
        }
    };
    static final JsonWriter.WriteObject<Point> PointWriter = new JsonWriter.WriteObject<Point>(){

        @Override
        public void write(JsonWriter writer, Point value) {
            AndroidGeomConverter.serializePointNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Rect> RectangleReader = new JsonReader.ReadObject<Rect>(){

        @Override
        public Rect read(JsonReader reader) throws IOException {
            return AndroidGeomConverter.deserializeRectangle(reader);
        }
    };
    static final JsonWriter.WriteObject<Rect> RectangleWriter = new JsonWriter.WriteObject<Rect>(){

        @Override
        public void write(JsonWriter writer, Rect value) {
            AndroidGeomConverter.serializeRectangleNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<Bitmap> ImageReader = new JsonReader.ReadObject<Bitmap>(){

        @Override
        public Bitmap read(JsonReader reader) throws IOException {
            return AndroidGeomConverter.deserializeImage(reader);
        }
    };
    static final JsonWriter.WriteObject<Bitmap> ImageWriter = new JsonWriter.WriteObject<Bitmap>(){

        @Override
        public void write(JsonWriter writer, Bitmap value) {
            AndroidGeomConverter.serialize(value, writer);
        }
    };

    public static void serializeLocationNullable(PointF value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            AndroidGeomConverter.serializeLocation(value, sw);
        }
    }

    public static void serializeLocation(PointF value, JsonWriter sw) {
        sw.writeAscii("{\"X\":");
        NumberConverter.serialize(value.x, sw);
        sw.writeAscii(",\"Y\":");
        NumberConverter.serialize(value.y, sw);
        sw.writeByte((byte)125);
    }

    public static PointF deserializeLocation(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw new IOException("Expecting '{' at position " + reader.positionInStream() + ". Found " + (char)reader.last());
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new PointF();
        }
        float x = 0.0f;
        float y = 0.0f;
        String name = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw new IOException("Expecting ':' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
        }
        reader.getNextToken();
        float value = NumberConverter.deserializeFloat(reader);
        if ("X".equalsIgnoreCase(name)) {
            x = value;
        } else if ("Y".equalsIgnoreCase(name)) {
            y = value;
        }
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            name = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw new IOException("Expecting ':' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
            }
            reader.getNextToken();
            value = NumberConverter.deserializeFloat(reader);
            if ("X".equalsIgnoreCase(name)) {
                x = value;
                continue;
            }
            if (!"Y".equalsIgnoreCase(name)) continue;
            y = value;
        }
        if (nextToken != 125) {
            throw new IOException("Expecting '}' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
        }
        return new PointF(x, y);
    }

    public static ArrayList<PointF> deserializeLocationCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(LocationReader);
    }

    public static void deserializeLocationCollection(JsonReader reader, Collection<PointF> res) throws IOException {
        reader.deserializeCollection(LocationReader, res);
    }

    public static ArrayList<PointF> deserializeLocationNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(LocationReader);
    }

    public static void deserializeLocationNullableCollection(JsonReader reader, Collection<PointF> res) throws IOException {
        reader.deserializeNullableCollection(LocationReader, res);
    }

    public static void serializePointNullable(Point value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            AndroidGeomConverter.serializePoint(value, sw);
        }
    }

    public static void serializePoint(Point value, JsonWriter sw) {
        sw.writeAscii("{\"X\":");
        NumberConverter.serialize(value.x, sw);
        sw.writeAscii(",\"Y\":");
        NumberConverter.serialize(value.y, sw);
        sw.writeByte((byte)125);
    }

    public static Point deserializePoint(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw new IOException("Expecting '{' at position " + reader.positionInStream() + ". Found " + (char)reader.last());
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new Point();
        }
        int x = 0;
        int y = 0;
        String name = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw new IOException("Expecting ':' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
        }
        reader.getNextToken();
        int value = NumberConverter.deserializeInt(reader);
        if ("X".equalsIgnoreCase(name)) {
            x = value;
        } else if ("Y".equalsIgnoreCase(name)) {
            y = value;
        }
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            name = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw new IOException("Expecting ':' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
            }
            reader.getNextToken();
            value = NumberConverter.deserializeInt(reader);
            if ("X".equalsIgnoreCase(name)) {
                x = value;
                continue;
            }
            if (!"Y".equalsIgnoreCase(name)) continue;
            y = value;
        }
        if (nextToken != 125) {
            throw new IOException("Expecting '}' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
        }
        return new Point(x, y);
    }

    public static ArrayList<Point> deserializePointCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(PointReader);
    }

    public static void deserializePointCollection(JsonReader reader, Collection<Point> res) throws IOException {
        reader.deserializeCollection(PointReader, res);
    }

    public static ArrayList<Point> deserializePointNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(PointReader);
    }

    public static void deserializePointNullableCollection(JsonReader reader, Collection<Point> res) throws IOException {
        reader.deserializeNullableCollection(PointReader, res);
    }

    public static void serializeRectangleNullable(Rect value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            AndroidGeomConverter.serializeRectangle(value, sw);
        }
    }

    public static void serializeRectangle(Rect value, JsonWriter sw) {
        sw.writeAscii("{\"X\":");
        NumberConverter.serialize(value.left, sw);
        sw.writeAscii(",\"Y\":");
        NumberConverter.serialize(value.top, sw);
        sw.writeAscii(",\"Width\":");
        NumberConverter.serialize(value.width(), sw);
        sw.writeAscii(",\"Height\":");
        NumberConverter.serialize(value.height(), sw);
        sw.writeByte((byte)125);
    }

    public static Rect deserializeRectangle(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw new IOException("Expecting '{' at position " + reader.positionInStream() + ". Found " + (char)reader.last());
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new Rect();
        }
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        String name = StringConverter.deserialize(reader);
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw new IOException("Expecting ':' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
        }
        reader.getNextToken();
        int value = NumberConverter.deserializeInt(reader);
        if ("X".equalsIgnoreCase(name)) {
            x = value;
        } else if ("Y".equalsIgnoreCase(name)) {
            y = value;
        } else if ("Width".equalsIgnoreCase(name)) {
            width = value;
        } else if ("Height".equalsIgnoreCase(name)) {
            height = value;
        }
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            name = StringConverter.deserialize(reader);
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw new IOException("Expecting ':' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
            }
            reader.getNextToken();
            value = NumberConverter.deserializeInt(reader);
            if ("X".equalsIgnoreCase(name)) {
                x = value;
                continue;
            }
            if ("Y".equalsIgnoreCase(name)) {
                y = value;
                continue;
            }
            if ("Width".equalsIgnoreCase(name)) {
                width = value;
                continue;
            }
            if (!"Height".equalsIgnoreCase(name)) continue;
            height = value;
        }
        if (nextToken != 125) {
            throw new IOException("Expecting '}' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
        }
        return new Rect(x, y, x + width, y + height);
    }

    public static ArrayList<Rect> deserializeRectangleCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(RectangleReader);
    }

    public static void deserializeRectangleCollection(JsonReader reader, Collection<Rect> res) throws IOException {
        reader.deserializeCollection(RectangleReader, res);
    }

    public static ArrayList<Rect> deserializeRectangleNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(RectangleReader);
    }

    public static void deserializeRectangleNullableCollection(JsonReader reader, Collection<Rect> res) throws IOException {
        reader.deserializeNullableCollection(RectangleReader, res);
    }

    public static void serialize(Bitmap value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(value.getByteCount());
            value.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
            BinaryConverter.serialize(stream.toByteArray(), sw);
        }
    }

    public static Bitmap deserializeImage(JsonReader reader) throws IOException {
        byte[] content = BinaryConverter.deserialize(reader);
        return BitmapFactory.decodeByteArray((byte[])content, (int)0, (int)content.length);
    }

    public static ArrayList<Bitmap> deserializeImageCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(ImageReader);
    }

    public static void deserializeImageCollection(JsonReader reader, Collection<Bitmap> res) throws IOException {
        reader.deserializeCollection(ImageReader, res);
    }

    public static ArrayList<Bitmap> deserializeImageNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(ImageReader);
    }

    public static void deserializeImageNullableCollection(JsonReader reader, Collection<Bitmap> res) throws IOException {
        reader.deserializeNullableCollection(ImageReader, res);
    }
}

